/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.questers;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.data.SavableData;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.questers.data.QuesterData;
import fr.skytasul.quests.api.questers.data.QuesterPoolData;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.quests.Quest;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public abstract class AbstractQuesterDataImplementation
implements QuesterData {
    protected final Map<Integer, QuesterQuestData> questData = new HashMap<Integer, QuesterQuestData>();
    protected final Map<Integer, QuesterPoolData> poolData = new HashMap<Integer, QuesterPoolData>();
    protected final Map<SavableData<?>, Object> additionalData = new HashMap();

    @Override
    public boolean hasQuestData(@NotNull Quest quest) {
        return this.questData.containsKey(quest.getId());
    }

    @Override
    @NotNull
    public Optional<QuesterQuestData> getQuestDataIfPresent(@NotNull Quest quest) {
        return Optional.ofNullable(this.questData.get(quest.getId()));
    }

    @Override
    @NotNull
    public QuesterQuestData getQuestData(@NotNull Quest quest) {
        QuesterQuestData data = this.questData.get(quest.getId());
        if (data == null) {
            data = this.createQuestData(quest);
            this.questData.put(quest.getId(), data);
        }
        return data;
    }

    @NotNull
    protected abstract QuesterQuestData createQuestData(@NotNull Quest var1);

    @Override
    @NotNull
    public CompletableFuture<QuesterQuestData> removeQuestData(@NotNull Quest quest) {
        return this.removeQuestData(quest.getId());
    }

    @Override
    @NotNull
    public CompletableFuture<QuesterQuestData> removeQuestData(int id) {
        QuesterQuestData removed = this.questData.remove(id);
        if (removed == null) {
            return CompletableFuture.completedFuture(null);
        }
        return removed.remove().thenApply(__ -> removed);
    }

    public @UnmodifiableView @NotNull Collection<QuesterQuestData> getAllQuestsData() {
        return this.questData.values();
    }

    @Override
    public boolean hasPoolData(@NotNull QuestPool pool) {
        return this.poolData.containsKey(pool.getId());
    }

    @Override
    @NotNull
    public QuesterPoolData getPoolData(@NotNull QuestPool pool) {
        QuesterPoolData datas = this.poolData.get(pool.getId());
        if (datas == null) {
            datas = this.createPoolData(pool);
            this.poolData.put(pool.getId(), datas);
        }
        return datas;
    }

    @Override
    @NotNull
    public Optional<QuesterPoolData> getPoolDataIfPresent(@NotNull QuestPool pool) {
        return Optional.ofNullable(this.poolData.get(pool.getId()));
    }

    @NotNull
    protected abstract QuesterPoolData createPoolData(@NotNull QuestPool var1);

    @Override
    @NotNull
    public CompletableFuture<QuesterPoolData> removePoolData(@NotNull QuestPool pool) {
        return this.removePoolData(pool.getId());
    }

    @Override
    @NotNull
    public CompletableFuture<QuesterPoolData> removePoolData(int id) {
        QuesterPoolData removed = this.poolData.remove(id);
        if (removed == null) {
            return CompletableFuture.completedFuture(null);
        }
        return removed.remove().thenApply(__ -> removed);
    }

    @Override
    @NotNull
    public @UnmodifiableView @NotNull Collection<@NotNull ? extends QuesterPoolData> getAllPoolsData() {
        return this.poolData.values();
    }

    @Override
    @Nullable
    public <T> T getData(@NotNull SavableData<T> data) {
        if (!QuestsAPI.getAPI().getQuesterManager().getSavableData().contains(data)) {
            throw new IllegalArgumentException("The " + data.getId() + " account data has not been registered.");
        }
        return (T)this.additionalData.getOrDefault(data, data.getDefaultValue());
    }

    @Override
    public final <T> CompletableFuture<T> setData(@NotNull SavableData<T> data, @Nullable T value) {
        if (!QuestsAPI.getAPI().getQuesterManager().getSavableData().contains(data)) {
            throw new IllegalArgumentException("The " + data.getId() + " account data has not been registered.");
        }
        Object old = this.additionalData.put(data, value);
        return this.setDataInternal(data, value).thenApply(__ -> old);
    }

    protected abstract <T> CompletableFuture<Void> setDataInternal(@NotNull SavableData<T> var1, @Nullable T var2);

    @Override
    public CompletableFuture<Void> resetData() {
        CompletableFuture<Void> future = CompletableFuture.allOf((CompletableFuture[])this.additionalData.keySet().stream().map(data -> this.setDataInternal((SavableData)data, null)).toArray(CompletableFuture[]::new));
        this.additionalData.clear();
        return future;
    }
}

