/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.questers;

import fr.skytasul.quests.api.data.DataSavingException;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.QuesterProvider;
import fr.skytasul.quests.api.questers.data.QuesterData;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQuesterImplementation
implements Quester {
    @NotNull
    private final QuesterProvider provider;
    @NotNull
    private final QuesterData dataHolder;
    @Nullable
    private PlaceholderRegistry placeholders;
    @Nullable
    private Pointers audiencePointers;

    protected AbstractQuesterImplementation(@NotNull QuesterProvider provider, @NotNull QuesterData dataHolder) {
        this.provider = provider;
        this.dataHolder = dataHolder;
    }

    @Override
    @NotNull
    public QuesterProvider getProvider() {
        return this.provider;
    }

    @Override
    @NotNull
    public QuesterData getDataHolder() {
        return this.dataHolder;
    }

    @Override
    @NotNull
    public PlaceholderRegistry getPlaceholdersRegistry() {
        if (this.placeholders == null) {
            this.placeholders = new PlaceholderRegistry();
            this.createdPlaceholdersRegistry(this.placeholders);
        }
        return this.placeholders;
    }

    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        placeholders.registerIndexed("quester_name", this::getFriendlyName).register("quester_identifier", this::getIdentifier).register("quester_detailed_name", this::getDetailedName);
        placeholders.register("player_name", this::getFriendlyName).register("player", this::getDetailedName);
    }

    protected void createdPointers(@NotNull Pointers.Builder builder) {
        builder.withDynamic(Identity.NAME, this::getDetailedName).withDynamic(Identity.DISPLAY_NAME, () -> Component.text((String)this.getFriendlyName())).build();
    }

    @NotNull
    public Pointers pointers() {
        if (this.audiencePointers == null) {
            Pointers.Builder builder = Pointers.builder();
            this.createdPointers(builder);
            this.audiencePointers = (Pointers)builder.build();
        }
        return this.audiencePointers;
    }

    public void save() throws DataSavingException {
        this.dataHolder.save();
    }

    public void unload() {
        this.dataHolder.unload();
    }
}

