/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.questers;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public abstract class AbstractQuesterQuestDataImplementation
implements QuesterQuestData {
    protected final int questId;
    protected int finished = 0;
    protected QuesterQuestData.State state = QuesterQuestData.State.NOT_STARTED;
    protected OptionalLong timer = OptionalLong.empty();
    protected OptionalInt branch = OptionalInt.empty();
    protected OptionalInt stage = OptionalInt.empty();
    protected OptionalLong startingTime = OptionalLong.empty();
    protected Map<Integer, Map<String, Object>> stageData = new HashMap<Integer, Map<String, Object>>();
    protected Map<String, Object> additionalData = new HashMap<String, Object>();
    protected final List<StageIndex> questFlow = new ArrayList<StageIndex>();
    private final List<StageIndex> questFlowView = Collections.unmodifiableList(this.questFlow);

    public AbstractQuesterQuestDataImplementation(int questID) {
        this.questId = questID;
    }

    @Override
    public Quest getQuest() {
        return QuestsAPI.getAPI().getQuestsManager().getQuest(this.questId);
    }

    @Override
    public int getQuestId() {
        return this.questId;
    }

    public void setTimesFinished(int times) {
        this.finished = times;
    }

    @Override
    public void incrementFinished() {
        this.setTimesFinished(this.finished + 1);
    }

    @Override
    public int getTimesFinished() {
        return this.finished;
    }

    @Override
    public void setTimer(@NotNull OptionalLong timer) {
        this.timer = timer;
    }

    @Override
    public OptionalLong getTimer() {
        return this.timer;
    }

    @Override
    public OptionalInt getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(@NotNull OptionalInt branch) {
        this.branch = branch;
    }

    @Override
    public OptionalInt getStage() {
        return this.stage;
    }

    @Override
    public void setStage(@NotNull OptionalInt stage) {
        this.stage = stage;
    }

    @Override
    public OptionalLong getStartingTime() {
        return this.startingTime;
    }

    @Override
    public void setStartingTime(@NotNull OptionalLong time) {
        this.startingTime = time;
    }

    @Override
    @NotNull
    public QuesterQuestData.State getState() {
        return this.state;
    }

    @Override
    public void setState(@NotNull QuesterQuestData.State state) {
        this.state = state;
    }

    @Override
    @NotNull
    public @NotNull @UnmodifiableView Map<@NotNull Integer, Map<@NotNull String, @Nullable Object>> getAllStagesData() {
        return this.stageData;
    }

    @Override
    public Map<String, Object> getStageData(int stage) {
        return this.stageData.get(stage);
    }

    @Override
    public void setStageData(int stage, Map<String, Object> datas) {
        this.stageData.put(stage, datas);
    }

    @Override
    @NotNull
    public @NotNull @UnmodifiableView Map<@NotNull String, @NotNull Object> getAllAdditionalData() {
        return this.additionalData;
    }

    @Override
    public <T> T getAdditionalData(String key) {
        return (T)this.additionalData.get(key);
    }

    @Override
    public <T> T setAdditionalData(String key, T value) {
        return (T)(value == null ? this.additionalData.remove(key) : this.additionalData.put(key, value));
    }

    @Override
    @NotNull
    public @UnmodifiableView List<StageIndex> getQuestFlow() {
        return this.questFlowView;
    }

    @Override
    public Stream<StageController> getQuestFlowStages() {
        Quest quest = this.getQuest();
        return this.questFlow.stream().map(entry -> {
            try {
                return quest.getBranchesManager().getStageFromIndex((StageIndex)entry);
            }
            catch (Exception ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().namedWarning("Cannot find stage with index {0} for quest {1}", this, 60, entry, this.questId);
                return null;
            }
        }).filter(stage -> stage != null);
    }

    @Override
    public void addQuestFlow(StageController finished) {
        this.questFlow.add(finished.getIndex());
    }

    @Override
    public void resetQuestFlow() {
        this.questFlow.clear();
    }

    protected void migrateState() {
        QuesterQuestData.State newState = QuesterQuestData.State.NOT_STARTED;
        if (this.branch.isPresent()) {
            if (this.branch.getAsInt() == -2) {
                newState = QuesterQuestData.State.IN_END;
            } else if (this.branch.getAsInt() >= 0) {
                if (this.stage.isPresent() && this.stage.getAsInt() == -2) {
                    newState = QuesterQuestData.State.IN_ENDING_STAGES;
                } else if (this.stage.isPresent() && this.stage.getAsInt() >= 0) {
                    newState = QuesterQuestData.State.IN_REGULAR_STAGE;
                }
            }
        }
        switch (newState) {
            case IN_END: 
            case NOT_STARTED: {
                this.setStage(OptionalInt.empty());
                this.setBranch(OptionalInt.empty());
                break;
            }
            case IN_ENDING_STAGES: {
                this.setStage(OptionalInt.empty());
                break;
            }
        }
        this.setState(newState);
    }
}

