/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.questers;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.data.DataLoadingException;
import fr.skytasul.quests.api.data.DataSavingException;
import fr.skytasul.quests.api.data.SavableData;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.QuesterManager;
import fr.skytasul.quests.api.questers.QuesterProvider;
import fr.skytasul.quests.api.questers.data.QuesterDataManager;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.key.Key;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class QuesterManagerImplementation
implements QuesterManager {
    private static final LoggerExpanded LOGGER = LoggerExpanded.get("BeautyQuests.QuesterManager");
    private static final List<String> FORBIDDEN_DATA_ID = List.of("identifier", "quests", "pools");
    @NotNull
    private final @NotNull Set<@NotNull SavableData<?>> savableData = new HashSet();
    @NotNull
    private final @NotNull Map<@NotNull Key, @NotNull QuesterProvider> providers = new HashMap<Key, QuesterProvider>();
    @NotNull
    private final BeautyQuests plugin;
    @NotNull
    private QuesterDataManager dataManager;
    private boolean lockData = false;

    public QuesterManagerImplementation(@NotNull BeautyQuests plugin, @NotNull QuesterDataManager dataManager) {
        this.plugin = plugin;
        this.dataManager = dataManager;
    }

    @NotNull
    public BeautyQuests getPlugin() {
        return this.plugin;
    }

    @Override
    public void registerQuesterProvider(@NotNull QuesterProvider provider) {
        if (this.lockData) {
            throw new IllegalStateException("Cannot add quester provider after manager has been loaded");
        }
        this.providers.put(provider.key(), provider);
    }

    @Override
    @NotNull
    public @UnmodifiableView Collection<QuesterProvider> getQuesterProviders() {
        return this.providers.values();
    }

    @Override
    @NotNull
    public QuesterProvider getQuesterProvider(@NotNull Key key) throws IllegalArgumentException {
        QuesterProvider provider = this.providers.get(key);
        if (provider == null) {
            throw new IllegalArgumentException("Cannot find quester provider " + String.valueOf(key));
        }
        return provider;
    }

    @Override
    @NotNull
    public QuesterDataManager getDataManager() {
        return this.dataManager;
    }

    public void setDataManager(@NotNull QuesterDataManager dataManager) {
        this.dataManager = Objects.requireNonNull(dataManager);
        LOGGER.debug("Using {} as the new data manager", dataManager.getClass().getSimpleName());
    }

    public void load() throws DataLoadingException {
        LOGGER.debug("Locking quester manager.");
        this.lockData = true;
        this.dataManager.load(this);
        this.providers.values().forEach(provider -> provider.load(this));
    }

    @Override
    public void addSavableData(@NotNull SavableData<?> data) {
        if (this.lockData) {
            throw new IllegalStateException("Cannot add quester data after players manager has been loaded");
        }
        if (FORBIDDEN_DATA_ID.contains(data.getId())) {
            throw new IllegalArgumentException("Forbidden account data id " + data.getId());
        }
        if (this.savableData.stream().anyMatch(x -> x.getId().equals(data.getId()))) {
            throw new IllegalArgumentException("Another account data already exists with the id " + data.getId());
        }
        if (data.getDataType().isPrimitive()) {
            throw new IllegalArgumentException("Primitive account data types are not supported");
        }
        this.savableData.add(data);
        LOGGER.debug("Registered quester data " + data.getId());
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull SavableData<?>> getSavableData() {
        return this.savableData;
    }

    @Override
    @NotNull
    public @UnmodifiableView Collection<? extends Quester> getPlayerQuesters(@NotNull Player player) {
        return this.providers.values().stream().flatMap(provider -> provider.getPlayerQuesters(player).stream()).toList();
    }

    @Override
    @NotNull
    public @UnmodifiableView Collection<? extends Quester> getLoadedQuesters() {
        return this.providers.values().stream().flatMap(provider -> provider.getLoadedQuesters().stream()).toList();
    }

    @Override
    public void saveAll() {
        LOGGER.debug("Saving questers...");
        for (QuesterProvider provider : this.providers.values()) {
            for (Quester quester : provider.getLoadedQuesters()) {
                try {
                    quester.getDataHolder().save();
                }
                catch (DataSavingException ex) {
                    LOGGER.severe("Failed to save data of {}", ex, quester.getDetailedName());
                }
            }
        }
        try {
            this.dataManager.save();
        }
        catch (DataSavingException ex) {
            LOGGER.severe("Failed to save data manager.", ex);
        }
    }
}

