/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.questers.data.sql;

import fr.skytasul.quests.api.data.DataLoadingException;
import fr.skytasul.quests.api.data.DataSavingException;
import fr.skytasul.quests.api.questers.QuesterManager;
import fr.skytasul.quests.api.questers.data.QuesterData;
import fr.skytasul.quests.api.questers.data.QuesterDataManager;
import fr.skytasul.quests.api.questers.data.QuesterPoolData;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.stages.StageIndex;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import fr.skytasul.quests.questers.data.sql.SqlHandler;
import fr.skytasul.quests.questers.data.sql.SqlQuesterData;
import fr.skytasul.quests.utils.Database;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SqlDataManager
implements QuesterDataManager {
    protected static final LoggerExpanded LOGGER = LoggerExpanded.get("BeautyQuests.SqlDataManager");
    private final SqlHandler sqlHandler;
    private final ExecutorService dataExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        int i = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "BeautyQuests-sql-data-" + this.i);
        }
    });
    protected QuesterManager questerManager;

    public SqlDataManager(@NotNull Database db) {
        this.sqlHandler = new SqlHandler(db);
    }

    @NotNull
    public SqlHandler getSqlHandler() {
        return this.sqlHandler;
    }

    @NotNull
    protected Connection getDbConnection() throws SQLException {
        return this.sqlHandler.getDatabase().getConnection();
    }

    @NotNull
    protected Executor getDataExecutor() {
        return this.dataExecutor;
    }

    @Override
    public void load(@NotNull QuesterManager questerManager) throws DataLoadingException {
        this.questerManager = questerManager;
        try {
            this.sqlHandler.createTables(questerManager);
        }
        catch (SQLException ex) {
            throw new DataLoadingException("Failed to create database tables", ex);
        }
        this.sqlHandler.initializeStatements();
    }

    @Override
    @NotNull
    public CompletableFuture<QuesterDataManager.QuesterFetchResult> fetchQuester(@NotNull QuesterDataManager.QuesterFetchRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.dataExecutor);
    }

    @Override
    public CompletableFuture<Integer> resetQuestData(int questId) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = this.getDbConnection();){
                Integer n;
                block14: {
                    PreparedStatement statement = connection.prepareStatement(this.sqlHandler.removeExistingQuestDatas);
                    try {
                        statement.setInt(1, questId);
                        int amount = statement.executeUpdate();
                        LOGGER.debug("Removed {} in-database quest datas for quest {}.", amount, questId);
                        n = amount;
                        if (statement == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return n;
            }
            catch (SQLException ex) {
                throw new CompletionException(ex);
            }
        }, this.dataExecutor);
    }

    @Override
    public CompletableFuture<Integer> resetPoolData(int poolId) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = this.getDbConnection();){
                Integer n;
                block14: {
                    PreparedStatement statement = connection.prepareStatement(this.sqlHandler.removeExistingPoolDatas);
                    try {
                        statement.setInt(1, poolId);
                        int amount = statement.executeUpdate();
                        LOGGER.debug("Removed {} in-database data for pool {}.", amount, poolId);
                        n = amount;
                        if (statement == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return n;
            }
            catch (SQLException ex) {
                throw new CompletionException(ex);
            }
        }, this.dataExecutor);
    }

    private void importQuester(@NotNull QuesterData data, @NotNull Connection connection) throws SQLException {
        PreparedStatement statement = connection.prepareStatement("INSERT INTO %s (provider, identifier) VALUES (?, ?)".formatted(this.sqlHandler.QUESTERS_TABLE));
        int i = 1;
        statement.setString(i++, data.provider().asString());
        statement.setString(i++, data.identifier());
        statement.executeUpdate();
        statement = connection.prepareStatement("INSERT INTO %s (quester_provider, quester_identifier, quest_id, finished, timer, current_branch, current_stage, starting_time, stage_data, additional_datas, state, quest_flow) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)".formatted(this.sqlHandler.QUESTS_DATAS_TABLE));
        for (QuesterQuestData questerQuestData : data.getAllQuestsData()) {
            i = 1;
            statement.setString(i++, data.provider().asString());
            statement.setString(i++, data.identifier());
            statement.setInt(i++, questerQuestData.getQuestId());
            statement.setInt(i++, questerQuestData.getTimesFinished());
            SqlQuesterData.fillInOptionalLong(statement, i++, questerQuestData.getTimer());
            SqlQuesterData.fillInOptionalInt(statement, i++, questerQuestData.getBranch());
            SqlQuesterData.fillInOptionalInt(statement, i++, questerQuestData.getStage());
            SqlQuesterData.fillInOptionalLong(statement, i++, questerQuestData.getStartingTime());
            SqlQuesterData.fillInSerializable(statement, i++, questerQuestData.getAllStagesData());
            SqlQuesterData.fillInSerializable(statement, i++, questerQuestData.getAllAdditionalData());
            statement.setString(i++, questerQuestData.getState().name());
            statement.setString(i++, questerQuestData.getQuestFlow().stream().map(StageIndex::toString).collect(Collectors.joining(";")));
            statement.addBatch();
        }
        statement.executeBatch();
        statement = connection.prepareStatement("INSERT INTO %s (quester_provider, quester_identifier, pool_id, last_give, completed_quests) VALUES (?, ?, ?, ?, ?)".formatted(this.sqlHandler.POOLS_DATAS_TABLE));
        for (QuesterPoolData questerPoolData : data.getAllPoolsData()) {
            i = 1;
            statement.setString(i++, data.provider().asString());
            statement.setString(i++, data.identifier());
            statement.setInt(i++, questerPoolData.getPoolId());
            statement.setLong(i++, questerPoolData.getLastGive());
            statement.setString(i++, questerPoolData.getCompletedQuests().stream().map(String::valueOf).collect(Collectors.joining(";")));
            statement.addBatch();
        }
        statement.executeBatch();
    }

    @Override
    @NotNull
    public CompletableFuture<QuesterDataManager.ImportResult> importAll(@NotNull Iterator<? extends QuesterData> iterator) {
        return CompletableFuture.supplyAsync(() -> {
            int failures;
            int successes;
            block12: {
                successes = 0;
                failures = 0;
                try {
                    Connection connection = this.getDbConnection();
                    block9: while (true) {
                        while (iterator.hasNext()) {
                            QuesterData questerData = (QuesterData)iterator.next();
                            try {
                                this.importQuester(questerData, connection);
                                ++successes;
                                continue block9;
                            }
                            catch (Exception ex) {
                                LOGGER.severe("Failed to import quester %s %s", questerData.provider(), questerData.identifier());
                                ++failures;
                            }
                        }
                        break block12;
                        {
                            continue block9;
                            break;
                        }
                        break;
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new CompletionException(ex);
                }
            }
            return new QuesterDataManager.ImportResult(successes, failures);
        }, this.dataExecutor);
    }

    @Override
    public void save() throws DataSavingException {
    }

    @Override
    public void unload() {
        this.dataExecutor.shutdown();
        try {
            this.dataExecutor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

