/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.questers.data.sql;

import fr.skytasul.quests.api.data.SQLDataSaver;
import fr.skytasul.quests.api.data.SavableData;
import fr.skytasul.quests.api.questers.QuesterManager;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import fr.skytasul.quests.players.PlayerManagerImplementation;
import fr.skytasul.quests.utils.Database;
import fr.skytasul.quests.utils.ThrowingConsumer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SqlHandler {
    private static final LoggerExpanded LOGGER = LoggerExpanded.get("BeautyQuests.SqlDataHandler");
    public final String QUESTERS_TABLE;
    public final String QUESTS_DATAS_TABLE;
    public final String POOLS_DATAS_TABLE;
    String getQuesterData;
    String setQuesterAdditionalData;
    String insertAccount;
    String deleteAccount;
    String insertQuestData;
    String removeQuestData;
    String getQuestsData;
    String removeExistingQuestDatas;
    String insertPoolData;
    String removePoolData;
    String getPoolsData;
    String removeExistingPoolDatas;
    private final Database db;

    public SqlHandler(@NotNull Database db) {
        this.db = db;
        this.QUESTERS_TABLE = db.getConfig().tables().get("questers");
        this.QUESTS_DATAS_TABLE = db.getConfig().tables().get("questers quests");
        this.POOLS_DATAS_TABLE = db.getConfig().tables().get("questers pools");
    }

    public Database getDatabase() {
        return this.db;
    }

    public void createTables(@NotNull QuesterManager questerManager) throws SQLException {
        try (Connection connection = this.db.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS " + this.QUESTERS_TABLE + " ( provider VARCHAR(255) NOT NULL , identifier VARCHAR(255) NOT NULL , " + questerManager.getSavableData().stream().map(t -> SQLDataSaver.getColumnDefinition(t) + ", ").collect(Collectors.joining(" ")) + " PRIMARY KEY (provider, identifier) )");
            statement.execute("CREATE TABLE IF NOT EXISTS %s (\n\tquester_provider VARCHAR(255) NOT NULL,\n\tquester_identifier VARCHAR(255) NOT NULL,\n\tquest_id INT NOT NULL,\n\tfinished INT NOT NULL DEFAULT 0,\n\ttimer BIGINT DEFAULT NULL,\n\tcurrent_branch SMALLINT DEFAULT NULL,\n\tcurrent_stage SMALLINT DEFAULT NULL,\n\tstarting_time BIGINT DEFAULT NULL,\n\tstage_data %2$s DEFAULT NULL,\n\tadditional_datas %2$s DEFAULT NULL,\n\tstate VARCHAR(60) DEFAULT 'NOT_STARTED',\n\tquest_flow VARCHAR(8000) DEFAULT NULL,\n\tPRIMARY KEY (quester_provider, quester_identifier, quest_id)\n)\n".formatted(this.QUESTS_DATAS_TABLE, this.db.getType().getLongTextType()));
            statement.execute("CREATE TABLE IF NOT EXISTS %s (\n\tquester_provider VARCHAR(255) NOT NULL,\n\tquester_identifier VARCHAR(255) NOT NULL,\n\tpool_id INT NOT NULL,\n\tlast_give BIGINT DEFAULT NULL,\n\tcompleted_quests VARCHAR(1000) DEFAULT NULL,\n\tPRIMARY KEY (quester_provider, quester_identifier, pool_id)\n)\n".formatted(this.POOLS_DATAS_TABLE));
            AtomicBoolean questersHasId = new AtomicBoolean(false);
            this.upgradeTable(connection, this.QUESTERS_TABLE, columns -> {
                for (SavableData<?> data : questerManager.getSavableData()) {
                    if (columns.contains(data.getColumnName().toLowerCase())) continue;
                    statement.execute("ALTER TABLE %s ADD COLUMN %s".formatted(this.QUESTERS_TABLE, SQLDataSaver.getColumnDefinition(data)));
                    LOGGER.info("Updated database by adding the missing {} column in the player accounts table.", data.getColumnName());
                }
                if (!columns.contains("provider")) {
                    statement.execute("ALTER TABLE %1$s\n\tDROP COLUMN player_uuid,\n\n\t-- delete the auto_increment\n\tMODIFY COLUMN id int(11) NOT NULL,\n\tDROP PRIMARY KEY,\n\n\tADD COLUMN provider VARCHAR(255) NOT NULL,\n\tMODIFY COLUMN identifier VARCHAR(255) NOT NULL,\n\tADD PRIMARY KEY (provider, identifier)\n".formatted(this.QUESTERS_TABLE));
                    statement.execute("UPDATE %s SET provider = '%s'".formatted(this.QUESTERS_TABLE, PlayerManagerImplementation.KEY.asString()));
                    LOGGER.info("Updated database by changing layout of the questers table.");
                }
                if (columns.contains("id")) {
                    questersHasId.set(true);
                }
            });
            this.upgradeTable(connection, this.QUESTS_DATAS_TABLE, columns -> {
                if (columns.contains("account_id")) {
                    statement.execute("ALTER TABLE %1$s\n\tADD COLUMN starting_time BIGINT DEFAULT NULL,\n\tADD COLUMN stage_data %2$s DEFAULT NULL,\n\tADD COLUMN state VARCHAR(60) DEFAULT 'NOT_STARTED',\n\n\tADD COLUMN quester_provider VARCHAR(225) NOT NULL,\n\tADD COLUMN quester_identifier VARCHAR(255) NOT NULL\n".formatted(this.QUESTS_DATAS_TABLE, this.db.getType().getLongTextType()));
                    statement.execute("UPDATE %s SET state = NULL".formatted(this.QUESTS_DATAS_TABLE));
                    statement.execute("UPDATE %s SET quester_identifier = '_migration'".formatted(this.QUESTS_DATAS_TABLE));
                    statement.execute("UPDATE %s SET quester_provider = '%s'".formatted(this.QUESTS_DATAS_TABLE, PlayerManagerImplementation.KEY.asString()));
                    statement.execute("UPDATE %1$s AS quests\n\tINNER JOIN %2$s AS questers ON quests.account_id = questers.id\nSET quests.quester_identifier = questers.identifier\n".formatted(this.QUESTS_DATAS_TABLE, this.QUESTERS_TABLE));
                    int missingQuesters = statement.executeUpdate("DELETE FROM %s WHERE quester_identifier = '_migration'".formatted(this.QUESTS_DATAS_TABLE));
                    if (missingQuesters > 0) {
                        LOGGER.warning("%d quest data have no associated questers. Deleting them.", missingQuesters);
                    }
                    statement.execute("ALTER TABLE %1$s\n\tMODIFY COLUMN id int(11) NOT NULL,\n\tDROP PRIMARY KEY,\n\tADD PRIMARY KEY (quester_provider, quester_identifier, quest_id)\n".formatted(this.QUESTS_DATAS_TABLE));
                    statement.execute("ALTER TABLE %1$s\n\tDROP COLUMN id,\n\tDROP COLUMN account_id\n".formatted(this.QUESTS_DATAS_TABLE));
                    LOGGER.info("Updated database by changing layout of the quests data table.");
                }
            });
            this.upgradeTable(connection, this.POOLS_DATAS_TABLE, columns -> {
                if (columns.contains("account_id")) {
                    statement.execute("ALTER TABLE %1$s\n\tADD COLUMN quester_provider VARCHAR(225) NOT NULL,\n\tADD COLUMN quester_identifier VARCHAR(255) NOT NULL\n".formatted(this.POOLS_DATAS_TABLE));
                    statement.execute("UPDATE %s SET quester_identifier = '_migration', quester_provider = '%s'".formatted(this.POOLS_DATAS_TABLE, PlayerManagerImplementation.KEY.asString()));
                    statement.execute("UPDATE %1$s AS pools\n\tINNER JOIN %2$s AS questers ON pools.account_id = questers.id\nSET pools.quester_identifier = questers.identifier\n".formatted(this.POOLS_DATAS_TABLE, this.QUESTERS_TABLE));
                    int missingQuesters = statement.executeUpdate("DELETE FROM %s WHERE quester_identifier = '_migration'".formatted(this.POOLS_DATAS_TABLE));
                    if (missingQuesters > 0) {
                        LOGGER.warning("%d pool data have no associated questers. Deleting them.", missingQuesters);
                    }
                    statement.execute("ALTER TABLE %1$s\n\tMODIFY COLUMN id int(11) NOT NULL,\n\tDROP PRIMARY KEY,\n\tADD PRIMARY KEY (quester_provider, quester_identifier, pool_id)\n".formatted(this.POOLS_DATAS_TABLE));
                    statement.execute("ALTER TABLE %1$s\n\tDROP COLUMN id,\n\tDROP COLUMN account_id\n".formatted(this.POOLS_DATAS_TABLE));
                    LOGGER.info("Updated database by changing layout of the pools data table.");
                }
            });
            if (questersHasId.get()) {
                statement.execute("ALTER TABLE %s DROP COLUMN id".formatted(this.QUESTERS_TABLE));
                LOGGER.info("Dropped the legacy id column of the questers table.");
            }
        }
    }

    private void upgradeTable(Connection connection, String tableName, ThrowingConsumer<List<String>, SQLException> columnsConsumer) throws SQLException {
        ArrayList<String> columns = new ArrayList<String>(14);
        try (ResultSet set = connection.getMetaData().getColumns(this.db.getConfig().databaseName(), null, tableName, null);){
            while (set.next()) {
                columns.add(set.getString("COLUMN_NAME").toLowerCase());
            }
        }
        if (columns.isEmpty()) {
            LOGGER.severe("Cannot check integrity of SQL table " + tableName);
        } else {
            columnsConsumer.accept(columns);
        }
    }

    protected void initializeStatements() {
        this.getQuesterData = "SELECT * FROM " + this.QUESTERS_TABLE + " WHERE provider = ? AND identifier = ?";
        this.setQuesterAdditionalData = "UPDATE " + this.QUESTERS_TABLE + " SET %s = ? WHERE provider = ? AND identifier = ?";
        this.insertAccount = "INSERT INTO " + this.QUESTERS_TABLE + " (provider, identifier) VALUES (?, ?)";
        this.deleteAccount = "DELETE FROM " + this.QUESTERS_TABLE + " WHERE provider = ? AND identifier = ?";
        this.insertQuestData = "INSERT INTO " + this.QUESTS_DATAS_TABLE + " (quester_provider, quester_identifier, quest_id) VALUES (?, ?, ?)";
        this.removeQuestData = "DELETE FROM " + this.QUESTS_DATAS_TABLE + " WHERE quester_provider = ? AND quester_identifier = ? AND quest_id = ?";
        this.getQuestsData = "SELECT * FROM " + this.QUESTS_DATAS_TABLE + " WHERE quester_provider = ? AND quester_identifier = ?";
        this.removeExistingQuestDatas = "DELETE FROM " + this.QUESTS_DATAS_TABLE + " WHERE quest_id = ?";
        this.insertPoolData = "INSERT INTO " + this.POOLS_DATAS_TABLE + " (quester_provider, quester_identifier, pool_id) VALUES (?, ?, ?)";
        this.removePoolData = "DELETE FROM " + this.POOLS_DATAS_TABLE + " WHERE quester_provider = ? AND quester_identifier = ? AND pool_id = ?";
        this.getPoolsData = "SELECT * FROM " + this.POOLS_DATAS_TABLE + " WHERE quester_provider = ? AND quester_identifier = ?";
        this.removeExistingPoolDatas = "DELETE FROM " + this.POOLS_DATAS_TABLE + " WHERE pool_id = ?";
    }

    public String getQuestDataStatement(String column) {
        return "UPDATE %s SET %s = ? WHERE quester_provider = ? AND quester_identifier = ? AND quest_id = ?".formatted(this.QUESTS_DATAS_TABLE, column);
    }

    public String getPoolDataStatement(String column) {
        return "UPDATE %s SET %s = ? WHERE quester_provider = ? AND quester_identifier = ? AND pool_id = ?".formatted(this.POOLS_DATAS_TABLE, column);
    }
}

