/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.questers.data.sql;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.data.DataLoadingException;
import fr.skytasul.quests.api.data.DataSavingException;
import fr.skytasul.quests.api.data.SQLDataSaver;
import fr.skytasul.quests.api.data.SavableData;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.questers.data.QuesterPoolData;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageIndex;
import fr.skytasul.quests.api.utils.CustomizedObjectTypeAdapter;
import fr.skytasul.quests.questers.AbstractQuesterDataImplementation;
import fr.skytasul.quests.questers.AbstractQuesterPoolDataImplementation;
import fr.skytasul.quests.questers.AbstractQuesterQuestDataImplementation;
import fr.skytasul.quests.questers.data.sql.SqlDataManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQuesterData
extends AbstractQuesterDataImplementation {
    @NotNull
    private final SqlDataManager dataManager;
    @NotNull
    private final Key provider;
    @NotNull
    private final String identifier;

    public SqlQuesterData(@NotNull SqlDataManager dataManager, @NotNull Key provider, @NotNull String identifier) {
        this.dataManager = dataManager;
        this.provider = provider;
        this.identifier = identifier;
    }

    @Override
    @NotNull
    public Key provider() {
        return this.provider;
    }

    @Override
    @NotNull
    public String identifier() {
        return this.identifier;
    }

    protected void load(@NotNull ResultSet result) throws SQLException, DataLoadingException {
        PreparedStatement statement;
        for (SavableData<?> dataColumn : this.dataManager.questerManager.getSavableData()) {
            this.additionalData.put(dataColumn, SQLDataSaver.getFromResultSet(dataColumn, result));
        }
        try (Connection connection = this.dataManager.getDbConnection();){
            statement = connection.prepareStatement(this.dataManager.getSqlHandler().getQuestsData);
            try {
                this.fillInIdentifier(statement, 1);
                result = statement.executeQuery();
                while (result.next()) {
                    int questId = result.getInt("quest_id");
                    try {
                        QuestData questData = new QuestData(questId);
                        questData.load(result);
                        this.questData.put(questId, questData);
                    }
                    catch (Exception ex) {
                        QuestsPlugin.getPlugin().getLoggerExpanded().severe("Failed to load quester {} data for quest {}", ex, this.identifier, questId);
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        connection = this.dataManager.getDbConnection();
        try {
            statement = connection.prepareStatement(this.dataManager.getSqlHandler().getPoolsData);
            try {
                this.fillInIdentifier(statement, 1);
                result = statement.executeQuery();
                while (result.next()) {
                    int poolId = result.getInt("pool_id");
                    try {
                        PoolData poolData = new PoolData(poolId);
                        poolData.load(result);
                        this.poolData.put(poolId, poolData);
                    }
                    catch (Exception ex) {
                        QuestsPlugin.getPlugin().getLoggerExpanded().severe("Failed to load quester {} data for pool {}", ex, this.identifier, poolId);
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public void save() throws DataSavingException {
    }

    @Override
    public void unload() {
    }

    @Override
    protected QuesterQuestData createQuestData(@NotNull Quest quest) {
        this.dataManager.getDataExecutor().execute(() -> {
            try (Connection connection = this.dataManager.getDbConnection();
                 PreparedStatement statement = connection.prepareStatement(this.dataManager.getSqlHandler().insertQuestData);){
                int i = 1;
                i = this.fillInIdentifier(statement, i);
                statement.setInt(i++, quest.getId());
                statement.executeUpdate();
            }
            catch (SQLException ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while creating quest {} data for {}", ex, quest.getId(), this.identifier);
            }
        });
        return new QuestData(quest.getId());
    }

    @Override
    protected QuesterPoolData createPoolData(@NotNull QuestPool pool) {
        this.dataManager.getDataExecutor().execute(() -> {
            try (Connection connection = this.dataManager.getDbConnection();
                 PreparedStatement statement = connection.prepareStatement(this.dataManager.getSqlHandler().insertPoolData);){
                int i = 1;
                i = this.fillInIdentifier(statement, i);
                statement.setInt(i++, pool.getId());
                statement.executeUpdate();
            }
            catch (SQLException ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while creating pool {} data for {}", ex, pool.getId(), this.identifier);
            }
        });
        return new PoolData(pool.getId());
    }

    @Override
    protected <T> CompletableFuture<Void> setDataInternal(@NotNull SavableData<T> data, @Nullable T value) {
        return CompletableFuture.runAsync(() -> {
            String setDataSql = this.dataManager.getSqlHandler().setQuesterAdditionalData.formatted(data.getColumnName());
            try (Connection connection = this.dataManager.getDbConnection();
                 PreparedStatement statement = connection.prepareStatement(setDataSql);){
                SQLDataSaver.setInStatement(data, statement, 1, value);
                this.fillInIdentifier(statement, 2);
                statement.executeUpdate();
            }
            catch (SQLException ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("Failed to set data {} for quester {} {}", ex, data.getColumnName(), this.provider, this.identifier);
                throw new CompletionException(ex);
            }
        }, this.dataManager.getDataExecutor());
    }

    @Override
    @NotNull
    public CompletableFuture<Void> delete() {
        return CompletableFuture.runAsync(() -> {
            try (Connection connection = this.dataManager.getDbConnection();
                 PreparedStatement statement = connection.prepareStatement(this.dataManager.getSqlHandler().deleteAccount);){
                this.fillInIdentifier(statement, 1);
            }
            catch (SQLException ex) {
                SqlDataManager.LOGGER.severe("Failed to delete data of quester {} {}", ex, this.provider, this.identifier);
                throw new CompletionException(ex);
            }
        }, this.dataManager.getDataExecutor());
    }

    protected int fillInIdentifier(PreparedStatement statement, int i) throws SQLException {
        statement.setString(i++, this.provider.asString());
        statement.setString(i++, this.identifier);
        return i;
    }

    protected static void fillInOptionalInt(PreparedStatement statement, int i, OptionalInt value) throws SQLException {
        if (value.isEmpty()) {
            statement.setNull(i, 4);
        } else {
            statement.setInt(i, value.getAsInt());
        }
    }

    protected static void fillInOptionalLong(PreparedStatement statement, int i, OptionalLong value) throws SQLException {
        if (value.isEmpty()) {
            statement.setNull(i, -5);
        } else {
            statement.setLong(i, value.getAsLong());
        }
    }

    protected static void fillInSerializable(PreparedStatement statement, int i, Object object) throws SQLException {
        statement.setObject(i, CustomizedObjectTypeAdapter.serializeNullable(object));
    }

    private OptionalInt readOptionalInt(@NotNull ResultSet result, String column) throws SQLException {
        int v = result.getInt(column);
        return result.wasNull() ? OptionalInt.empty() : OptionalInt.of(v);
    }

    private OptionalLong readOptionalLong(@NotNull ResultSet result, String column) throws SQLException {
        long v = result.getLong(column);
        return result.wasNull() ? OptionalLong.empty() : OptionalLong.of(v);
    }

    class QuestData
    extends AbstractQuesterQuestDataImplementation {
        public QuestData(int questID) {
            super(questID);
        }

        protected void load(ResultSet result) throws SQLException, DataLoadingException {
            Map stageData;
            String state;
            this.branch = SqlQuesterData.this.readOptionalInt(result, "current_branch");
            this.stage = SqlQuesterData.this.readOptionalInt(result, "current_stage");
            this.finished = result.getInt("finished");
            this.timer = SqlQuesterData.this.readOptionalLong(result, "timer");
            this.startingTime = SqlQuesterData.this.readOptionalLong(result, "starting_time");
            String flow = result.getString("quest_flow");
            if (flow != null && !flow.isEmpty() && this.getQuest() != null) {
                for (String flowPart : flow.split(";")) {
                    this.questFlow.add(StageIndex.fromString(flowPart));
                }
            }
            if ((state = result.getString("state")) == null) {
                super.migrateState();
            } else {
                this.state = QuesterQuestData.State.valueOf(state);
            }
            Map additionalData = CustomizedObjectTypeAdapter.deserializeNullable(result.getString("additional_datas"), Map.class);
            if (additionalData != null) {
                this.additionalData = additionalData;
                if (additionalData.containsKey("starting_time")) {
                    this.setStartingTime(OptionalLong.of((Long)additionalData.get("starting_time")));
                    this.setAdditionalData("starting_time", null);
                }
            }
            if ((stageData = CustomizedObjectTypeAdapter.deserializeNullable(result.getString("stage_data"), Map.class)) == null) {
                Pattern stageDataPattern = Pattern.compile("stage(\\d+)");
                for (Map.Entry<String, Object> entry : new HashMap<String, Object>(this.additionalData).entrySet()) {
                    Matcher matcher = stageDataPattern.matcher(entry.getKey());
                    if (!matcher.matches()) continue;
                    Object object = entry.getValue();
                    if (object instanceof Map) {
                        Map data = (Map)object;
                        this.setAdditionalData(entry.getKey(), null);
                        this.setStageData(Integer.parseInt(matcher.group(1)), data);
                        continue;
                    }
                    throw new DataLoadingException("Data in wrong format");
                }
            } else {
                this.stageData = stageData;
            }
        }

        @Override
        public CompletableFuture<Void> remove() {
            return CompletableFuture.runAsync(() -> {
                try (Connection connection = SqlQuesterData.this.dataManager.getDbConnection();
                     PreparedStatement statement = connection.prepareStatement(SqlQuesterData.this.dataManager.getSqlHandler().removeQuestData);){
                    int i = 1;
                    i = SqlQuesterData.this.fillInIdentifier(statement, i);
                    statement.setInt(i++, this.questId);
                    statement.executeUpdate();
                }
                catch (SQLException ex) {
                    throw new CompletionException(ex);
                }
            }, SqlQuesterData.this.dataManager.getDataExecutor());
        }

        @Override
        public void setBranch(@NotNull OptionalInt branch) {
            super.setBranch(branch);
            this.setDataInStatement((statement, i) -> SqlQuesterData.fillInOptionalInt(statement, i, branch), "current_branch");
        }

        @Override
        public void setStage(@NotNull OptionalInt stage) {
            super.setStage(stage);
            this.setDataInStatement((statement, i) -> SqlQuesterData.fillInOptionalInt(statement, i, stage), "current_stage");
        }

        @Override
        public void setTimesFinished(int times) {
            super.setTimesFinished(times);
            this.setDataInStatement((statement, i) -> statement.setInt(i, this.finished), "finished");
        }

        @Override
        public void setStartingTime(@NotNull OptionalLong time) {
            super.setStartingTime(time);
            this.setDataInStatement((statement, i) -> SqlQuesterData.fillInOptionalLong(statement, i, time), "starting_time");
        }

        @Override
        public void setTimer(@NotNull OptionalLong timer) {
            super.setTimer(timer);
            this.setDataInStatement((statement, i) -> SqlQuesterData.fillInOptionalLong(statement, i, timer), "timer");
        }

        @Override
        public void addQuestFlow(StageController finished) {
            super.addQuestFlow(finished);
            this.updatedQuestFlow();
        }

        @Override
        public void resetQuestFlow() {
            super.resetQuestFlow();
            this.updatedQuestFlow();
        }

        protected void updatedQuestFlow() {
            String flowString = this.questFlow.stream().map(StageIndex::toString).collect(Collectors.joining(";"));
            this.setDataInStatement((statement, i) -> statement.setString(i, flowString), "quest_flow");
        }

        @Override
        public void setState(@NotNull QuesterQuestData.State state) {
            super.setState(state);
            this.setDataInStatement((statement, i) -> statement.setString(i, state.name()), "state");
        }

        @Override
        public <T> T setAdditionalData(String key, T value) {
            T o = super.setAdditionalData(key, value);
            this.setDataInStatement((statement, i) -> SqlQuesterData.fillInSerializable(statement, i, this.additionalData), "additional_datas");
            return o;
        }

        @Override
        public void setStageData(int stage, Map<String, Object> datas) {
            super.setStageData(stage, datas);
            this.setDataInStatement((statement, i) -> SqlQuesterData.fillInSerializable(statement, i, this.stageData), "stage_data");
        }

        protected void setDataInStatement(StatementSetter setter, String column) {
            SqlQuesterData.this.dataManager.getDataExecutor().execute(() -> {
                try (Connection connection = SqlQuesterData.this.dataManager.getDbConnection();
                     PreparedStatement statement = connection.prepareStatement(SqlQuesterData.this.dataManager.getSqlHandler().getQuestDataStatement(column));){
                    int i = 1;
                    setter.accept(statement, i++);
                    i = SqlQuesterData.this.fillInIdentifier(statement, i);
                    statement.setInt(i++, this.questId);
                    statement.executeUpdate();
                }
                catch (SQLException ex) {
                    QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while updating {} for {} in quest {}", ex, column, SqlQuesterData.this.identifier, this.questId);
                }
            });
        }
    }

    class PoolData
    extends AbstractQuesterPoolDataImplementation {
        public PoolData(int poolId) {
            super(poolId);
        }

        protected void load(ResultSet result) throws SQLException, DataLoadingException {
            this.lastGive = result.getLong("last_give");
            String completed = result.getString("completed_quests");
            if (completed != null && !completed.isEmpty()) {
                this.completedQuests = Arrays.stream(completed.split(";")).map(Integer::parseInt).collect(Collectors.toSet());
            }
        }

        @Override
        @NotNull
        public CompletableFuture<Void> remove() {
            return CompletableFuture.runAsync(() -> {
                try (Connection connection = SqlQuesterData.this.dataManager.getDbConnection();
                     PreparedStatement statement = connection.prepareStatement(SqlQuesterData.this.dataManager.getSqlHandler().removePoolData);){
                    int i = 1;
                    i = SqlQuesterData.this.fillInIdentifier(statement, i);
                    statement.setInt(i++, this.poolId);
                    statement.executeUpdate();
                }
                catch (SQLException ex) {
                    throw new CompletionException(ex);
                }
            }, SqlQuesterData.this.dataManager.getDataExecutor());
        }

        @Override
        public void setLastGive(long lastGive) {
            super.setLastGive(lastGive);
            this.setDataInStatement((statement, i) -> statement.setLong(i, lastGive), "last_give");
        }

        @Override
        public void setCompletedQuests(Set<Integer> completedQuests) {
            super.setCompletedQuests(completedQuests);
            String completedQuestsStr = completedQuests.stream().map(String::valueOf).collect(Collectors.joining(";"));
            this.setDataInStatement((statement, i) -> statement.setString(i, completedQuestsStr), "completed_quests");
        }

        protected void setDataInStatement(StatementSetter setter, String column) {
            SqlQuesterData.this.dataManager.getDataExecutor().execute(() -> {
                try (Connection connection = SqlQuesterData.this.dataManager.getDbConnection();
                     PreparedStatement statement = connection.prepareStatement(SqlQuesterData.this.dataManager.getSqlHandler().getPoolDataStatement(column));){
                    int i = 1;
                    setter.accept(statement, i++);
                    i = SqlQuesterData.this.fillInIdentifier(statement, i);
                    statement.setInt(i++, this.poolId);
                    statement.executeUpdate();
                }
                catch (SQLException ex) {
                    QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while updating {} for {} in pool {}", ex, column, SqlQuesterData.this.identifier, this.poolId);
                }
            });
        }
    }

    private static interface StatementSetter {
        public void accept(PreparedStatement var1, int var2) throws SQLException;
    }
}

