/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.questers.data.yaml;

import fr.skytasul.quests.api.data.DataLoadingException;
import fr.skytasul.quests.api.data.DataSavingException;
import fr.skytasul.quests.api.questers.QuesterManager;
import fr.skytasul.quests.api.questers.data.QuesterData;
import fr.skytasul.quests.api.questers.data.QuesterDataManager;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import fr.skytasul.quests.players.PlayerManagerImplementation;
import fr.skytasul.quests.questers.data.yaml.YamlQuesterData;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.key.Key;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class YamlDataManager
implements QuesterDataManager {
    protected static final LoggerExpanded LOGGER = LoggerExpanded.get("BeautyQuests.YamlDataManager");
    private static final int ACCOUNTS_THRESHOLD = 1000;
    private static final String INDEX_FILENAME = "00_index.yml";
    private final Map<FullIdentifier, Integer> integerIndex = new ConcurrentHashMap<FullIdentifier, Integer>();
    private final Map<Integer, YamlQuesterData> cachedData = new HashMap<Integer, YamlQuesterData>();
    @NotNull
    private final Path dataPath;
    private YamlConfiguration indexConfig;

    public YamlDataManager(@NotNull Path dataPath) {
        this.dataPath = dataPath;
    }

    @NotNull
    public Path getDataPath() {
        return this.dataPath;
    }

    @NotNull
    private Path getIndexFilePath() {
        return this.dataPath.resolve(INDEX_FILENAME);
    }

    public boolean migrate(@NotNull Path oldDataPath, @NotNull FileConfiguration oldDataFile) throws IOException {
        if (!oldDataFile.isConfigurationSection("players")) {
            return false;
        }
        LOGGER.info("Migrating old players data...");
        if (Files.exists(this.getDataPath(), new LinkOption[0])) {
            LOGGER.severe("Cannot migrate old players data because the new format already contains data.");
            return false;
        }
        Files.move(oldDataPath, this.dataPath, new CopyOption[0]);
        YamlConfiguration newConfig = new YamlConfiguration();
        for (String key : oldDataFile.getConfigurationSection("players").getKeys(false)) {
            String identifier = oldDataFile.getString("players." + key);
            ConfigurationSection section = newConfig.createSection("identifiers." + key);
            section.set("provider", (Object)PlayerManagerImplementation.KEY.asString());
            section.set("identifier", (Object)identifier);
        }
        oldDataFile.set("players", null);
        newConfig.save(this.getIndexFilePath().toFile());
        return true;
    }

    @Override
    public void load(@NotNull QuesterManager questerManager) throws DataLoadingException {
        try {
            Files.createDirectories(this.dataPath, new FileAttribute[0]);
            if (Files.exists(this.getIndexFilePath(), new LinkOption[0])) {
                this.indexConfig = YamlConfiguration.loadConfiguration((File)this.getIndexFilePath().toFile());
                if (this.indexConfig.isConfigurationSection("identifiers")) {
                    for (String idString : this.indexConfig.getConfigurationSection("identifiers").getKeys(false)) {
                        int id = Integer.parseInt(idString);
                        ConfigurationSection section = this.indexConfig.getConfigurationSection("identifiers." + idString);
                        this.integerIndex.put(new FullIdentifier(Key.key((String)section.getString("provider")), section.getString("identifier")), id);
                    }
                }
            } else {
                this.indexConfig = new YamlConfiguration();
            }
            LOGGER.debug("{} quester identifiers loaded", this.integerIndex.size());
            if (this.integerIndex.size() >= 1000) {
                LOGGER.warning("\u26a0 WARNING - {} players are registered on this server.\nIt is recommended to switch to an SQL database setup in order to keep proper performances and scalability.\nIn order to do that, setup your database credentials in config.yml (without enabling it) and run the command\n/quests migrateDatas. Then follow steps on screen.\n", this.integerIndex.size());
            }
        }
        catch (IOException ex) {
            throw new DataLoadingException(ex);
        }
    }

    private int getNextIndex() {
        return this.integerIndex.isEmpty() ? 0 : Collections.max(this.integerIndex.values()) + 1;
    }

    @Override
    @NotNull
    public CompletableFuture<QuesterDataManager.QuesterFetchResult> fetchQuester(@NotNull QuesterDataManager.QuesterFetchRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            YamlQuesterData dataHandler;
            QuesterDataManager.QuesterFetchResult.Type successType;
            int id;
            FullIdentifier fullIdentifier = new FullIdentifier(request.providerKey(), request.identifier());
            if (this.integerIndex.containsKey(fullIdentifier)) {
                id = this.integerIndex.get(fullIdentifier);
                successType = QuesterDataManager.QuesterFetchResult.Type.SUCCESS_LOADED;
            } else if (request.createIfMissing()) {
                id = this.getNextIndex();
                this.integerIndex.put(fullIdentifier, id);
                ConfigurationSection dataSection = this.indexConfig.createSection("identifiers." + id);
                dataSection.set("provider", (Object)fullIdentifier.provider().asString());
                dataSection.set("identifier", (Object)fullIdentifier.identifier());
                successType = QuesterDataManager.QuesterFetchResult.Type.SUCCESS_CREATED;
            } else {
                return new QuesterDataManager.QuesterFetchResult(QuesterDataManager.QuesterFetchResult.Type.FAILED_NOT_FOUND, null);
            }
            if (this.cachedData.containsKey(id)) {
                dataHandler = this.cachedData.get(id);
            } else {
                dataHandler = new YamlQuesterData(id, fullIdentifier, this);
                if (request.shouldCache()) {
                    this.cachedData.put(id, dataHandler);
                }
            }
            return new QuesterDataManager.QuesterFetchResult(successType, dataHandler);
        });
    }

    @Override
    public CompletableFuture<Integer> resetQuestData(int questId) {
        return CompletableFuture.supplyAsync(() -> {
            int amount = 0;
            for (FullIdentifier identifier : this.integerIndex.keySet()) {
                int dataId = this.integerIndex.get(identifier);
                try {
                    if (this.cachedData.containsKey(dataId)) {
                        if (this.cachedData.get(dataId).removeQuestDataSilently(questId) == null) continue;
                        ++amount;
                        continue;
                    }
                    YamlQuesterData data = new YamlQuesterData(dataId, identifier, this);
                    if (data.removeQuestDataSilently(questId) == null) continue;
                    ++amount;
                    data.save();
                }
                catch (DataSavingException ex) {
                    LOGGER.severe("Failed to reset quest {} data for {}", ex, questId, identifier);
                }
            }
            return amount;
        });
    }

    @Override
    public CompletableFuture<Integer> resetPoolData(int poolId) {
        return CompletableFuture.supplyAsync(() -> {
            int amount = 0;
            for (FullIdentifier identifier : this.integerIndex.keySet()) {
                int dataId = this.integerIndex.get(identifier);
                try {
                    if (this.cachedData.containsKey(dataId)) {
                        if (this.cachedData.get(dataId).removePoolDataSilently(poolId) == null) continue;
                        ++amount;
                        continue;
                    }
                    YamlQuesterData data = new YamlQuesterData(dataId, identifier, this);
                    if (data.removePoolDataSilently(poolId) == null) continue;
                    ++amount;
                    data.save();
                }
                catch (DataSavingException ex) {
                    LOGGER.severe("Failed to reset pool {} data for {}", ex, poolId, identifier);
                }
            }
            return amount;
        });
    }

    @Override
    @NotNull
    public Iterator<? extends QuesterData> getAll() {
        return this.integerIndex.entrySet().stream().map(entry -> {
            YamlQuesterData data = this.cachedData.get(entry.getValue());
            if (data == null) {
                data = new YamlQuesterData((Integer)entry.getValue(), (FullIdentifier)entry.getKey(), this);
            }
            return data;
        }).iterator();
    }

    @Override
    public void save() throws DataSavingException {
        try {
            this.indexConfig.save(this.getIndexFilePath().toFile());
        }
        catch (IOException ex) {
            throw new DataSavingException("Failed to save index file", ex);
        }
    }

    @Override
    public void unload() {
        this.cachedData.clear();
    }

    protected void uncache(@NotNull YamlQuesterData data) {
        this.cachedData.remove(data.getId());
    }

    protected void remove(@NotNull YamlQuesterData data) {
        this.cachedData.remove(data.getId());
        this.integerIndex.remove(data.getFullIdentifier());
        this.indexConfig.set("identifiers." + data.getId(), null);
    }

    record FullIdentifier(@NotNull Key provider, @NotNull String identifier) {
        @Override
        public final String toString() {
            return this.provider.asString() + "|" + this.identifier;
        }
    }
}

