/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.questers.data.yaml;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.data.DataSavingException;
import fr.skytasul.quests.api.data.SavableData;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.questers.data.QuesterPoolData;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageIndex;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.questers.AbstractQuesterDataImplementation;
import fr.skytasul.quests.questers.AbstractQuesterPoolDataImplementation;
import fr.skytasul.quests.questers.AbstractQuesterQuestDataImplementation;
import fr.skytasul.quests.questers.data.yaml.YamlDataManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlQuesterData
extends AbstractQuesterDataImplementation {
    private final int id;
    @NotNull
    private final YamlDataManager.FullIdentifier fullIdentifier;
    @NotNull
    private final YamlDataManager dataManager;
    @NotNull
    private final Path path;
    private YamlConfiguration yaml;

    public YamlQuesterData(int id, @NotNull YamlDataManager.FullIdentifier fullIdentifier, @NotNull YamlDataManager dataManager) {
        this.id = id;
        this.fullIdentifier = fullIdentifier;
        this.dataManager = dataManager;
        this.path = dataManager.getDataPath().resolve(id + ".yml");
        if (Files.exists(this.path, new LinkOption[0])) {
            this.load();
        } else {
            this.yaml = new YamlConfiguration();
        }
        this.yaml.set("provider", (Object)fullIdentifier.provider().asString());
        this.yaml.set("identifier", (Object)fullIdentifier.identifier());
    }

    public int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public Key provider() {
        return this.fullIdentifier.provider();
    }

    @Override
    @NotNull
    public String identifier() {
        return this.fullIdentifier.identifier();
    }

    @NotNull
    public YamlDataManager.FullIdentifier getFullIdentifier() {
        return this.fullIdentifier;
    }

    public void load() {
        String oldProvider;
        this.yaml = YamlConfiguration.loadConfiguration((File)this.path.toFile());
        String oldIdentifier = this.yaml.getString("identifier");
        if (!this.fullIdentifier.identifier().equals(oldIdentifier)) {
            YamlDataManager.LOGGER.warning("Quester data {} is being loaded with a different identifier ({} -> {})", this.id, oldIdentifier, this.fullIdentifier.identifier());
        }
        if ((oldProvider = this.yaml.getString("provider")) != null && !this.fullIdentifier.provider().asString().equals(oldProvider)) {
            YamlDataManager.LOGGER.warning("Quester data {} is being loaded with a different provider ({} -> {})", this.id, oldProvider, this.fullIdentifier.provider());
        }
        if (this.yaml.isList("quests")) {
            List questsMapList = this.yaml.getMapList("quests");
            this.yaml.createSection("quests");
            Iterator iterator = questsMapList.iterator();
            while (iterator.hasNext()) {
                Map questMap = (Map)iterator.next();
                Object questId = questMap.remove("questID");
                this.yaml.createSection("quests." + String.valueOf(questId), questMap);
            }
        }
        if (this.yaml.contains("quests")) {
            for (String string : this.yaml.getConfigurationSection("quests").getKeys(false)) {
                int questId = Integer.parseInt(string);
                try {
                    this.questData.put(questId, new QuestData(questId));
                }
                catch (Exception ex) {
                    YamlDataManager.LOGGER.warning("Failed to load data of quest {0} for quester {1}", ex, questId, this.fullIdentifier);
                }
            }
        }
        if (this.yaml.isList("pools")) {
            List poolsMapList = this.yaml.getMapList("pools");
            this.yaml.createSection("pools");
            for (Map poolMap : poolsMapList) {
                Object poolId = poolMap.remove("poolID");
                this.yaml.createSection("pools." + String.valueOf(poolId), poolMap);
            }
        }
        if (this.yaml.contains("pools")) {
            for (String string : this.yaml.getConfigurationSection("pools").getKeys(false)) {
                int poolId = Integer.parseInt(string);
                try {
                    this.poolData.put(poolId, new PoolData(poolId));
                }
                catch (Exception ex) {
                    YamlDataManager.LOGGER.warning("Failed to load data of pool {0} for quester {1}", ex, poolId, this.fullIdentifier);
                }
            }
        }
        for (SavableData<Object> savableData : QuestsAPI.getAPI().getQuesterManager().getSavableData()) {
            if (!this.yaml.contains(savableData.getId())) continue;
            this.additionalData.put(savableData, this.yaml.getObject(savableData.getId(), savableData.getDataType()));
        }
    }

    @Override
    @NotNull
    public <T> CompletableFuture<Void> setDataInternal(@NotNull SavableData<T> data, @Nullable T value) {
        this.yaml.set(data.getId(), value);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected QuesterQuestData createQuestData(@NotNull Quest quest) {
        return new QuestData(quest.getId());
    }

    @Override
    protected QuesterPoolData createPoolData(@NotNull QuestPool pool) {
        return new PoolData(pool.getId());
    }

    protected QuesterQuestData removeQuestDataSilently(int questId) {
        QuesterQuestData data = this.questData.remove(questId);
        if (data != null) {
            data.remove();
        }
        return data;
    }

    protected QuesterPoolData removePoolDataSilently(int poolId) {
        QuesterPoolData data = this.poolData.remove(poolId);
        if (data != null) {
            data.remove();
        }
        return data;
    }

    @Override
    public void save() throws DataSavingException {
        try {
            this.yaml.save(this.path.toFile());
        }
        catch (IOException ex) {
            throw new DataSavingException("Failed to write to " + this.path.toString(), ex);
        }
    }

    @Override
    public void unload() {
        this.dataManager.uncache(this);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> delete() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.dataManager.remove(this);
                Files.deleteIfExists(this.path);
            }
            catch (IOException ex) {
                throw new CompletionException("Failed to delete the quester file", ex);
            }
        });
    }

    public class QuestData
    extends AbstractQuesterQuestDataImplementation {
        private final ConfigurationSection questConfig;

        public QuestData(int questId) {
            super(questId);
            if (YamlQuesterData.this.yaml.isConfigurationSection("quests." + questId)) {
                this.questConfig = YamlQuesterData.this.yaml.getConfigurationSection("quests." + questId);
                this.load();
            } else {
                this.questConfig = YamlQuesterData.this.yaml.createSection("quests." + questId);
            }
        }

        private void load() {
            if (this.questConfig.contains("datas")) {
                if (this.questConfig.contains("datas.starting_time")) {
                    this.questConfig.set("startingTime", (Object)this.questConfig.getLong("datas.starting_time"));
                    this.questConfig.set("datas.starting_time", null);
                }
                Pattern stageDataPattern = Pattern.compile("stage(\\d+)");
                for (String dataKey : this.questConfig.getConfigurationSection("datas").getKeys(false)) {
                    Matcher stageDataMatcher = stageDataPattern.matcher(dataKey);
                    String newPath = stageDataMatcher.matches() ? "stageData." + stageDataMatcher.group(1) : "additionalData." + dataKey;
                    Utils.copyConfigValue(this.questConfig, "datas." + dataKey, this.questConfig, newPath);
                }
                this.questConfig.set("datas", null);
            }
            if (this.questConfig.contains("timesFinished")) {
                this.finished = this.questConfig.getInt("timesFinished");
            }
            if (this.questConfig.contains("timer")) {
                this.timer = OptionalLong.of(this.questConfig.getLong("timer"));
            }
            if (this.questConfig.contains("currentBranch")) {
                this.branch = OptionalInt.of(this.questConfig.getInt("currentBranch"));
            }
            if (this.questConfig.contains("currentStage")) {
                this.stage = OptionalInt.of(this.questConfig.getInt("currentStage"));
            }
            if (this.questConfig.contains("startingTime")) {
                this.startingTime = OptionalLong.of(this.questConfig.getLong("startingTime"));
            }
            if (this.questConfig.contains("state")) {
                this.state = QuesterQuestData.State.valueOf(this.questConfig.getString("state"));
            } else {
                super.migrateState();
            }
            if (!this.questConfig.getString("questFlow", "").isEmpty() && this.getQuest() != null) {
                for (String flowPart : this.questConfig.getString("questFlow").split(";")) {
                    this.questFlow.add(StageIndex.fromString(flowPart));
                }
            }
            if (this.questConfig.contains("additionalData")) {
                this.additionalData = Utils.mapFromConfigurationSection(this.questConfig.getConfigurationSection("additionalData"));
            }
            if (this.questConfig.contains("stageData")) {
                for (String dataKey : this.questConfig.getConfigurationSection("stageData").getKeys(false)) {
                    this.stageData.put(Integer.parseInt(dataKey), Utils.mapFromConfigurationSection(this.questConfig.getConfigurationSection("stageData." + dataKey)));
                }
            }
        }

        @Override
        public void setTimesFinished(int times) {
            super.setTimesFinished(times);
            this.questConfig.set("timesFinished", (Object)times);
        }

        @Override
        public <T> T setAdditionalData(String key, T value) {
            T t = super.setAdditionalData(key, value);
            this.questConfig.set("additionalData." + key, value);
            return t;
        }

        @Override
        public void setBranch(@NotNull OptionalInt branch) {
            super.setBranch(branch);
            this.questConfig.set("currentBranch", branch.isPresent() ? Integer.valueOf(branch.getAsInt()) : null);
        }

        @Override
        public void setStage(@NotNull OptionalInt stage) {
            super.setStage(stage);
            this.questConfig.set("currentStage", stage.isPresent() ? Integer.valueOf(stage.getAsInt()) : null);
        }

        @Override
        public void setStageData(int stage, Map<String, Object> datas) {
            super.setStageData(stage, datas);
            this.questConfig.set("stageData." + stage, datas);
        }

        @Override
        public void setStartingTime(@NotNull OptionalLong time) {
            super.setStartingTime(time);
            this.questConfig.set("startingTime", time.isPresent() ? Long.valueOf(time.getAsLong()) : null);
        }

        @Override
        public void setState(@NotNull QuesterQuestData.State state) {
            super.setState(state);
            this.questConfig.set("state", (Object)state.name());
        }

        @Override
        public void setTimer(@NotNull OptionalLong timer) {
            super.setTimer(timer);
            this.questConfig.set("timer", timer.isPresent() ? Long.valueOf(timer.getAsLong()) : null);
        }

        @Override
        public void addQuestFlow(StageController finished) {
            super.addQuestFlow(finished);
            this.questConfig.set("questFlow", (Object)this.questFlow.stream().map(StageIndex::toString).collect(Collectors.joining(";")));
        }

        @Override
        public void resetQuestFlow() {
            super.resetQuestFlow();
            this.questConfig.set("questFlow", null);
        }

        @Override
        public CompletableFuture<Void> remove() {
            YamlQuesterData.this.yaml.set("quests." + super.getQuestId(), null);
            return CompletableFuture.completedFuture(null);
        }
    }

    public class PoolData
    extends AbstractQuesterPoolDataImplementation {
        private final ConfigurationSection poolConfig;

        public PoolData(int poolId) {
            super(poolId);
            if (YamlQuesterData.this.yaml.isConfigurationSection("pools." + poolId)) {
                this.poolConfig = YamlQuesterData.this.yaml.getConfigurationSection("pools." + poolId);
                this.load();
            } else {
                this.poolConfig = YamlQuesterData.this.yaml.createSection("pools." + poolId);
            }
        }

        private void load() {
            this.lastGive = this.poolConfig.getLong("lastGive");
            if (this.poolConfig.isList("completedQuests")) {
                this.completedQuests = this.poolConfig.getIntegerList("completedQuests").stream().collect(Collectors.toSet());
            } else if (this.poolConfig.contains("completedQuests")) {
                Object comp = this.poolConfig.get("completedQuests");
                if (comp instanceof Set) {
                    Set compSet = (Set)comp;
                    this.setCompletedQuests(compSet);
                } else {
                    YamlDataManager.LOGGER.warning("Cannot load pool {0} completed quests from type {1} for quester {2}", this.poolId, comp.getClass().getName(), YamlQuesterData.this.id);
                }
            }
        }

        @Override
        public void setLastGive(long lastGive) {
            super.setLastGive(lastGive);
            this.poolConfig.set("lastGive", (Object)lastGive);
        }

        @Override
        public void setCompletedQuests(Set<Integer> completedQuests) {
            super.setCompletedQuests(completedQuests);
            this.poolConfig.set("completedQuests", completedQuests.stream().toList());
        }

        @Override
        @NotNull
        public CompletableFuture<Void> remove() {
            YamlQuesterData.this.yaml.set("pools." + this.poolId, null);
            return CompletableFuture.completedFuture(null);
        }
    }
}

