/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.quests.questers;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.options.description.QuestDescriptionContext;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.quests.quester.QuestQuesterStrategy;
import fr.skytasul.quests.api.serializable.SerializableObject;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerQuesterStrategy
extends QuestQuesterStrategy {
    private final PlayerManager playerManager;

    public PlayerQuesterStrategy(@NotNull PlayerManager playerManager) {
        super(QuestsAPI.getAPI().getQuestQuesterStrategyRegistry());
        this.playerManager = playerManager;
    }

    @Override
    @NotNull
    public Optional<? extends Quester> getPlayerQuester(@NotNull Player player) {
        return Optional.ofNullable(this.playerManager.getQuester(player));
    }

    @Override
    public boolean isQuesterApplicable(@NotNull Quester quester) {
        return quester.getProvider() == this.playerManager;
    }

    @Override
    public boolean shouldAllPlayersMatchRequirements() {
        return false;
    }

    @Override
    @Nullable
    public String getTooltip(@NotNull QuestDescriptionContext context) {
        return null;
    }

    @Override
    @NotNull
    public SerializableObject clone() {
        return this;
    }

    @Override
    public void save(@NotNull ConfigurationSection section) {
    }

    @Override
    public void load(@NotNull ConfigurationSection section) {
    }
}

