/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.requirements;

import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.base.XBase;
import com.google.common.collect.ImmutableMap;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.comparison.ItemComparisonMap;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.gui.templates.StaticPagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.gui.items.ItemComparisonGUI;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class EquipmentRequirement
extends AbstractRequirement {
    private EquipmentSlot slot;
    private ItemStack item;
    private ItemComparisonMap comparisons;

    public EquipmentRequirement() {
    }

    public EquipmentRequirement(String customDescription, String customReason, EquipmentSlot slot, ItemStack item, ItemComparisonMap comparisons) {
        super(customDescription, customReason);
        this.slot = slot;
        this.item = item;
        this.comparisons = comparisons;
    }

    @Override
    public boolean test(Player p) {
        ItemStack playerItem = p.getInventory().getItem(this.slot);
        return this.comparisons.isSimilar(playerItem, this.item) && playerItem.getAmount() >= this.item.getAmount();
    }

    @Override
    public AbstractRequirement clone() {
        return new EquipmentRequirement(this.getCustomDescription(), this.getCustomReason(), this.slot, this.item, this.comparisons);
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        if (this.slot != null) {
            loreBuilder.addDescription(this.slot.name() + ": " + ItemUtils.getName(this.item));
        }
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        if (event.isInCreation()) {
            this.comparisons = new ItemComparisonMap();
        }
        new EquipmentSlotGUI(newSlot -> {
            if (newSlot == null) {
                event.cancel();
                return;
            }
            QuestsPlugin.getPlugin().getGuiManager().getFactory().createItemSelection(newItem -> {
                if (newItem == null) {
                    event.cancel();
                    return;
                }
                this.slot = newSlot;
                this.item = newItem;
                new ItemComparisonGUI(this.comparisons, event::reopenGUI).open(event.getPlayer());
            }, true).open(event.getPlayer());
        }).allowCancel().open(event.getPlayer());
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("slot", (Object)this.slot.name());
        section.set("item", (Object)this.item);
        if (!this.comparisons.isDefault()) {
            section.set("comparisons", this.comparisons.getNotDefault());
        }
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.slot = EquipmentSlot.valueOf((String)section.getString("slot"));
        this.item = section.getItemStack("item");
        this.comparisons = section.contains("comparisons") ? new ItemComparisonMap(section.getConfigurationSection("comparisons")) : new ItemComparisonMap();
    }

    public static class EquipmentSlotGUI
    extends StaticPagedGUI<EquipmentSlot> {
        private static final Map<EquipmentSlot, ItemStack> OBJECTS = ImmutableMap.builder().put((Object)EquipmentSlot.HAND, (Object)ItemUtils.item(XMaterial.GOLDEN_SWORD, "\u00a76Main hand", new String[0])).put((Object)EquipmentSlot.OFF_HAND, (Object)ItemUtils.item(XMaterial.SHIELD, "\u00a7eOff hand", new String[0])).put((Object)EquipmentSlot.FEET, (Object)ItemUtils.item(XMaterial.IRON_BOOTS, "\u00a7bFeet", new String[0])).put((Object)EquipmentSlot.LEGS, (Object)ItemUtils.item(XMaterial.IRON_LEGGINGS, "\u00a7bLegs", new String[0])).put((Object)EquipmentSlot.CHEST, (Object)ItemUtils.item(XMaterial.ELYTRA, "\u00a7bChest", new String[0])).put((Object)EquipmentSlot.HEAD, (Object)ItemUtils.item((XMaterial)XMaterial.TURTLE_HELMET.or((XBase)XMaterial.IRON_HELMET), "\u00a7bHead", new String[0])).build();

        public EquipmentSlotGUI(Consumer<EquipmentSlot> clicked) {
            super(Lang.INVENTORY_EQUIPMENT_SLOTS.toString(), DyeColor.BROWN, OBJECTS, clicked, Enum::name);
        }
    }
}

