/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.requirements;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.gui.templates.ListGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.DyeColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PermissionsRequirement
extends AbstractRequirement {
    private List<Permission> permissions;

    public PermissionsRequirement() {
        this(null, null, new ArrayList<Permission>());
    }

    public PermissionsRequirement(String customDescription, String customReason, List<Permission> permissions) {
        super(customDescription, customReason);
        this.permissions = permissions;
    }

    @Override
    public boolean test(Player p) {
        for (Permission perm : this.permissions) {
            if (perm.match(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexed("permissions_amount", this.permissions.size());
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(Lang.AmountPermissions.format((HasPlaceholders)this));
    }

    @Override
    protected void sendCustomReasonHelpMessage(Player p) {
        Lang.CHOOSE_PERM_REQUIRED_MESSAGE.send((CommandSender)p);
    }

    @Override
    public void itemClick(final QuestObjectClickEvent event) {
        new ListGUI<Permission>(Lang.INVENTORY_PERMISSION_LIST.toString(), DyeColor.PURPLE, this.permissions){

            @Override
            public ItemStack getObjectItemStack(Permission object) {
                return ItemUtils.item(XMaterial.PAPER, object.toString(), this.createLoreBuilder(object).toLoreArray());
            }

            @Override
            public void createObject(Function<Permission, ItemStack> callback) {
                Lang.CHOOSE_PERM_REQUIRED.send((CommandSender)this.player);
                new TextEditor<String>(this.player, this::reopen, obj -> callback.apply(Permission.fromString(obj))).useStrippedMessage().start();
            }

            @Override
            public void finish(List<Permission> objects) {
                PermissionsRequirement.this.permissions = objects;
                Lang.CHOOSE_PERM_REQUIRED_MESSAGE.send((CommandSender)this.player);
                new TextEditor<String>(this.player, event::reopenGUI, obj -> {
                    PermissionsRequirement.this.setCustomReason((String)obj);
                    event.reopenGUI();
                }).passNullIntoEndConsumer().start();
            }
        }.open(event.getPlayer());
    }

    @Override
    public AbstractRequirement clone() {
        return new PermissionsRequirement(this.getCustomDescription(), this.getCustomReason(), new ArrayList<Permission>(this.permissions));
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("permissions", this.permissions.stream().map(Permission::toString).collect(Collectors.toList()));
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.permissions = section.getStringList("permissions").stream().map(Permission::fromString).collect(Collectors.toList());
        if (section.contains("message")) {
            this.setCustomReason(section.getString("message"));
        }
    }

    public static class Permission {
        private final String permission;
        private final boolean value;

        public Permission(String permission, boolean value) {
            this.permission = permission;
            this.value = value;
        }

        public boolean match(Player p) {
            boolean has = p.hasPermission(this.permission);
            return has == this.value;
        }

        public String toString() {
            return (this.value ? "" : "-") + this.permission;
        }

        public static Permission fromString(String string) {
            boolean neg = string.startsWith("-");
            return new Permission(string.substring(neg ? 1 : 0), !neg);
        }
    }
}

