/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.requirements;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class QuestRequirement
extends AbstractRequirement {
    private int questId;
    private Quest cached;

    public QuestRequirement() {
        this(null, null, -1);
    }

    public QuestRequirement(String customDescription, String customReason, int questId) {
        super(customDescription, customReason);
        this.questId = questId;
    }

    @Override
    public boolean test(Player p) {
        if (this.exists()) {
            return this.cached.hasFinished(PlayerManager.getPlayerAccount(p));
        }
        return true;
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexed("quest_name", () -> this.exists() ? this.cached.getName() : Integer.toString(this.questId));
        placeholders.register("quest_id", () -> Integer.toString(this.questId));
    }

    @Override
    protected String getDefaultReason(Player player) {
        return this.exists() ? Lang.REQUIREMENT_QUEST.format((HasPlaceholders)this.cached) : null;
    }

    @Override
    public String getDefaultDescription(Player p) {
        return Lang.RDQuest.format(this.exists() ? this.cached : this);
    }

    private boolean exists() {
        this.cached = QuestsAPI.getAPI().getQuestsManager().getQuest(this.questId);
        return this.cached != null;
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(QuestOption.formatNullableValue(this.exists() ? this.cached.getName() : null));
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        QuestsPlugin.getPlugin().getGuiManager().getFactory().createQuestSelection(quest -> {
            this.questId = quest.getId();
            event.reopenGUI();
        }, event::remove, QuestsAPI.getAPI().getQuestsManager().getQuests()).open(event.getPlayer());
    }

    @Override
    public AbstractRequirement clone() {
        return new QuestRequirement(this.getCustomDescription(), this.getCustomReason(), this.questId);
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("questID", (Object)this.questId);
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.questId = section.getInt("questID");
    }
}

