/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.requirements.logical;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.objects.QuestObjectLocation;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.requirements.RequirementList;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class LogicalOrRequirement
extends AbstractRequirement {
    private RequirementList requirements;

    public LogicalOrRequirement() {
        this(null, null, new RequirementList());
    }

    public LogicalOrRequirement(String customDescription, String customReason, RequirementList requirements) {
        super(customDescription, customReason);
        this.requirements = requirements;
    }

    @Override
    public void attach(Quest quest) {
        super.attach(quest);
        this.requirements.attachQuest(quest);
    }

    @Override
    public void detach() {
        super.detach();
        this.requirements.detachQuest();
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(this.requirements.getSizeString());
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        QuestsAPI.getAPI().getRequirements().createGUI(QuestObjectLocation.OTHER, requirements -> {
            this.requirements = new RequirementList((Collection<AbstractRequirement>)requirements);
            event.reopenGUI();
        }, this.requirements).open(event.getPlayer());
    }

    @Override
    public boolean test(Player p) {
        return this.requirements.anyMatch(p);
    }

    @Override
    public AbstractRequirement clone() {
        return new LogicalOrRequirement(this.getCustomDescription(), this.getCustomReason(), new RequirementList(this.requirements));
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("requirements", this.requirements.serialize());
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.requirements = RequirementList.deserialize(section.getMapList("requirements"));
    }
}

