/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.rewards;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.gui.templates.ListGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardGiveContext;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.gui.misc.CommandGUI;
import fr.skytasul.quests.utils.types.Command;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CommandReward
extends AbstractReward {
    public List<Command> commands = new ArrayList<Command>();

    public CommandReward() {
    }

    public CommandReward(String customDescription, List<Command> list) {
        super(customDescription);
        if (list != null) {
            this.commands.addAll(list);
        }
    }

    @Override
    public void give(RewardGiveContext context) {
        for (Player player : context.getQuester().getOnlinePlayers()) {
            for (Command cmd : this.commands) {
                cmd.execute(player);
            }
        }
    }

    @Override
    public AbstractReward clone() {
        return new CommandReward(this.getCustomDescription(), this.commands);
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(this.getCommandsSizeString());
    }

    @NotNull
    private String getCommandsSizeString() {
        return Lang.commands.quickFormat("amount", this.commands.size());
    }

    @Override
    public void itemClick(final QuestObjectClickEvent event) {
        new ListGUI<Command>(Lang.INVENTORY_COMMANDS_LIST.toString(), DyeColor.ORANGE, this.commands){

            @Override
            public void createObject(Function<Command, ItemStack> callback) {
                new CommandGUI(callback::apply, this::reopen).open(this.player);
            }

            @Override
            public void clickObject(Command object, ItemStack item, ClickType clickType) {
                new CommandGUI(command -> {
                    this.updateObject(object, command);
                    this.reopen();
                }, this::reopen).setFromExistingCommand(object).open(this.player);
            }

            @Override
            public ItemStack getObjectItemStack(Command cmd) {
                return ItemUtils.item(XMaterial.CHAIN_COMMAND_BLOCK, Lang.commandsListValue.format((HasPlaceholders)cmd), this.createLoreBuilder(cmd).addDescription(Lang.commandsListConsole.format((HasPlaceholders)cmd.getPlaceholdersRegistry().shifted("command_console"))).toLoreArray());
            }

            @Override
            public void finish(List<Command> objects) {
                CommandReward.this.commands = objects;
                event.reopenGUI();
            }
        }.open(event.getPlayer());
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("commands", Utils.serializeList(this.commands, Command::serialize));
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.commands.addAll(Utils.deserializeList(section.getMapList("commands"), Command::deserialize));
    }
}

