/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.rewards;

import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardGiveContext;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.gui.items.ItemsGUI;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemReward
extends AbstractReward {
    public List<ItemStack> items;

    public ItemReward() {
        this(null, new ArrayList<ItemStack>());
    }

    public ItemReward(String customDescription, List<ItemStack> items) {
        super(customDescription);
        this.items = items;
    }

    @Override
    public void give(RewardGiveContext context) {
        for (Player player : context.getQuester().getOnlinePlayers()) {
            Utils.giveItems(player, this.items);
        }
        if (!this.items.isEmpty()) {
            context.addEarning(this);
        }
    }

    @Override
    public AbstractReward clone() {
        return new ItemReward(this.getCustomDescription(), this.items);
    }

    @Override
    public String getDefaultDescription(Player p) {
        return Lang.AmountItems.toString();
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.register("items_amount", () -> Integer.toString(this.getItemsSize()));
    }

    private int getItemsSize() {
        return this.items.stream().mapToInt(ItemStack::getAmount).sum();
    }

    private String getItemsSizeString() {
        return Lang.AmountItems.quickFormat("items_amount", this.getItemsSize());
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(this.getItemsSizeString());
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        new ItemsGUI(items -> {
            this.items = items;
            event.reopenGUI();
        }, this.items).open(event.getPlayer());
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("items", Utils.serializeList(this.items, ItemStack::serialize));
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.items.addAll(Utils.deserializeList(section.getMapList("items"), ItemStack::deserialize));
    }
}

