/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.rewards;

import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardGiveContext;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class MessageReward
extends AbstractReward {
    public String text;

    public MessageReward() {
    }

    public MessageReward(String customDescription, String text) {
        super(customDescription);
        this.text = text;
    }

    @Override
    public void give(RewardGiveContext context) {
        MessageUtils.sendMessage(context.getQuester(), this.text, (MessageType)MessageType.DefaultMessageType.OFF);
    }

    @Override
    public AbstractReward clone() {
        return new MessageReward(this.getCustomDescription(), this.text);
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.register("message", () -> this.text);
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescriptionAsValue(this.text);
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        Lang.WRITE_MESSAGE.send((CommandSender)event.getPlayer());
        new TextEditor<String>(event.getPlayer(), event::cancel, obj -> {
            this.text = obj;
            event.reopenGUI();
        }).start();
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("text", (Object)this.text);
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.text = section.getString("text");
    }
}

