/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.rewards;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.objects.QuestObjectLocation;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardGiveContext;
import fr.skytasul.quests.api.rewards.RewardList;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomReward
extends AbstractReward {
    private RewardList rewards;
    private int min;
    private int max;

    public RandomReward() {
        this(null, new RewardList(), 1, 1);
    }

    public RandomReward(String customDescription, RewardList rewards, int min, int max) {
        super(customDescription);
        this.rewards = rewards;
        this.min = min;
        this.max = max;
    }

    public void setMinMax(int min, int max) {
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
        if (max > this.rewards.size()) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Random reward with max amount (" + max + ") greater than amount of rewards available (" + this.rewards.size() + ") in " + this.debugName());
        }
    }

    @Override
    public void attach(Quest quest) {
        super.attach(quest);
        this.rewards.attachQuest(quest);
    }

    @Override
    public void detach() {
        super.detach();
        this.rewards.detachQuest();
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.register("min", () -> Integer.toString(this.min));
        placeholders.register("max", () -> Integer.toString(this.max));
        placeholders.register("rewards_amount", () -> this.rewards.getSizeString());
    }

    @Override
    public void give(RewardGiveContext context) {
        for (Player player : context.getQuester().getOnlinePlayers()) {
            this.give(context, player);
        }
    }

    private void give(@NotNull RewardGiveContext context, @NotNull Player player) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int amount = this.min == this.max ? this.min : random.nextInt(this.min, this.max + 1);
        ArrayList<AbstractReward> leftRewards = new ArrayList<AbstractReward>(this.rewards);
        ArrayList<AbstractReward> randomRewards = new ArrayList<AbstractReward>(amount);
        for (int i = 0; i < amount && !leftRewards.isEmpty(); ++i) {
            randomRewards.add(leftRewards.remove(random.nextInt(leftRewards.size())));
        }
        new RewardList(randomRewards).giveSubrewards(player, context);
    }

    @Override
    public boolean isAsync() {
        return this.rewards.hasAsync();
    }

    @Override
    public AbstractReward clone() {
        return new RandomReward(this.getCustomDescription(), new RewardList(this.rewards), this.min, this.max);
    }

    @Override
    public String getDefaultDescription(Player p) {
        return this.rewards.stream().map(req -> req.getDescription(p)).filter(Objects::nonNull).collect(Collectors.joining("{JOIN}"));
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(Lang.actions.quickFormat("amount", this.rewards.size()));
        loreBuilder.addDescriptionRaw("\u00a78 | min: \u00a77" + this.min + "\u00a78 | max: \u00a77" + this.max);
        loreBuilder.addClick(ClickType.LEFT, Lang.rewardRandomRewards.toString());
        loreBuilder.addClick(ClickType.RIGHT, Lang.rewardRandomMinMax.toString());
    }

    @Override
    @Nullable
    protected ClickType getCustomDescriptionClick() {
        return ClickType.SHIFT_RIGHT;
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        if (event.isInCreation() || event.getClick().isLeftClick()) {
            QuestsAPI.getAPI().getRewards().createGUI(QuestObjectLocation.OTHER, rewards -> {
                this.rewards = new RewardList((Collection<AbstractReward>)rewards);
                event.reopenGUI();
            }, this.rewards).open(event.getPlayer());
        } else if (event.getClick().isRightClick()) {
            Lang.REWARD_EDITOR_RANDOM_MIN.send((CommandSender)event.getPlayer());
            new TextEditor<Integer>(event.getPlayer(), event::reopenGUI, min -> {
                Lang.REWARD_EDITOR_RANDOM_MAX.send((CommandSender)event.getPlayer());
                new TextEditor<Integer>(event.getPlayer(), event::reopenGUI, max -> {
                    this.setMinMax((int)min, max == null ? min : max);
                    event.reopenGUI();
                }, NumberParser.INTEGER_PARSER_STRICT_POSITIVE).passNullIntoEndConsumer().start();
            }, NumberParser.INTEGER_PARSER_POSITIVE).start();
        }
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("rewards", this.rewards.serialize());
        section.set("min", (Object)this.min);
        section.set("max", (Object)this.max);
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.rewards = RewardList.deserialize(section.getMapList("rewards"));
        this.setMinMax(section.getInt("min"), section.getInt("max"));
    }
}

