/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.rewards;

import fr.skytasul.quests.api.comparison.ItemComparisonMap;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardGiveContext;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.gui.items.ItemComparisonGUI;
import fr.skytasul.quests.gui.items.ItemsGUI;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RemoveItemsReward
extends AbstractReward {
    private List<ItemStack> items;
    private ItemComparisonMap comparisons;

    public RemoveItemsReward() {
        this(null, new ArrayList<ItemStack>(), new ItemComparisonMap());
    }

    public RemoveItemsReward(String customDescription, List<ItemStack> items, ItemComparisonMap comparisons) {
        super(customDescription);
        this.items = items;
        this.comparisons = comparisons;
    }

    @Override
    public void give(RewardGiveContext context) {
        for (Player player : context.getQuester().getOnlinePlayers()) {
            for (ItemStack item : this.items) {
                this.comparisons.removeItems((Inventory)player.getInventory(), item);
            }
        }
    }

    @Override
    public AbstractReward clone() {
        return new RemoveItemsReward(this.getCustomDescription(), this.items, this.comparisons);
    }

    @Override
    public String getDefaultDescription(Player p) {
        return this.getItemsSizeString();
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.register("items_amount", this::getItemsSizeString);
        placeholders.register("comparisons_amount", this::getComparisonsSizeString);
    }

    private String getItemsSizeString() {
        return Lang.AmountItems.quickFormat("items_amount", this.items.stream().mapToInt(ItemStack::getAmount).sum());
    }

    @NotNull
    private String getComparisonsSizeString() {
        return Lang.AmountComparisons.quickFormat("comparisons_amount", this.comparisons.getEffective().size());
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(this.getItemsSizeString());
        loreBuilder.addDescription(this.getComparisonsSizeString());
        loreBuilder.addClick(ClickType.LEFT, Lang.stageItems.toString());
        loreBuilder.addClick(ClickType.RIGHT, Lang.stageItemsComparison.toString());
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        if (event.isInCreation() || event.getClick().isLeftClick()) {
            new ItemsGUI(items -> {
                this.items = items;
                event.reopenGUI();
            }, this.items).open(event.getPlayer());
        } else if (event.getClick().isRightClick()) {
            new ItemComparisonGUI(this.comparisons, event::reopenGUI).open(event.getPlayer());
        }
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("items", Utils.serializeList(this.items, ItemStack::serialize));
        if (!this.comparisons.getNotDefault().isEmpty()) {
            section.createSection("comparisons", this.comparisons.getNotDefault());
        }
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.items.addAll(Utils.deserializeList(section.getMapList("items"), ItemStack::deserialize));
        if (section.contains("comparisons")) {
            this.comparisons.setNotDefaultComparisons(section.getConfigurationSection("comparisons"));
        }
    }
}

