/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.rewards;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.gui.layout.LayoutedButton;
import fr.skytasul.quests.api.gui.layout.LayoutedClickEvent;
import fr.skytasul.quests.api.gui.layout.LayoutedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.objects.QuestObjectLocation;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.requirements.RequirementList;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardGiveContext;
import fr.skytasul.quests.api.rewards.RewardList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class RequirementDependentReward
extends AbstractReward {
    private RequirementList requirements;
    private RewardList rewards;

    public RequirementDependentReward() {
        this(null, new RequirementList(), new RewardList());
    }

    public RequirementDependentReward(String customDescription, RequirementList requirements, RewardList rewards) {
        super(customDescription);
        this.requirements = requirements;
        this.rewards = rewards;
    }

    @Override
    public void attach(Quest quest) {
        super.attach(quest);
        this.requirements.attachQuest(quest);
        this.rewards.attachQuest(quest);
    }

    @Override
    public void detach() {
        super.detach();
        this.requirements.detachQuest();
        this.rewards.detachQuest();
    }

    @Override
    public void give(RewardGiveContext context) {
        for (Player player : context.getQuester().getOnlinePlayers()) {
            if (!this.requirements.allMatch(player, false)) continue;
            this.rewards.giveSubrewards(player, context);
        }
    }

    @Override
    public boolean isAsync() {
        return this.rewards.hasAsync();
    }

    @Override
    public AbstractReward clone() {
        return new RequirementDependentReward(this.getCustomDescription(), new RequirementList(this.requirements), new RewardList(this.rewards));
    }

    @Override
    public String getDefaultDescription(@Nullable Player p) {
        if (p == null || !this.requirements.allMatch(p, false)) {
            return null;
        }
        return this.rewards.stream().map(xreq -> xreq.getDescription(p)).filter(Objects::nonNull).collect(Collectors.joining("{JOIN}"));
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(this.rewards.getSizeString());
        loreBuilder.addDescription(this.requirements.getSizeString());
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        LayoutedGUI.newBuilder().addButton(0, LayoutedButton.create(XMaterial.NETHER_STAR, () -> "\u00a7b" + this.requirements.getSizeString(), Collections.emptyList(), this::editRequirements)).addButton(1, LayoutedButton.create(XMaterial.CHEST, () -> "\u00a7a" + this.rewards.getSizeString(), Collections.emptyList(), this::editRewards)).addButton(4, LayoutedButton.create(QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone(), __ -> event.reopenGUI())).setName(Lang.INVENTORY_REWARDS_WITH_REQUIREMENTS.toString()).setCloseBehavior(StandardCloseBehavior.REOPEN).build().open(event.getPlayer());
    }

    private void editRequirements(LayoutedClickEvent event) {
        QuestsAPI.getAPI().getRequirements().createGUI(QuestObjectLocation.OTHER, newRequirements -> {
            this.requirements = new RequirementList((Collection<AbstractRequirement>)newRequirements);
            event.refreshItemReopen();
        }, this.requirements).open(event.getPlayer());
    }

    private void editRewards(LayoutedClickEvent event) {
        QuestsAPI.getAPI().getRewards().createGUI(QuestObjectLocation.OTHER, newRewards -> {
            this.rewards = new RewardList((Collection<AbstractReward>)newRewards);
            event.refreshItemReopen();
        }, this.rewards).open(event.getPlayer());
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("requirements", this.requirements.serialize());
        section.set("rewards", this.rewards.serialize());
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.requirements = RequirementList.deserialize(section.getMapList("requirements"));
        this.rewards = RewardList.deserialize(section.getMapList("rewards"));
    }
}

