/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.rewards;

import fr.skytasul.quests.api.editors.WaitClick;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardGiveContext;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.gui.npc.NpcCreateGUI;
import fr.skytasul.quests.utils.QuestUtils;
import fr.skytasul.quests.utils.types.BQLocation;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class TeleportationReward
extends AbstractReward {
    public Location teleportation;

    public TeleportationReward() {
    }

    public TeleportationReward(String customDescription, Location teleportation) {
        super(customDescription);
        this.teleportation = teleportation;
    }

    @Override
    public void give(RewardGiveContext context) {
        QuestUtils.runOrSync(() -> {
            for (Player player : context.getQuester().getOnlinePlayers()) {
                player.teleport(this.teleportation);
            }
        });
    }

    @Override
    public AbstractReward clone() {
        return new TeleportationReward(this.getCustomDescription(), this.teleportation.clone());
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescriptionAsValue(Lang.Location.format((HasPlaceholders)(this.teleportation == null ? null : BQLocation.of(this.teleportation))));
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        Lang.MOVE_TELEPORT_POINT.send((CommandSender)event.getPlayer());
        new WaitClick(event.getPlayer(), event::cancel, NpcCreateGUI.validMove.clone(), () -> {
            this.teleportation = event.getPlayer().getLocation();
            event.reopenGUI();
        }).start();
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("tp", (Object)this.teleportation.serialize());
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.teleportation = Location.deserialize((Map)section.getConfigurationSection("tp").getValues(false));
    }
}

