/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.rewards;

import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardGiveContext;
import fr.skytasul.quests.gui.misc.TitleGUI;
import fr.skytasul.quests.utils.types.Title;
import org.bukkit.configuration.ConfigurationSection;

public class TitleReward
extends AbstractReward {
    private Title title;

    public TitleReward() {
    }

    public TitleReward(String customDescription, Title title) {
        super(customDescription);
        this.title = title;
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescriptionAsValue(this.title);
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        new TitleGUI(newTitle -> {
            if (newTitle == null) {
                event.cancel();
                return;
            }
            this.title = newTitle;
            event.reopenGUI();
        }).edit(this.title).open(event.getPlayer());
    }

    @Override
    public void give(RewardGiveContext context) {
        if (this.title != null) {
            this.title.send(context.getQuester());
        }
    }

    @Override
    public AbstractReward clone() {
        return new TitleReward(this.getCustomDescription(), this.title);
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        if (this.title != null) {
            this.title.serialize(section.createSection("title"));
        }
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.title = section.contains("title") ? Title.deserialize(section.getConfigurationSection("title")) : null;
    }
}

