/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.rewards;

import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardGiveContext;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class WaitReward
extends AbstractReward {
    private int delay;

    public WaitReward() {
    }

    public WaitReward(String customDescription, int delay) {
        super(customDescription);
        this.delay = delay;
    }

    @Override
    public boolean isAsync() {
        return this.delay != 0;
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescriptionAsValue(this.getTicksString());
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.register("delay", this::getTicksString);
    }

    @NotNull
    private String getTicksString() {
        return Lang.Ticks.quickFormat("ticks", this.delay);
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        Lang.REWARD_EDITOR_WAIT.send((CommandSender)event.getPlayer());
        new TextEditor<Integer>(event.getPlayer(), event::cancel, obj -> {
            this.delay = obj;
            event.reopenGUI();
        }, NumberParser.INTEGER_PARSER_STRICT_POSITIVE).start();
    }

    @Override
    public void give(RewardGiveContext context) {
        try {
            Thread.sleep((long)this.delay * 50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public AbstractReward clone() {
        return new WaitReward(this.getCustomDescription(), this.delay);
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("delay", (Object)this.delay);
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.delay = section.getInt("delay");
    }
}

