/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.scoreboards;

import fr.mrmicky.fastboard.FastBoard;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.options.description.QuestDescriptionContext;
import fr.skytasul.quests.api.options.description.QuestDescriptionProvider;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.QuesterManager;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.quests.QuestsManager;
import fr.skytasul.quests.api.utils.ChatColorUtils;
import fr.skytasul.quests.api.utils.PlayerListCategory;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import fr.skytasul.quests.scoreboards.ScoreboardLine;
import fr.skytasul.quests.scoreboards.ScoreboardManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class Scoreboard
implements Listener {
    private static final Pattern QUEST_PLACEHOLDER = Pattern.compile("\\{quest_(.+)\\}");
    private static final int maxLength = 1024;
    private final Player p;
    private final ScoreboardManager manager;
    private final QuesterManager questerManager;
    private final BukkitTask task;
    private FastBoard board;
    private LinkedList<Line> lines = new LinkedList();
    private List<QuestEntry> launched;
    private List<QuestEntry> shown;
    private OptionalInt shownIndex = OptionalInt.empty();
    private boolean hid = false;
    private boolean hidForce = false;
    private int changeTime = 0;
    private int autoHideTime;

    Scoreboard(Player player, ScoreboardManager manager, QuesterManager questerManager, QuestsManager questsManager) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BeautyQuests.getInstance());
        this.p = player;
        this.manager = manager;
        this.questerManager = questerManager;
        for (ScoreboardLine line : manager.getScoreboardLines()) {
            this.lines.add(new Line(line));
        }
        this.launched = questerManager.getPlayerQuesters(player).stream().flatMap(quester -> questsManager.getQuestsStarted((Quester)quester, false, true).stream().map(quest -> new QuestEntry((Quest)quest, (Quester)quester))).collect(Collectors.toList());
        this.shown = new ArrayList<QuestEntry>(this.launched);
        this.hid = !manager.isWorldAllowed(this.p.getWorld().getName());
        this.autoHideTime = manager.getAutoHideTime();
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)BeautyQuests.getInstance(), this::periodicRefresh, 2L, 20L);
    }

    private void periodicRefresh() {
        if (!this.p.isOnline()) {
            return;
        }
        if (this.hid) {
            return;
        }
        if (this.autoHideTime != -1) {
            if (this.autoHideTime > 0) {
                --this.autoHideTime;
            } else {
                if (this.board != null) {
                    this.deleteBoard();
                }
                return;
            }
        }
        if (this.board == null) {
            if (!this.manager.hideEmptyScoreboard() || !this.shown.isEmpty()) {
                this.initScoreboard();
            } else {
                return;
            }
        }
        if (this.changeTime > 0) {
            --this.changeTime;
        } else {
            this.resetChangeTime();
            if (!this.shown.isEmpty()) {
                int newId = this.shownIndex.isEmpty() ? 0 : (this.shownIndex.getAsInt() + 1) % this.shown.size();
                if (this.shownIndex.isEmpty() || newId != this.shownIndex.getAsInt()) {
                    this.shownIndex = OptionalInt.of(newId);
                    this.refreshQuestsLines(false);
                }
            }
        }
        this.updateBoard(false, true);
    }

    protected Optional<QuestEntry> getShown() {
        if (this.shownIndex.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.shown.get(this.shownIndex.getAsInt()));
    }

    public Optional<QuestEntry> getEntry(@NotNull Quest quest, @NotNull Quester quester) {
        return this.launched.stream().filter(entry -> entry.applies(quest, quester)).findAny();
    }

    private boolean hasPinnedEntry() {
        return this.launched.stream().anyMatch(entry -> entry.pinned);
    }

    private void handleEmptyShown() {
        if (!this.launched.isEmpty()) {
            this.shown.addAll(this.launched);
            this.shownIndex = OptionalInt.of(0);
        } else {
            this.shownIndex = OptionalInt.empty();
            if (this.manager.hideEmptyScoreboard() && this.board != null) {
                this.deleteBoard();
            }
        }
    }

    private void removeShown(QuestEntry entry) {
        if (!this.shown.contains(entry)) {
            return;
        }
        int index = this.shown.indexOf(entry);
        this.shown.remove(index);
        if (this.shownIndex.isEmpty()) {
            return;
        }
        if (this.shown.isEmpty()) {
            this.handleEmptyShown();
            return;
        }
        if (index == this.shownIndex.getAsInt()) {
            this.shownIndex = OptionalInt.of(index % this.shown.size());
            this.resetChangeTime();
            this.refreshQuestsLines(true);
        } else if (index < this.shownIndex.getAsInt()) {
            this.shownIndex = OptionalInt.of(this.shownIndex.getAsInt() - 1);
        }
    }

    protected void questAdd(@NotNull Quest quest, @NotNull Quester quester) {
        QuestEntry entry = new QuestEntry(quest, quester);
        this.launched.add(entry);
        if (this.hasPinnedEntry()) {
            return;
        }
        int index = this.shownIndex.orElse(-1) + 1;
        this.shown.add(index, entry);
        this.setShownQuest(quest, quester, true);
    }

    protected void questRemove(@NotNull Quest quest) {
        Iterator<QuestEntry> iterator = this.launched.iterator();
        while (iterator.hasNext()) {
            QuestEntry entry = iterator.next();
            if (!entry.quest.equals(quest)) continue;
            iterator.remove();
            this.shown.remove(entry);
        }
        if (this.shown.isEmpty()) {
            this.handleEmptyShown();
        }
    }

    protected void questRemove(@NotNull Quest quest, @NotNull Quester quester) {
        Optional<QuestEntry> entryOpt = this.getEntry(quest, quester);
        if (entryOpt.isEmpty()) {
            return;
        }
        this.launched.remove(entryOpt.get());
        this.removeShown(entryOpt.get());
    }

    protected void questEdited(Quest newQuest, Quest oldQuest) {
        for (Quester quester : this.questerManager.getPlayerQuesters(this.p)) {
            if (!newQuest.getQuesterStrategy().isQuesterApplicable(quester)) continue;
            Optional<QuestEntry> entryOpt = this.getEntry(oldQuest, quester);
            if (entryOpt.isEmpty()) {
                if (!newQuest.isScoreboardEnabled() || !newQuest.hasStarted(quester)) continue;
                this.questAdd(newQuest, quester);
                continue;
            }
            if (!newQuest.isScoreboardEnabled()) {
                this.questRemove(oldQuest, quester);
                continue;
            }
            entryOpt.get().quest = newQuest;
            if (this.shownIndex.orElse(-2) != this.shown.indexOf(entryOpt.get())) continue;
            this.refreshQuestsLines(true);
        }
    }

    protected void worldChange(boolean toAllowed) {
        if (this.hid) {
            if (toAllowed) {
                this.show(false);
            }
        } else if (!toAllowed) {
            this.hide(false);
        }
    }

    public boolean isHidden() {
        return this.hid;
    }

    public boolean isForceHidden() {
        return this.hidForce;
    }

    public void hide(boolean force) {
        this.hid = true;
        if (force) {
            this.hidForce = true;
        }
        if (this.board != null) {
            this.deleteBoard();
        }
    }

    public void show(boolean force) {
        if (this.hidForce && !force) {
            return;
        }
        this.hid = false;
        this.hidForce = false;
        if (!(this.board != null || this.shown.isEmpty() && this.manager.hideEmptyScoreboard())) {
            this.initScoreboard();
            this.updateBoard(true, false);
        }
    }

    private void deleteBoard() {
        this.board.delete();
        this.board = null;
        for (Line line : this.lines) {
            line.reset();
        }
    }

    public void setShownQuest(@NotNull Quest quest, @NotNull Quester quester, boolean errorWhenUnknown) {
        if (!quest.isScoreboardEnabled()) {
            return;
        }
        Optional<QuestEntry> entryOpt = this.getEntry(quest, quester);
        if (entryOpt.isEmpty()) {
            if (errorWhenUnknown) {
                throw new IllegalArgumentException("Quest is not running for player.");
            }
        } else if (!this.hasPinnedEntry() || entryOpt.get().isPinned()) {
            this.shownIndex = OptionalInt.of(this.shown.indexOf(entryOpt.get()));
            this.resetChangeTime();
            this.resetAutoHideTime();
            this.refreshQuestsLines(true);
        }
    }

    protected void resetChangeTime() {
        this.changeTime = this.manager.getQuestChangeTime();
    }

    protected void resetAutoHideTime() {
        if (this.autoHideTime != -1) {
            this.autoHideTime = this.manager.getAutoHideTime();
        }
    }

    public void refreshQuestsLines(boolean updateBoard) {
        if (!this.manager.refreshLines()) {
            return;
        }
        this.lines.stream().filter(line -> line.hasQuestPlaceholders).forEach(line -> {
            line.willRefresh = true;
        });
        if (this.board == null) {
            this.periodicRefresh();
        } else if (updateBoard) {
            this.updateBoard(false, false);
        }
    }

    private void updateBoard(boolean update, boolean time) {
        if (this.board == null && !time) {
            return;
        }
        ArrayList<String> linesStrings = new ArrayList<String>(this.lines.size());
        for (int i = 0; i < this.lines.size(); ++i) {
            Line line = this.lines.get(i);
            try {
                if (line.tryRefresh(time) && !update) {
                    update = true;
                }
                linesStrings.addAll(line.lines);
                if (linesStrings.size() < ChatColor.values().length - 1) continue;
                while (linesStrings.size() >= ChatColor.values().length - 1) {
                    linesStrings.remove(linesStrings.size() - 1);
                }
                break;
            }
            catch (Exception ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().warning("An error occured while refreshing scoreboard line " + i + " for " + this.p.getName(), ex);
                linesStrings.add("\u00a7c\u00a7lline error");
            }
        }
        if (update && this.board != null) {
            this.board.updateLines(linesStrings);
        }
    }

    public void setCustomLine(int id, String value) {
        if (this.lines.size() <= id) {
            Line line = new Line(new ScoreboardLine(value));
            line.createdLine = true;
            this.lines.add(line);
        } else {
            Line line = this.lines.get(id);
            line.setCustomValue(value);
            line.willRefresh = true;
        }
        this.updateBoard(true, false);
    }

    public boolean resetLine(int id) {
        if (this.lines.size() <= id) {
            return false;
        }
        Line line = this.lines.get(id);
        if (line.createdLine) {
            this.lines.remove(id);
        } else {
            line.setCustomValue(null);
            line.willRefresh = true;
        }
        this.updateBoard(true, false);
        return true;
    }

    public boolean removeLine(int id) {
        if (this.lines.size() <= id) {
            return false;
        }
        this.lines.remove(id);
        this.updateBoard(true, false);
        return true;
    }

    public void stop() {
        this.task.cancel();
        HandlerList.unregisterAll((Listener)this);
        if (this.board != null) {
            this.deleteBoard();
        }
    }

    public void initScoreboard() {
        this.board = new FastBoard(this.p);
        this.board.updateTitle(Lang.SCOREBOARD_NAME.toString());
    }

    class Line {
        ScoreboardLine param;
        int timeLeft = 0;
        private String customValue = null;
        boolean createdLine = false;
        boolean willRefresh = false;
        String lastValue = null;
        List<String> lines;
        boolean hasQuestPlaceholders;

        private Line(ScoreboardLine param) {
            this.param = param;
            this.computeHasQuestPlaceholders();
        }

        private boolean tryRefresh(boolean time) {
            if (!this.willRefresh && this.lines != null && this.param.getRefreshTime() == 0) {
                return false;
            }
            if (this.timeLeft == 0 || this.willRefresh) {
                this.willRefresh = false;
                this.timeLeft = this.param.getRefreshTime();
                String text = this.getValue();
                try {
                    if (this.hasQuestPlaceholders) {
                        text = this.formatQuestPlaceholders(text);
                    }
                    if (text == null) {
                        this.lines = Collections.emptyList();
                        if (this.lastValue == null) {
                            return false;
                        }
                    } else {
                        if ((text = MessageUtils.finalFormat(text, null, PlaceholdersContext.of(Scoreboard.this.p, true, null))).equals(this.lastValue)) {
                            return false;
                        }
                        this.lines = ChatColorUtils.wordWrap(text, this.param.getMaxLength() == 0 ? 30 : this.param.getMaxLength(), 1024);
                    }
                }
                catch (Exception ex) {
                    ScoreboardManager.LOGGER.warning("Failed to refresh line {0} for player {1}", ex, text, Scoreboard.this.p.getName());
                    this.lines = List.of("\u00a7cerror");
                }
                this.lastValue = text;
                return true;
            }
            if (time) {
                --this.timeLeft;
            }
            return false;
        }

        private void reset() {
            this.timeLeft = 0;
            this.lines = null;
            this.lastValue = null;
        }

        public String getValue() {
            return this.customValue == null ? this.param.getValue() : this.customValue;
        }

        public void setCustomValue(String value) {
            this.customValue = value;
            this.computeHasQuestPlaceholders();
        }

        private void computeHasQuestPlaceholders() {
            this.hasQuestPlaceholders = QUEST_PLACEHOLDER.matcher(this.getValue()).find();
        }

        private String formatQuestPlaceholders(String text) {
            Optional<QuestEntry> shownOpt = Scoreboard.this.getShown();
            StringBuffer textBuffer = new StringBuffer();
            Matcher matcher = QUEST_PLACEHOLDER.matcher(text);
            QuestDescriptionContext lazyContext = null;
            while (matcher.find()) {
                String replacement;
                String descriptionId = matcher.group(1);
                if (descriptionId.equals("name")) {
                    replacement = shownOpt.map(entry -> entry.quest.getName()).orElse(Lang.SCOREBOARD_NONE_NAME.toString());
                } else if (shownOpt.isEmpty()) {
                    replacement = descriptionId.equals("advancement") ? Lang.SCOREBOARD_NONE_DESC.toString() : Lang.SCOREBOARD_NONE.toString();
                } else {
                    Optional<QuestDescriptionProvider> optionalDescription = shownOpt.get().quest.getDescriptions().stream().filter(description -> description.getDescriptionId().equals(descriptionId)).findFirst();
                    if (optionalDescription.isPresent()) {
                        List<String> descriptionStrings;
                        if (lazyContext == null) {
                            lazyContext = new QuestDescriptionContext(QuestsConfiguration.getConfig().getQuestDescriptionConfig(), shownOpt.get().quest, Scoreboard.this.p, shownOpt.get().quester, PlayerListCategory.IN_PROGRESS, DescriptionSource.SCOREBOARD);
                        }
                        replacement = (descriptionStrings = optionalDescription.get().provideDescription(lazyContext)) == null ? "" : String.join((CharSequence)"\n", descriptionStrings);
                    } else {
                        if (Scoreboard.this.manager.hideUnknownQuestPlaceholders()) {
                            return null;
                        }
                        replacement = descriptionId;
                    }
                }
                matcher.appendReplacement(textBuffer, Matcher.quoteReplacement(replacement));
            }
            matcher.appendTail(textBuffer);
            return textBuffer.toString();
        }
    }

    public class QuestEntry {
        @NotNull
        private final Quester quester;
        @NotNull
        private Quest quest;
        private boolean pinned = false;

        private QuestEntry(@NotNull Quest quest, Quester quester) {
            this.quest = quest;
            this.quester = quester;
        }

        public void setPinned(boolean pinned) {
            if (pinned) {
                if (!Scoreboard.this.hasPinnedEntry()) {
                    Scoreboard.this.shown.clear();
                }
                Scoreboard.this.shown.add(this);
                Scoreboard.this.shownIndex = OptionalInt.of(Scoreboard.this.shown.indexOf(this));
                Scoreboard.this.resetChangeTime();
                Scoreboard.this.refreshQuestsLines(true);
                this.pinned = true;
            } else {
                this.pinned = false;
                Scoreboard.this.removeShown(this);
            }
        }

        public boolean isPinned() {
            return this.pinned;
        }

        public boolean applies(Quest quest, Quester quester) {
            return this.quest.equals(quest) && this.quester.equals(quester);
        }
    }
}

