/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.scoreboards;

import fr.skytasul.quests.api.utils.ChatColorUtils;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import org.apache.commons.lang.Validate;

public class ScoreboardLine {
    private String value;
    private int refresh = 0;
    private int length = 0;

    public ScoreboardLine(String value) {
        Validate.notNull((Object)value);
        this.value = ChatColor.translateAlternateColorCodes((char)'&', (String)ChatColorUtils.translateHexColorCodes(value.replace("{questName}", "{quest_name}").replace("{questDescription}", "{quest_advancement}")));
    }

    public String getValue() {
        return this.value;
    }

    public int getRefreshTime() {
        return this.refresh;
    }

    public int getMaxLength() {
        return this.length;
    }

    public static ScoreboardLine deserialize(Map<String, Object> map) {
        ScoreboardLine line = new ScoreboardLine((String)map.get("value"));
        if (map.containsKey("refresh")) {
            line.refresh = (Integer)map.get("refresh");
        }
        if (map.containsKey("length")) {
            line.length = (Integer)map.get("length");
        }
        return line;
    }
}

