/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.scoreboards;

import fr.mrmicky.fastboard.FastBoard;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsHandler;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.events.QuesterJoinEvent;
import fr.skytasul.quests.api.questers.events.QuesterLeaveEvent;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import fr.skytasul.quests.scoreboards.Scoreboard;
import fr.skytasul.quests.scoreboards.ScoreboardLine;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ScoreboardManager
implements Listener,
QuestsHandler {
    static final LoggerExpanded LOGGER = LoggerExpanded.get("BeautyQuests.ScoreboardManager");
    @NotNull
    private final BeautyQuests plugin;
    @NotNull
    private final File configFile;
    private Map<Player, Scoreboard> scoreboards;
    private Map<UUID, Boolean> forceHiddenState;
    private final List<ScoreboardLine> lines = new ArrayList<ScoreboardLine>();
    private int changeTime;
    private boolean hide;
    private boolean refreshLines;
    private boolean hideUnknownQuestPlaceholders;
    private int autoHide;
    private List<String> worldsFilter;
    private boolean isWorldAllowList;

    public ScoreboardManager(@NotNull BeautyQuests plugin, @NotNull File configFile) {
        this.plugin = plugin;
        this.configFile = configFile;
    }

    public List<ScoreboardLine> getScoreboardLines() {
        return this.lines;
    }

    public int getQuestChangeTime() {
        return this.changeTime;
    }

    public boolean hideEmptyScoreboard() {
        return this.hide;
    }

    public boolean refreshLines() {
        return this.refreshLines;
    }

    public boolean hideUnknownQuestPlaceholders() {
        return this.hideUnknownQuestPlaceholders;
    }

    public List<String> getWorldsFilter() {
        return this.worldsFilter;
    }

    public boolean isWorldAllowList() {
        return this.isWorldAllowList;
    }

    public boolean isWorldAllowed(String worldName) {
        return this.isWorldAllowList() ? this.getWorldsFilter().contains(worldName) : !this.getWorldsFilter().contains(worldName);
    }

    public int getAutoHideTime() {
        return this.autoHide;
    }

    public Scoreboard getPlayerScoreboard(Player p) {
        return this.scoreboards.get(p);
    }

    public void removePlayerScoreboard(Player p) {
        Scoreboard scoreboard = this.scoreboards.remove(p);
        if (scoreboard != null) {
            scoreboard.stop();
            this.forceHiddenState.put(p.getUniqueId(), scoreboard.isForceHidden());
        }
    }

    public void create(Player p) {
        if (!QuestsConfiguration.getConfig().getQuestsConfig().scoreboards()) {
            return;
        }
        this.removePlayerScoreboard(p);
        Scoreboard scoreboard = new Scoreboard(p, this, this.plugin.getQuesterManager(), this.plugin.getQuestsManager());
        this.scoreboards.put(p, scoreboard);
        Boolean forceHidden = this.forceHiddenState.remove(p.getUniqueId());
        if (forceHidden != null && forceHidden.booleanValue()) {
            scoreboard.hide(true);
        }
    }

    @Override
    public void load() {
        if (!QuestsConfiguration.getConfig().getQuestsConfig().scoreboards()) {
            return;
        }
        if (this.plugin.isUnitTesting()) {
            return;
        }
        try {
            new FastBoard(null);
        }
        catch (ExceptionInInitializerError ex) {
            throw new IllegalStateException("The Scoreboard util cannot load, probably due to an incompatible server version.", ex);
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        ConfigurationSection questsSection = config.getConfigurationSection("quests");
        this.changeTime = questsSection.getInt("changeTime", 11);
        this.hide = questsSection.getBoolean("hideIfEmpty", true);
        this.refreshLines = questsSection.getBoolean("refreshLines", true);
        this.hideUnknownQuestPlaceholders = questsSection.getBoolean("hide unknown quest placeholders");
        this.autoHide = config.getInt("auto hide", -1);
        this.worldsFilter = config.getStringList("worlds.filterList");
        this.isWorldAllowList = config.getBoolean("worlds.isAllowList");
        this.lines.clear();
        for (Map map : config.getMapList("lines")) {
            if (this.lines.size() == 15) {
                LOGGER.warning("Limit of 15 scoreboard lines reached - please delete some in scoreboard.yml");
                break;
            }
            try {
                this.lines.add(ScoreboardLine.deserialize(map));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        LOGGER.debug("Registered {0} lines in scoreboard", this.lines.size());
        this.scoreboards = new HashMap<Player, Scoreboard>();
        this.forceHiddenState = new HashMap<UUID, Boolean>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void unload() {
        if (this.scoreboards == null) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
        for (Scoreboard s : this.scoreboards.values()) {
            s.stop();
        }
        if (!this.scoreboards.isEmpty()) {
            LOGGER.debug("{0} scoreboards deleted.", this.scoreboards.size());
        }
        this.scoreboards.clear();
        this.scoreboards = null;
        this.forceHiddenState.clear();
        this.forceHiddenState = null;
    }

    @EventHandler
    public void onAccountJoin(QuesterJoinEvent e) {
        this.create(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onAccountLeave(QuesterLeaveEvent e) {
        this.removePlayerScoreboard(e.getPlayer());
    }

    @EventHandler
    public void onChangeWorld(PlayerChangedWorldEvent e) {
        Scoreboard scoreboard = this.getPlayerScoreboard(e.getPlayer());
        if (scoreboard == null) {
            return;
        }
        scoreboard.worldChange(this.isWorldAllowed(e.getPlayer().getWorld().getName()));
    }

    @Override
    public void questEdit(Quest newQuest, Quest oldQuest, boolean keepDatas) {
        this.scoreboards.forEach((p, scoreboard) -> {
            if (keepDatas) {
                scoreboard.questEdited(newQuest, oldQuest);
            } else {
                scoreboard.questRemove(oldQuest);
            }
        });
    }

    @Override
    public void questRemove(Quest quest) {
        if (!quest.isScoreboardEnabled()) {
            return;
        }
        this.scoreboards.forEach((p, scoreboard) -> scoreboard.questRemove(quest));
    }

    @Override
    public void questFinish(Quester quester, Quest quest) {
        if (!quest.isScoreboardEnabled()) {
            return;
        }
        this.questEvent(quester, x -> x.questRemove(quest, quester));
    }

    @Override
    public void questReset(Quester quester, Quest quest) {
        if (!quest.isScoreboardEnabled()) {
            return;
        }
        this.questEvent(quester, x -> x.questRemove(quest, quester));
    }

    @Override
    public void questUpdated(Quester quester, Quest quest) {
        if (!quest.isScoreboardEnabled()) {
            return;
        }
        this.questEvent(quester, x -> x.setShownQuest(quest, quester, true));
    }

    @Override
    public void questStart(Quester quester, Quest quest) {
        if (!quest.isScoreboardEnabled()) {
            return;
        }
        this.questEvent(quester, x -> x.questAdd(quest, quester));
    }

    private void questEvent(Quester quester, Consumer<Scoreboard> consumer) {
        for (Player player : quester.getOnlinePlayers()) {
            Scoreboard scoreboard = this.scoreboards.get(player);
            if (scoreboard == null) continue;
            consumer.accept(scoreboard);
        }
    }
}

