/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.comparison.ItemComparisonMap;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.dialogs.Dialog;
import fr.skytasul.quests.api.npcs.dialogs.DialogRunner;
import fr.skytasul.quests.api.npcs.dialogs.Message;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.progress.ProgressPlaceholders;
import fr.skytasul.quests.api.utils.progress.itemdescription.HasItemsDescriptionConfiguration;
import fr.skytasul.quests.gui.items.ItemComparisonGUI;
import fr.skytasul.quests.gui.items.ItemsGUI;
import fr.skytasul.quests.stages.StageNPC;
import fr.skytasul.quests.utils.types.DialogRunnerImplementation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StageBringBack
extends StageNPC {
    protected final ItemStack[] items;
    protected final String customMessage;
    protected final ItemComparisonMap comparisons;
    protected final Map<ItemStack, Integer> amountsMap = new HashMap<ItemStack, Integer>();
    protected String[] itemsDescriptions;

    public StageBringBack(StageController controller, ItemStack[] items, String customMessage, ItemComparisonMap comparisons) {
        super(controller);
        this.customMessage = customMessage;
        this.comparisons = comparisons;
        this.items = items;
        for (ItemStack item : items) {
            int amount = item.getAmount();
            item = item.clone();
            item.setAmount(1);
            this.amountsMap.put(item, amount += this.amountsMap.getOrDefault(item, 0).intValue());
        }
    }

    public boolean checkItems(Player p, boolean msg) {
        boolean done = true;
        for (Map.Entry<ItemStack, Integer> en : this.amountsMap.entrySet()) {
            if (this.comparisons.containsItems((Inventory)p.getInventory(), en.getKey(), en.getValue())) continue;
            done = false;
            break;
        }
        if (done) {
            return true;
        }
        if (msg) {
            this.sendNeedMessage(p);
        }
        return false;
    }

    public void sendNeedMessage(Player p) {
        String text = this.getMessage();
        if ("none".equals(text)) {
            return;
        }
        Message msg = new Message(MessageUtils.format(text, this.getPlaceholdersRegistry(), StageDescriptionPlaceholdersContext.of(true, PlayerManager.getPlayerAccount(p), DescriptionSource.FORCELINE, null)), Message.Sender.NPC);
        Dialog fakeDialog = new Dialog(Arrays.asList(msg));
        DialogRunnerImplementation fakeDialogRunner = new DialogRunnerImplementation(fakeDialog, this.getNPC());
        fakeDialogRunner.handleNext(p, DialogRunner.DialogNextReason.PLUGIN);
    }

    public void removeItems(Player p) {
        for (ItemStack is : this.items) {
            this.comparisons.removeItems((Inventory)p.getInventory(), is);
        }
        p.updateInventory();
    }

    public ItemStack[] getItems() {
        return this.items;
    }

    protected String getMessage() {
        return this.customMessage == null ? Lang.NEED_OBJECTS.toString() : this.customMessage;
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_ITEMS.toString();
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexedContextual("items", StageDescriptionPlaceholdersContext.class, context -> {
            if (this.itemsDescriptions == null) {
                this.itemsDescriptions = (String[])this.amountsMap.entrySet().stream().map(item -> ProgressPlaceholders.formatObject(new HasItemsDescriptionConfiguration.HasSingleObject(){
                    final /* synthetic */ Map.Entry val$item;
                    {
                        this.val$item = entry;
                    }

                    @Override
                    public long getRemainingAmount(@NotNull Quester quester) {
                        return ((Integer)this.val$item.getValue()).intValue();
                    }

                    @Override
                    @NotNull
                    public String getObjectName() {
                        return ItemUtils.getName((ItemStack)this.val$item.getKey(), true);
                    }

                    @Override
                    public long getObjectAmount() {
                        return ((Integer)this.val$item.getValue()).intValue();
                    }
                }, context)).toArray(String[]::new);
            }
            return ProgressPlaceholders.formatObjectList(context.getDescriptionSource(), QuestsConfiguration.getConfig().getStageDescriptionConfig(), this.itemsDescriptions);
        });
    }

    @Override
    public void started(Quester acc) {
        super.started(acc);
        if (this.sendStartMessage()) {
            acc.getOnlinePlayers().forEach(this::sendNeedMessage);
        }
    }

    @Override
    protected void initDialogRunner() {
        super.initDialogRunner();
        this.getNPC().addStartablePredicate(p -> this.matchesRequirements((Player)p, false) && this.checkItems((Player)p, false), this);
        this.dialogRunner.addTest(p -> !this.getNPC().canGiveSomething((Player)p) || this.matchesRequirements((Player)p, true) && this.checkItems((Player)p, false));
        this.dialogRunner.addTestCancelling(p -> this.checkItems((Player)p, true));
        this.dialogRunner.addEndAction(this::removeItems);
    }

    @Override
    public void unload() {
        super.unload();
        if (this.getNPC() != null) {
            this.getNPC().removeStartablePredicate(this);
        }
    }

    @Override
    public void serialize(ConfigurationSection section) {
        super.serialize(section);
        section.set("items", (Object)this.items);
        if (this.customMessage != null) {
            section.set("customMessage", (Object)this.customMessage);
        }
        if (!this.comparisons.getNotDefault().isEmpty()) {
            section.createSection("itemComparisons", this.comparisons.getNotDefault());
        }
    }

    public static StageBringBack deserialize(ConfigurationSection section, StageController controller) {
        ItemStack[] items = section.getList("items").toArray(new ItemStack[0]);
        String customMessage = section.getString("customMessage", null);
        ItemComparisonMap comparisons = section.contains("itemComparisons") ? new ItemComparisonMap(section.getConfigurationSection("itemComparisons")) : new ItemComparisonMap();
        StageBringBack st = new StageBringBack(controller, items, customMessage, comparisons);
        st.loadDatas(section);
        return st;
    }

    public static class Creator
    extends AbstractCreator<StageBringBack> {
        public Creator(@NotNull StageCreationContext<StageBringBack> context) {
            super(context);
        }

        @Override
        protected StageBringBack createStage(StageController controller) {
            return new StageBringBack(controller, this.items.toArray(new ItemStack[0]), this.message, this.comparisons);
        }
    }

    public static abstract class AbstractCreator<T extends StageBringBack>
    extends StageNPC.AbstractCreator<T> {
        private static final ItemStack stageItems = ItemUtils.item(XMaterial.CHEST, Lang.stageItems.toString(), new String[0]);
        private static final ItemStack stageMessage = ItemUtils.item(XMaterial.PAPER, Lang.stageItemsMessage.toString(), new String[0]);
        private static final ItemStack stageComparison = ItemUtils.item(XMaterial.PRISMARINE_SHARD, Lang.stageItemsComparison.toString(), new String[0]);
        protected List<ItemStack> items;
        protected String message = null;
        protected ItemComparisonMap comparisons = new ItemComparisonMap();

        protected AbstractCreator(@NotNull StageCreationContext<T> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(5, stageItems, event -> new ItemsGUI(items -> {
                this.setItems((List<ItemStack>)items);
                event.reopen();
            }, this.items).open(event.getPlayer()));
            line.setItem(9, stageMessage, event -> new TextEditor<String>(event.getPlayer(), event::reopen, x -> {
                this.setMessage((String)x);
                event.reopen();
            }).passNullIntoEndConsumer().start());
            line.setItem(10, stageComparison, event -> new ItemComparisonGUI(this.comparisons, () -> {
                this.setComparisons(this.comparisons);
                event.reopen();
            }).open(event.getPlayer()));
        }

        public void setItems(List<ItemStack> items) {
            this.items = items;
            this.getLine().refreshItemLore(5, QuestOption.formatNullableValue(Lang.AmountItems.quickFormat("items_amount", this.items.size())));
        }

        public void setMessage(String message) {
            this.message = message;
            this.getLine().refreshItemLore(9, QuestOption.formatNullableValue((Object)message, Lang.NEED_OBJECTS));
        }

        public void setComparisons(ItemComparisonMap comparisons) {
            this.comparisons = comparisons;
            this.getLine().refreshItemLore(10, QuestOption.formatNullableValue((Object)Lang.AmountComparisons.quickFormat("comparisons_amount", this.comparisons.getEffective().size()), comparisons.isDefault()));
        }

        @Override
        public void start(Player p) {
            new ItemsGUI(items -> {
                this.setItems((List<ItemStack>)items);
                super.start(p);
            }, Collections.emptyList()).open(p);
        }

        @Override
        public void edit(T stage) {
            super.edit(stage);
            this.setItems(Arrays.asList(((StageBringBack)stage).items));
            this.setMessage(((StageBringBack)stage).customMessage);
            this.setComparisons(((StageBringBack)stage).comparisons.clone());
        }
    }
}

