/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.progress.ProgressPlaceholders;
import fr.skytasul.quests.api.utils.progress.itemdescription.HasItemsDescriptionConfiguration;
import fr.skytasul.quests.api.utils.progress.itemdescription.ItemsDescriptionConfiguration;
import fr.skytasul.quests.gui.misc.BucketTypeGUI;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StageBucket
extends AbstractStage
implements HasItemsDescriptionConfiguration.HasSingleObject,
Listener {
    private BucketType bucket;
    private int amount;

    public StageBucket(StageController controller, BucketType bucket, int amount) {
        super(controller);
        this.bucket = bucket;
        this.amount = amount;
    }

    public BucketType getBucketType() {
        return this.bucket;
    }

    @Override
    @NotNull
    public String getObjectName() {
        return this.bucket.getName();
    }

    public int getBucketAmount() {
        return this.amount;
    }

    @Override
    public long getObjectAmount() {
        return this.amount;
    }

    @Override
    @NotNull
    public ItemsDescriptionConfiguration getItemsDescriptionConfiguration() {
        return QuestsConfiguration.getConfig().getStageDescriptionConfig();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBucketFill(PlayerBucketFillEvent e) {
        Player p = e.getPlayer();
        if (BucketType.fromMaterial(XMaterial.matchXMaterial((ItemStack)e.getItemStack())) == this.bucket && this.matchesRequirements(p)) {
            for (Quester quester : this.controller.getApplicableQuesters(p)) {
                long amount = this.getRemainingAmount(quester);
                if (amount <= 1L) {
                    this.finishStage(quester);
                    continue;
                }
                this.updateObjective(quester, "amount", --amount);
            }
        }
    }

    @Override
    public long getRemainingAmount(Quester acc) {
        return this.getData(acc, "amount", Long.class);
    }

    @Override
    public void initPlayerDatas(Quester acc, Map<String, Object> datas) {
        datas.put("amount", this.amount);
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.register("bucket_type", this.bucket.getName());
        ProgressPlaceholders.registerObject(placeholders, "buckets", this);
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_BUCKET.toString();
    }

    @Override
    protected void serialize(ConfigurationSection section) {
        section.set("bucket", (Object)this.bucket.name());
        section.set("amount", (Object)this.amount);
    }

    public static StageBucket deserialize(ConfigurationSection section, StageController controller) {
        return new StageBucket(controller, BucketType.valueOf(section.getString("bucket")), section.getInt("amount"));
    }

    public static enum BucketType {
        WATER(Lang.BucketWater, XMaterial.WATER_BUCKET),
        LAVA(Lang.BucketLava, XMaterial.LAVA_BUCKET),
        MILK(Lang.BucketMilk, XMaterial.MILK_BUCKET),
        SNOW(Lang.BucketSnow, XMaterial.POWDER_SNOW_BUCKET);

        private Lang name;
        private XMaterial type;

        private BucketType(Lang name, XMaterial type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name.toString();
        }

        public XMaterial getMaterial() {
            return this.type;
        }

        public static BucketType fromMaterial(XMaterial type) {
            for (BucketType bucket : BucketType.values()) {
                if (bucket.type != type) continue;
                return bucket;
            }
            throw new IllegalArgumentException(type.name() + " does not correspond to any bucket type");
        }

        public static BucketType[] getAvailable() {
            return BucketType.values();
        }
    }

    public static class Creator
    extends StageCreation<StageBucket> {
        private BucketType bucket;
        private int amount;

        public Creator(@NotNull StageCreationContext<StageBucket> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(6, ItemUtils.item(XMaterial.REDSTONE, Lang.editBucketAmount.toString(), new String[0]), event -> {
                Lang.BUCKET_AMOUNT.send((CommandSender)event.getPlayer());
                new TextEditor<Integer>(event.getPlayer(), event::reopen, obj -> {
                    this.setAmount((int)obj);
                    event.reopen();
                }, NumberParser.INTEGER_PARSER_STRICT_POSITIVE).start();
            });
            line.setItem(7, ItemUtils.item(XMaterial.BUCKET, Lang.editBucketType.toString(), new String[0]), event -> new BucketTypeGUI(event::reopen, bucket -> {
                this.setBucket((BucketType)((Object)((Object)bucket)));
                event.reopen();
            }).open(event.getPlayer()));
        }

        public void setBucket(BucketType bucket) {
            this.bucket = bucket;
            ItemStack newItem = ItemUtils.lore(this.getLine().getItem(7), QuestOption.formatNullableValue(bucket.getName()));
            newItem.setType(bucket.type.parseMaterial());
            this.getLine().refreshItem(7, newItem);
        }

        public void setAmount(int amount) {
            this.amount = amount;
            this.getLine().refreshItemLore(6, Lang.Amount.quickFormat("amount", amount));
        }

        @Override
        public void start(Player p) {
            super.start(p);
            new BucketTypeGUI(this.context::removeAndReopenGui, bucket -> {
                this.setBucket((BucketType)((Object)bucket));
                Lang.BUCKET_AMOUNT.send((CommandSender)p);
                new TextEditor<Integer>(p, this.context::removeAndReopenGui, obj -> {
                    this.setAmount((int)obj);
                    this.context.reopenGui();
                }, NumberParser.INTEGER_PARSER_STRICT_POSITIVE).start();
            }).open(p);
        }

        @Override
        public void edit(StageBucket stage) {
            super.edit(stage);
            this.setBucket(stage.getBucketType());
            this.setAmount(stage.getBucketAmount());
        }

        @Override
        public StageBucket finishStage(StageController controller) {
            return new StageBucket(controller, this.bucket, this.amount);
        }
    }
}

