/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import org.apache.commons.lang.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.jetbrains.annotations.NotNull;

public class StageChat
extends AbstractStage
implements Listener {
    private final String text;
    private final boolean cancel;
    private final boolean ignoreCase;
    private final boolean placeholders;
    private final boolean command;

    public StageChat(StageController controller, String text, boolean cancel, boolean ignoreCase, boolean placeholders) {
        super(controller);
        Validate.notNull((Object)text, (String)"Text cannot be null");
        this.text = text;
        this.command = text.startsWith("/");
        this.cancel = cancel;
        this.ignoreCase = ignoreCase;
        this.placeholders = placeholders;
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexed("text", this.text);
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_CHAT.toString();
    }

    public String getText() {
        return this.text;
    }

    public boolean isEventCancelled() {
        return this.cancel;
    }

    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    @EventHandler
    public void onTchat(AsyncPlayerChatEvent e) {
        if (this.command) {
            return;
        }
        if (this.check(e.getMessage(), e.getPlayer()) && this.cancel) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent e) {
        if (!this.command) {
            return;
        }
        if (this.check(e.getMessage(), e.getPlayer()) && this.cancel) {
            e.setCancelled(true);
        }
    }

    private boolean check(String message, Player p) {
        if (this.placeholders) {
            message = MessageUtils.finalFormat(message, null, PlaceholdersContext.of(p, true, null));
        }
        if (!(!this.ignoreCase ? message.equals(this.text) : message.equalsIgnoreCase(this.text))) {
            return false;
        }
        if (!this.matchesRequirements(p)) {
            return false;
        }
        boolean hasQuester = false;
        for (Quester quester : this.controller.getApplicableQuesters(p)) {
            hasQuester = true;
            this.finishStage(quester);
        }
        return hasQuester;
    }

    @Override
    public void serialize(ConfigurationSection section) {
        Validate.notNull((Object)this.text, (String)"Text cannot be null");
        section.set("writeText", (Object)this.text);
        if (!this.cancel) {
            section.set("cancel", (Object)false);
        }
        if (this.ignoreCase) {
            section.set("ignoreCase", (Object)true);
        }
        if (!this.placeholders) {
            section.set("placeholders", (Object)false);
        }
    }

    public static StageChat deserialize(ConfigurationSection section, StageController controller) {
        return new StageChat(controller, section.getString("writeText"), section.getBoolean("cancel", true), section.getBoolean("ignoreCase", false), section.getBoolean("placeholders", true));
    }

    public static class Creator
    extends StageCreation<StageChat> {
        private static final int PLACEHOLDERS_SLOT = 5;
        private static final int IGNORE_CASE_SLOT = 6;
        private static final int CANCEL_EVENT_SLOT = 7;
        private static final int MESSAGE_SLOT = 8;
        private String text;
        private boolean placeholders = true;
        private boolean cancel = true;
        private boolean ignoreCase = false;

        public Creator(@NotNull StageCreationContext<StageChat> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(5, ItemUtils.itemSwitch(Lang.placeholders.toString(), this.placeholders, new String[0]), event -> this.setPlaceholders(!this.placeholders));
            line.setItem(6, ItemUtils.itemSwitch(Lang.ignoreCase.toString(), this.ignoreCase, new String[0]), event -> this.setIgnoreCase(!this.ignoreCase));
            line.setItem(7, ItemUtils.itemSwitch(Lang.cancelEvent.toString(), this.cancel, new String[0]), event -> this.setCancel(!this.cancel));
            line.setItem(8, ItemUtils.item(XMaterial.PLAYER_HEAD, Lang.editMessage.toString(), new String[0]), event -> this.launchEditor(event.getPlayer()));
        }

        public void setText(String text) {
            this.text = text;
            this.getLine().refreshItem(8, item -> ItemUtils.lore(item, QuestOption.formatNullableValue(text)));
        }

        public void setPlaceholders(boolean placeholders) {
            if (this.placeholders != placeholders) {
                this.placeholders = placeholders;
                this.getLine().refreshItem(5, item -> ItemUtils.setSwitch(item, placeholders));
            }
        }

        public void setIgnoreCase(boolean ignoreCase) {
            if (this.ignoreCase != ignoreCase) {
                this.ignoreCase = ignoreCase;
                this.getLine().refreshItem(6, item -> ItemUtils.setSwitch(item, ignoreCase));
            }
        }

        public void setCancel(boolean cancel) {
            if (this.cancel != cancel) {
                this.cancel = cancel;
                this.getLine().refreshItem(7, item -> ItemUtils.setSwitch(item, cancel));
            }
        }

        @Override
        public void start(Player p) {
            super.start(p);
            this.launchEditor(p);
        }

        @Override
        public void edit(StageChat stage) {
            super.edit(stage);
            this.setText(stage.text);
            this.setIgnoreCase(stage.ignoreCase);
            this.setCancel(stage.cancel);
            this.setPlaceholders(stage.placeholders);
        }

        @Override
        public StageChat finishStage(StageController controller) {
            return new StageChat(controller, this.text, this.cancel, this.ignoreCase, this.placeholders);
        }

        private void launchEditor(Player p) {
            Lang.CHAT_MESSAGE.send((CommandSender)p);
            new TextEditor<String>(p, () -> {
                if (this.text == null) {
                    this.context.remove();
                }
                this.context.reopenGui();
            }, obj -> {
                obj = obj.replace("{SLASH}", "/");
                this.setText((String)obj);
                this.context.reopenGui();
            }).start();
        }
    }
}

