/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.comparison.ItemComparisonMap;
import fr.skytasul.quests.api.events.internal.BQCraftEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.progress.ProgressPlaceholders;
import fr.skytasul.quests.api.utils.progress.itemdescription.HasItemsDescriptionConfiguration;
import fr.skytasul.quests.gui.items.ItemComparisonGUI;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StageCraft
extends AbstractStage
implements HasItemsDescriptionConfiguration.HasSingleObject,
Listener {
    private final ItemStack result;
    private final ItemComparisonMap comparisons;

    public StageCraft(StageController controller, ItemStack result, ItemComparisonMap comparisons) {
        super(controller);
        this.result = result;
        this.comparisons = comparisons;
        if (result.getAmount() == 0) {
            result.setAmount(1);
        }
    }

    public ItemStack getItem() {
        return this.result;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFurnaceExtract(FurnaceExtractEvent event) {
        Player p = event.getPlayer();
        if (this.comparisons.isSimilar(this.result, new ItemStack(event.getItemType())) && this.hasApplicableQuester(p) && this.matchesRequirements(p, true)) {
            for (Quester quester : this.controller.getApplicableQuesters(p)) {
                long amount = this.getRemainingAmount(quester) - (long)event.getItemAmount();
                if (amount <= 0L) {
                    this.finishStage(quester);
                    continue;
                }
                this.updateObjective(quester, "amount", amount);
            }
        }
    }

    @EventHandler
    public void onCraft(BQCraftEvent event) {
        ItemStack item;
        Player p = event.getPlayer();
        if (this.hasApplicableQuester(p) && this.matchesRequirements(p) && this.comparisons.isSimilar(this.result, item = event.getResult())) {
            int recipeAmount = item.getAmount();
            switch (event.getClickEvent().getClick()) {
                case NUMBER_KEY: {
                    if (p.getInventory().getItem(event.getClickEvent().getHotbarButton()) == null) break;
                    recipeAmount = 0;
                    break;
                }
                case DROP: 
                case CONTROL_DROP: {
                    ItemStack cursor = event.getClickEvent().getCursor();
                    if (cursor == null || cursor.getType() == Material.AIR) break;
                    recipeAmount = 0;
                    break;
                }
                case SHIFT_RIGHT: 
                case SHIFT_LEFT: {
                    if (recipeAmount == 0) break;
                    int capacity = StageCraft.fits(item, (Inventory)p.getInventory());
                    if (capacity < event.getMaxCraftable()) {
                        recipeAmount = (capacity + recipeAmount - 1) / recipeAmount * recipeAmount;
                        break;
                    }
                    recipeAmount = event.getMaxCraftable();
                    break;
                }
                default: {
                    ItemStack cursor = event.getClickEvent().getCursor();
                    if (cursor == null || cursor.getType() == Material.AIR) break;
                    if (cursor.isSimilar(item)) {
                        if (cursor.getAmount() + item.getAmount() <= cursor.getMaxStackSize()) break;
                        recipeAmount = 0;
                        break;
                    }
                    recipeAmount = 0;
                }
            }
            if (recipeAmount == 0) {
                return;
            }
            for (Quester quester : this.controller.getApplicableQuesters(p)) {
                long amount = this.getRemainingAmount(quester) - (long)recipeAmount;
                if (amount <= 0L) {
                    this.finishStage(quester);
                    continue;
                }
                this.updateObjective(quester, "amount", amount);
            }
        }
    }

    @Override
    public void initPlayerDatas(Quester acc, Map<String, Object> datas) {
        super.initPlayerDatas(acc, datas);
        datas.put("amount", this.result.getAmount());
    }

    @Override
    public long getRemainingAmount(Quester acc) {
        Long amount = this.getData(acc, "amount", Long.class);
        return amount == null ? 0L : amount;
    }

    @Override
    @NotNull
    public String getObjectName() {
        return ItemUtils.getName(this.result, true);
    }

    @Override
    public long getObjectAmount() {
        return this.result.getAmount();
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        ProgressPlaceholders.registerObject(placeholders, "items", this);
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_CRAFT.toString();
    }

    @Override
    protected void serialize(ConfigurationSection section) {
        section.set("result", (Object)this.result.serialize());
        if (!this.comparisons.getNotDefault().isEmpty()) {
            section.createSection("itemComparisons", this.comparisons.getNotDefault());
        }
    }

    public static StageCraft deserialize(ConfigurationSection section, StageController controller) {
        return new StageCraft(controller, ItemStack.deserialize((Map)section.getConfigurationSection("result").getValues(false)), section.contains("itemComparisons") ? new ItemComparisonMap(section.getConfigurationSection("itemComparisons")) : new ItemComparisonMap());
    }

    public static int fits(ItemStack stack, Inventory inv) {
        int result = 0;
        for (ItemStack is : inv.getContents()) {
            if (is == null) {
                result += stack.getMaxStackSize();
                continue;
            }
            if (!is.isSimilar(stack)) continue;
            result += Math.max(stack.getMaxStackSize() - is.getAmount(), 0);
        }
        return result;
    }

    public static class Creator
    extends StageCreation<StageCraft> {
        private static final int ITEM_SLOT = 6;
        private static final int COMPARISONS_SLOT = 7;
        private ItemStack item;
        private ItemComparisonMap comparisons = new ItemComparisonMap();

        public Creator(@NotNull StageCreationContext<StageCraft> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(6, ItemUtils.item(XMaterial.CHEST, Lang.editItem.toString(), new String[0]), event -> QuestsPlugin.getPlugin().getGuiManager().getFactory().createItemSelection(is -> {
                if (is != null) {
                    this.setItem((ItemStack)is);
                }
                event.reopen();
            }, true).open(event.getPlayer()));
            line.setItem(7, ItemUtils.item(XMaterial.PRISMARINE_SHARD, Lang.stageItemsComparison.toString(), new String[0]), event -> new ItemComparisonGUI(this.comparisons, () -> {
                this.setComparisons(this.comparisons);
                event.reopen();
            }).open(event.getPlayer()));
        }

        public void setItem(ItemStack item) {
            this.item = item;
            this.getLine().refreshItem(6, item2 -> ItemUtils.lore(item2, QuestOption.formatNullableValue(Utils.getStringFromItemStack(item, "\u00a78", true))));
        }

        public void setComparisons(ItemComparisonMap comparisons) {
            this.comparisons = comparisons;
            this.getLine().refreshItem(7, item -> ItemUtils.lore(item, QuestOption.formatNullableValue(Lang.AmountComparisons.quickFormat("amount", this.comparisons.getEffective().size()))));
        }

        @Override
        public void start(Player p) {
            super.start(p);
            QuestsPlugin.getPlugin().getGuiManager().getFactory().createItemSelection(is -> {
                this.setItem((ItemStack)is);
                this.context.reopenGui();
            }, this.context::removeAndReopenGui).open(p);
        }

        @Override
        public void edit(StageCraft stage) {
            super.edit(stage);
            this.setItem(stage.getItem());
            this.setComparisons(stage.comparisons.clone());
        }

        @Override
        public StageCraft finishStage(StageController controller) {
            return new StageCraft(controller, this.item, this.comparisons);
        }
    }
}

