/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.gui.misc.DamageCausesGUI;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.jetbrains.annotations.NotNull;

public class StageDeath
extends AbstractStage
implements Listener {
    private List<EntityDamageEvent.DamageCause> causes;

    public StageDeath(StageController controller, List<EntityDamageEvent.DamageCause> causes) {
        super(controller);
        this.causes = causes;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player p = event.getEntity();
        if (!this.causes.isEmpty()) {
            EntityDamageEvent lastDamage = p.getLastDamageCause();
            if (lastDamage == null) {
                return;
            }
            if (!this.causes.contains(lastDamage.getCause())) {
                return;
            }
        }
        if (this.matchesRequirements(p, true)) {
            this.controller.getApplicableQuesters(p).forEach(x$0 -> this.finishStage((Quester)x$0));
        }
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_DIE.toString();
    }

    @Override
    protected void serialize(ConfigurationSection section) {
        if (!this.causes.isEmpty()) {
            section.set("causes", this.causes.stream().map(Enum::name).collect(Collectors.toList()));
        }
    }

    public static StageDeath deserialize(ConfigurationSection section, StageController controller) {
        List<Object> causes = section.contains("causes") ? section.getStringList("causes").stream().map(EntityDamageEvent.DamageCause::valueOf).collect(Collectors.toList()) : Collections.emptyList();
        return new StageDeath(controller, causes);
    }

    public static class Creator
    extends StageCreation<StageDeath> {
        private static final int CAUSES_SLOT = 7;
        private List<EntityDamageEvent.DamageCause> causes;

        public Creator(@NotNull StageCreationContext<StageDeath> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(7, ItemUtils.item(XMaterial.SKELETON_SKULL, Lang.stageDeathCauses.toString(), new String[0]), event -> new DamageCausesGUI(this.causes, newCauses -> {
                this.setCauses((List<EntityDamageEvent.DamageCause>)newCauses);
                event.reopen();
            }).open(event.getPlayer()));
        }

        public void setCauses(List<EntityDamageEvent.DamageCause> causes) {
            this.causes = causes;
            this.getLine().refreshItemLoreOptionValue(7, causes.isEmpty() ? Lang.stageDeathCauseAny : Lang.stageDeathCausesSet.quickFormat("causes_amount", causes.size()));
        }

        @Override
        public void start(Player p) {
            super.start(p);
            this.setCauses(Collections.emptyList());
        }

        @Override
        public void edit(StageDeath stage) {
            super.edit(stage);
            this.setCauses(stage.causes);
        }

        @Override
        protected StageDeath finishStage(StageController controller) {
            return new StageDeath(controller, this.causes);
        }
    }
}

