/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.blocks.BQBlock;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.stages.types.Locatable;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.gui.blocks.SelectBlockGUI;
import java.util.Collections;
import java.util.Objects;
import java.util.Spliterator;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;

@Locatable.LocatableType(types={Locatable.LocatedType.BLOCK})
public class StageInteractBlock
extends AbstractStage
implements Locatable.MultipleLocatable,
Listener {
    private final boolean left;
    @NotNull
    private final BQBlock block;

    public StageInteractBlock(StageController controller, boolean leftClick, BQBlock block) {
        super(controller);
        this.left = leftClick;
        this.block = block;
    }

    public BQBlock getBlockType() {
        return this.block;
    }

    public boolean needLeftClick() {
        return this.left;
    }

    @Override
    public Spliterator<Locatable.Located> getNearbyLocated(Locatable.MultipleLocatable.NearbyFetcher fetcher) {
        if (this.block == null) {
            return null;
        }
        return QuestsAPI.getAPI().getBlocksManager().getNearbyBlocks(fetcher, Collections.singleton(this.block));
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (e.getClickedBlock() == null) {
            return;
        }
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (this.left ? e.getAction() != Action.LEFT_CLICK_BLOCK : e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!this.block.applies(e.getClickedBlock())) {
            return;
        }
        Player p = e.getPlayer();
        if (this.hasApplicableQuester(p) && this.matchesRequirements(p)) {
            e.setCancelled(true);
            this.controller.getApplicableQuesters(p).forEach(x$0 -> this.finishStage((Quester)x$0));
        }
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.compose(this.block);
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_INTERACT_MATERIAL.toString();
    }

    @Override
    protected void serialize(ConfigurationSection section) {
        section.set("leftClick", (Object)this.left);
        section.set("block", (Object)this.block.getAsString());
    }

    public static StageInteractBlock deserialize(ConfigurationSection section, StageController controller) {
        BQBlock block = section.contains("material") ? QuestsAPI.getAPI().getBlocksManager().createSimple(XMaterial.valueOf((String)section.getString("material")), null) : QuestsAPI.getAPI().getBlocksManager().deserialize(section.getString("block"));
        return new StageInteractBlock(controller, section.getBoolean("leftClick"), block);
    }

    public static class Creator
    extends StageCreation<StageInteractBlock> {
        private boolean leftClick = false;
        private BQBlock block;

        public Creator(@NotNull StageCreationContext<StageInteractBlock> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(6, ItemUtils.itemSwitch(Lang.leftClick.toString(), this.leftClick, new String[0]), event -> this.setLeftClick(!this.leftClick));
            line.setItem(7, ItemUtils.item(XMaterial.STICK, Lang.blockMaterial.toString(), new String[0]), event -> new SelectBlockGUI(false, (newBlock, __) -> {
                this.setMaterial((BQBlock)newBlock);
                event.reopen();
            }).open(event.getPlayer()));
        }

        public void setLeftClick(boolean leftClick) {
            if (this.leftClick != leftClick) {
                this.leftClick = leftClick;
                this.getLine().refreshItem(6, item -> ItemUtils.setSwitch(item, leftClick));
            }
        }

        public void setMaterial(@NotNull BQBlock block) {
            this.block = Objects.requireNonNull(block);
            this.getLine().refreshItemLoreOptionValue(7, block.getName());
        }

        @Override
        public void start(Player p) {
            super.start(p);
            new SelectBlockGUI(false, (newBlock, __) -> {
                this.setMaterial((BQBlock)newBlock);
                this.context.reopenGui();
            }).open(p);
        }

        @Override
        public void edit(StageInteractBlock stage) {
            super.edit(stage);
            this.setMaterial(stage.getBlockType());
            this.setLeftClick(stage.needLeftClick());
        }

        @Override
        public StageInteractBlock finishStage(StageController controller) {
            return new StageInteractBlock(controller, this.leftClick, this.block);
        }
    }
}

