/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.editors.WaitBlockClick;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.stages.types.Locatable;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.utils.types.BQLocation;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;

@Locatable.LocatableType(types={Locatable.LocatedType.BLOCK, Locatable.LocatedType.OTHER})
public class StageInteractLocation
extends AbstractStage
implements Locatable.PreciseLocatable,
Listener {
    private final boolean left;
    @NotNull
    private final BQLocation lc;
    private Locatable.Located.LocatedBlock locatedBlock;

    public StageInteractLocation(@NotNull StageController controller, boolean leftClick, @NotNull BQLocation location) {
        super(controller);
        this.left = leftClick;
        this.lc = new BQLocation(location.getWorldName(), (double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
    }

    @NotNull
    public BQLocation getLocation() {
        return this.lc;
    }

    public boolean needLeftClick() {
        return this.left;
    }

    @Override
    public Locatable.Located getLocated() {
        Block realBlock;
        if (this.lc == null) {
            return null;
        }
        if (this.locatedBlock == null && (realBlock = this.lc.getMatchingBlock()) != null) {
            this.locatedBlock = Locatable.Located.LocatedBlock.create(realBlock);
        }
        return this.locatedBlock;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (e.getClickedBlock() == null) {
            return;
        }
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (this.left ? e.getAction() != Action.LEFT_CLICK_BLOCK : e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!this.lc.equals(e.getClickedBlock().getLocation())) {
            return;
        }
        Player p = e.getPlayer();
        if (this.hasApplicableQuester(p) && this.matchesRequirements(p)) {
            e.setCancelled(true);
            this.controller.getApplicableQuesters(p).forEach(x$0 -> this.finishStage((Quester)x$0));
        }
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.compose(this.lc);
        placeholders.registerIndexed("location", this.lc.getBlockX() + " " + this.lc.getBlockY() + " " + this.lc.getBlockZ());
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_INTERACT_LOCATION.toString();
    }

    @Override
    protected void serialize(ConfigurationSection section) {
        section.set("leftClick", (Object)this.left);
        section.set("location", this.lc.serialize());
    }

    public static StageInteractLocation deserialize(ConfigurationSection section, StageController controller) {
        return new StageInteractLocation(controller, section.getBoolean("leftClick"), BQLocation.deserialize(section.getConfigurationSection("location").getValues(false)));
    }

    public static class Creator
    extends StageCreation<StageInteractLocation> {
        private boolean leftClick = false;
        private BQLocation location;

        public Creator(@NotNull StageCreationContext<StageInteractLocation> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(6, ItemUtils.itemSwitch(Lang.leftClick.toString(), this.leftClick, new String[0]), event -> this.setLeftClick(!this.leftClick));
            line.setItem(7, ItemUtils.item(XMaterial.COMPASS, Lang.blockLocation.toString(), new String[0]), event -> {
                Lang.CLICK_BLOCK.send((CommandSender)event.getPlayer());
                new WaitBlockClick(event.getPlayer(), event::reopen, obj -> {
                    this.setLocation((Location)obj);
                    event.reopen();
                }, ItemUtils.item(XMaterial.STICK, Lang.blockLocation.toString(), new String[0])).start();
            });
        }

        public void setLeftClick(boolean leftClick) {
            if (this.leftClick != leftClick) {
                this.leftClick = leftClick;
                this.getLine().refreshItem(6, item -> ItemUtils.setSwitch(item, leftClick));
            }
        }

        public void setLocation(@NotNull Location location) {
            this.location = BQLocation.of(Objects.requireNonNull(location));
            this.getLine().refreshItemLoreOptionValue(7, Lang.Location.format((HasPlaceholders)this.location));
        }

        @Override
        public void start(Player p) {
            super.start(p);
            Lang.CLICK_BLOCK.send((CommandSender)p);
            new WaitBlockClick(p, this.context::removeAndReopenGui, obj -> {
                this.setLocation((Location)obj);
                this.context.reopenGui();
            }, ItemUtils.item(XMaterial.STICK, Lang.blockLocation.toString(), new String[0])).start();
        }

        @Override
        public void edit(StageInteractLocation stage) {
            super.edit(stage);
            this.setLocation(stage.getLocation());
            this.setLeftClick(stage.needLeftClick());
        }

        @Override
        public StageInteractLocation finishStage(StageController controller) {
            return new StageInteractLocation(controller, this.leftClick, this.location);
        }
    }
}

