/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.WaitClick;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.editors.parsers.PatternParser;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.stages.types.Locatable;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.gui.npc.NpcCreateGUI;
import fr.skytasul.quests.utils.types.BQLocation;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.NotNull;

@Locatable.LocatableType(types={Locatable.LocatedType.OTHER})
public class StageLocation
extends AbstractStage
implements Locatable.PreciseLocatable,
Listener {
    private final BQLocation lc;
    private final int radius;
    private final int radiusSquared;

    public StageLocation(StageController controller, BQLocation lc, int radius) {
        super(controller);
        this.lc = lc;
        this.radius = radius;
        this.radiusSquared = radius * radius;
    }

    public BQLocation getLocation() {
        return this.lc;
    }

    @Override
    public Locatable.Located getLocated() {
        return this.lc;
    }

    public int getRadius() {
        return this.radius;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        if (e.getFrom().getBlockX() == e.getTo().getBlockX() && e.getFrom().getBlockY() == e.getTo().getBlockY() && e.getFrom().getBlockZ() == e.getTo().getBlockZ()) {
            return;
        }
        if (!this.lc.isWorld(e.getTo().getWorld())) {
            return;
        }
        Player p = e.getPlayer();
        if (this.matchesRequirements(p) && this.lc.distanceSquared(e.getTo()) <= (double)this.radiusSquared) {
            this.controller.getApplicableQuesters(p).forEach(x$0 -> this.finishStage((Quester)x$0));
        }
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexed("target_x", this.lc.getBlockX());
        placeholders.registerIndexed("target_y", this.lc.getBlockY());
        placeholders.registerIndexed("target_z", this.lc.getBlockZ());
        placeholders.registerIndexed("target_world", this.lc.getWorldName());
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_LOCATION.toString();
    }

    @Override
    protected void serialize(ConfigurationSection section) {
        section.set("location", this.lc.serialize());
        section.set("radius", (Object)this.radius);
    }

    public static StageLocation deserialize(ConfigurationSection section, StageController controller) {
        return new StageLocation(controller, BQLocation.deserialize(section.getConfigurationSection("location").getValues(false)), section.getInt("radius"));
    }

    public static class Creator
    extends StageCreation<StageLocation> {
        private static final int SLOT_RADIUS = 6;
        private static final int SLOT_LOCATION = 7;
        private static final int SLOT_WORLD_PATTERN = 8;
        private Location location;
        private Pattern pattern;
        private int radius;

        public Creator(@NotNull StageCreationContext<StageLocation> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(6, ItemUtils.item(XMaterial.REDSTONE, Lang.stageLocationRadius.toString(), new String[0]), event -> {
                Lang.LOCATION_RADIUS.send((CommandSender)event.getPlayer());
                new TextEditor<Integer>(event.getPlayer(), event::reopen, x -> {
                    this.setRadius((int)x);
                    event.reopen();
                }, NumberParser.INTEGER_PARSER_STRICT_POSITIVE).start();
            });
            line.setItem(7, ItemUtils.item(XMaterial.STICK, Lang.stageLocationLocation.toString(), new String[0]), event -> {
                Lang.LOCATION_GO.send((CommandSender)event.getPlayer());
                new WaitClick(event.getPlayer(), event::reopen, NpcCreateGUI.validMove, () -> {
                    this.setLocation(BQLocation.of(event.getPlayer().getLocation()));
                    event.reopen();
                }).start();
            });
            line.setItem(8, ItemUtils.item(XMaterial.NAME_TAG, Lang.stageLocationWorldPattern.toString(), QuestOption.formatDescription(Lang.stageLocationWorldPatternLore.toString())), event -> {
                Lang.LOCATION_WORLDPATTERN.send((CommandSender)event.getPlayer());
                new TextEditor<Pattern>(event.getPlayer(), event::reopen, pattern -> {
                    this.setPattern((Pattern)pattern);
                    event.reopen();
                }, PatternParser.PARSER).passNullIntoEndConsumer().start();
            });
        }

        public void setLocation(Location location) {
            this.location = location;
            this.getLine().refreshItem(7, item -> ItemUtils.loreOptionValue(item, Lang.Location.format((HasPlaceholders)this.getBQLocation())));
        }

        public void setRadius(int radius) {
            this.radius = radius;
            this.getLine().refreshItem(6, item -> ItemUtils.lore(item, Lang.stageLocationCurrentRadius.quickFormat("radius", radius)));
        }

        public void setPattern(Pattern pattern) {
            this.pattern = pattern;
            this.getLine().refreshItem(8, item -> ItemUtils.lore(item, QuestOption.formatDescription(Lang.stageLocationWorldPatternLore.format(new HasPlaceholders[0])), "", pattern == null ? Lang.NotSet.toString() : QuestOption.formatNullableValue(pattern.pattern())));
        }

        private BQLocation getBQLocation() {
            BQLocation loc = BQLocation.of(this.location);
            if (this.pattern != null) {
                loc.setWorldPattern(this.pattern);
            }
            return loc;
        }

        @Override
        public void start(Player p) {
            super.start(p);
            Lang.LOCATION_GO.send((CommandSender)p);
            new WaitClick(p, this.context::removeAndReopenGui, NpcCreateGUI.validMove, () -> {
                this.setLocation(p.getLocation());
                this.setRadius(5);
                this.context.reopenGui();
            }).start();
        }

        @Override
        public void edit(StageLocation stage) {
            super.edit(stage);
            this.setLocation(stage.getLocation());
            this.setRadius(stage.getRadius());
            this.setPattern(stage.getLocation().getWorldPattern());
        }

        @Override
        public StageLocation finishStage(StageController controller) {
            return new StageLocation(controller, this.getBQLocation(), this.radius);
        }
    }
}

