/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages;

import com.cryptomorin.xseries.XMaterial;
import com.gestankbratwurst.playerblocktracker.PlayerBlockTracker;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.QuestsConfigurationImplementation;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.blocks.BQBlock;
import fr.skytasul.quests.api.events.internal.BQBlockBreakEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.stages.types.AbstractCountableBlockStage;
import fr.skytasul.quests.api.stages.types.Locatable;
import fr.skytasul.quests.api.utils.CountableObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Locatable.LocatableType(types={Locatable.LocatedType.BLOCK})
public class StageMine
extends AbstractCountableBlockStage
implements Locatable.MultipleLocatable,
Listener {
    private boolean placeCancelled;

    public StageMine(StageController controller, List<CountableObject<BQBlock>> blocks) {
        super(controller, blocks);
    }

    public boolean isPlaceCancelled() {
        return this.placeCancelled;
    }

    public void setPlaceCancelled(boolean cancelPlaced) {
        this.placeCancelled = cancelPlaced;
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_MINE.toString();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMine(BQBlockBreakEvent e) {
        Player p = e.getPlayer();
        if (!this.hasApplicableQuester(p) || !this.matchesRequirements(p)) {
            return;
        }
        for (Block block : e.getBlocks()) {
            if (this.placeCancelled && (QuestsConfigurationImplementation.getConfiguration().usePlayerBlockTracker() ? PlayerBlockTracker.isTracked((Block)block) : block.hasMetadata("playerInStage") && ((MetadataValue)block.getMetadata("playerInStage").get(0)).asString().equals(p.getName()))) {
                return;
            }
            if (!this.event(p, block, 1)) continue;
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlace(BlockPlaceEvent e) {
        if (QuestsConfigurationImplementation.getConfiguration().usePlayerBlockTracker()) {
            return;
        }
        if (e.isCancelled() || !this.placeCancelled) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.hasApplicableQuester(p)) {
            return;
        }
        Map<UUID, Integer> playerBlocks = this.getRawRemainingAmounts(PlayerManager.getPlayerAccount(p), true);
        if (playerBlocks == null) {
            return;
        }
        for (UUID id : playerBlocks.keySet()) {
            Optional object = this.getObject(id);
            if (!object.isPresent() || !this.objectApplies((BQBlock)object.get().getObject(), (Object)e.getBlock())) continue;
            e.getBlock().setMetadata("playerInStage", (MetadataValue)new FixedMetadataValue((Plugin)BeautyQuests.getInstance(), (Object)p.getName()));
            return;
        }
    }

    @Override
    public Spliterator<Locatable.Located> getNearbyLocated(Locatable.MultipleLocatable.NearbyFetcher fetcher) {
        return QuestsAPI.getAPI().getBlocksManager().getNearbyBlocks(fetcher, this.objects.stream().map(CountableObject::getObject).collect(Collectors.toList()));
    }

    @Override
    protected void serialize(ConfigurationSection section) {
        super.serialize(section);
        if (this.placeCancelled) {
            section.set("placeCancelled", (Object)this.placeCancelled);
        }
    }

    public static StageMine deserialize(ConfigurationSection section, StageController controller) {
        StageMine stage = new StageMine(controller, (List<CountableObject<BQBlock>>)new ArrayList<CountableObject<BQBlock>>());
        stage.deserialize(section);
        if (section.contains("placeCancelled")) {
            stage.placeCancelled = section.getBoolean("placeCancelled");
        }
        return stage;
    }

    public static class Creator
    extends AbstractCountableBlockStage.AbstractCreator<StageMine> {
        private boolean prevent = false;

        public Creator(@NotNull StageCreationContext<StageMine> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(6, ItemUtils.itemSwitch(Lang.preventBlockPlace.toString(), this.prevent, new String[0]), event -> this.setPrevent(!this.prevent));
        }

        @Override
        protected ItemStack getBlocksItem() {
            return ItemUtils.item(XMaterial.STONE_PICKAXE, Lang.editBlocksMine.toString(), new String[0]);
        }

        public void setPrevent(boolean prevent) {
            if (this.prevent != prevent) {
                this.prevent = prevent;
                this.getLine().refreshItem(6, item -> ItemUtils.setSwitch(item, prevent));
            }
        }

        @Override
        public void edit(StageMine stage) {
            super.edit(stage);
            this.setPrevent(stage.isPlaceCancelled());
        }

        @Override
        public StageMine finishStage(StageController controller) {
            StageMine stage = new StageMine(controller, this.getImmutableBlocks());
            stage.setPlaceCancelled(this.prevent);
            return stage;
        }
    }
}

