/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.events.internal.BQMobDeathEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.stages.types.AbstractCountableStage;
import fr.skytasul.quests.api.stages.types.Locatable;
import fr.skytasul.quests.api.utils.CountableObject;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import fr.skytasul.quests.gui.mobs.MobsListGUI;
import fr.skytasul.quests.mobs.BukkitEntityFactory;
import fr.skytasul.quests.mobs.Mob;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

@Locatable.LocatableType(types={Locatable.LocatedType.ENTITY})
public class StageMobs
extends AbstractCountableStage<Mob<?>>
implements Locatable.MultipleLocatable,
Listener {
    private boolean shoot = false;
    private boolean preventNpcsForVanilla = true;

    public StageMobs(StageController controller, List<CountableObject<Mob<?>>> mobs) {
        super(controller, mobs);
    }

    public boolean isShoot() {
        return this.shoot;
    }

    public void setShoot(boolean shoot) {
        this.shoot = shoot;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMobKilled(BQMobDeathEvent e) {
        Projectile projectile;
        ProjectileSource projectileSource;
        if (this.shoot && e.getBukkitEntity() != null && e.getBukkitEntity().getLastDamageCause() != null && e.getBukkitEntity().getLastDamageCause().getCause() != EntityDamageEvent.DamageCause.PROJECTILE) {
            return;
        }
        Entity killerEntity = e.getKiller();
        if (killerEntity instanceof Projectile && (projectileSource = (projectile = (Projectile)killerEntity).getShooter()) instanceof Entity) {
            Entity shooter;
            killerEntity = shooter = (Entity)projectileSource;
        }
        if (!(killerEntity instanceof Player)) {
            return;
        }
        Player killer = (Player)killerEntity;
        if (killer == e.getBukkitEntity()) {
            return;
        }
        this.event(killer, new KilledMob(e.getPluginMob(), e.getBukkitEntity()), e.getAmount());
    }

    @Override
    protected boolean objectApplies(Mob<?> object, Object other) {
        KilledMob otherMob = (KilledMob)other;
        if (!object.applies(otherMob.pluginMob)) {
            return false;
        }
        if (this.preventNpcsForVanilla && object.getFactory() instanceof BukkitEntityFactory && QuestsPlugin.getPlugin().getNpcManager().isNPC(otherMob.bukkitEntity)) {
            return false;
        }
        return object.getMinLevel() == null || !(object.getLevel(otherMob.bukkitEntity) < object.getMinLevel());
    }

    @Override
    @NotNull
    protected String getPlaceholderKey() {
        return "mobs";
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_MOBS.toString();
    }

    @Override
    public void started(Quester acc) {
        super.started(acc);
        if (this.sendStartMessage()) {
            MessageUtils.sendRawMessage(acc, Lang.STAGE_MOBSLIST.toString(), this.getPlaceholdersRegistry(), (PlaceholdersContext)StageDescriptionPlaceholdersContext.of(true, acc, DescriptionSource.FORCELINE, MessageType.DefaultMessageType.PREFIXED));
        }
    }

    @Override
    protected Mob<?> cloneObject(Mob<?> object) {
        return object.clone();
    }

    @Override
    protected String getName(Mob<?> object) {
        return object.getName();
    }

    @Override
    protected Object serialize(Mob<?> object) {
        return object.serialize();
    }

    @Override
    protected Mob<?> deserialize(Object object) {
        return Mob.deserialize((Map)object);
    }

    @Override
    protected void serialize(ConfigurationSection section) {
        super.serialize(section);
        if (this.shoot) {
            section.set("shoot", (Object)true);
        }
        if (!this.preventNpcsForVanilla) {
            section.set("preventNpcsForVanilla", (Object)false);
        }
    }

    @Override
    public boolean canBeFetchedAsynchronously() {
        return false;
    }

    @Override
    public Spliterator<Locatable.Located> getNearbyLocated(Locatable.MultipleLocatable.NearbyFetcher fetcher) {
        if (!fetcher.isTargeting(Locatable.LocatedType.ENTITY)) {
            return Spliterators.emptySpliterator();
        }
        return fetcher.getCenter().getWorld().getEntities().stream().filter(entity -> this.objects.stream().anyMatch(entry -> ((Mob)entry.getObject()).appliesEntity((Entity)entity))).map(x -> {
            double ds = x.getLocation().distanceSquared(fetcher.getCenter());
            if (ds > fetcher.getMaxDistanceSquared()) {
                return null;
            }
            return new AbstractMap.SimpleEntry<Entity, Double>((Entity)x, ds);
        }).filter(Objects::nonNull).sorted(Comparator.comparing(Map.Entry::getValue)).map(entry -> Locatable.Located.LocatedEntity.create((Entity)entry.getKey())).spliterator();
    }

    public static StageMobs deserialize(ConfigurationSection section, StageController controller) {
        StageMobs stage = new StageMobs(controller, new ArrayList());
        stage.deserialize(section);
        if (section.contains("shoot")) {
            stage.shoot = section.getBoolean("shoot");
        }
        if (section.contains("preventNpcsForVanilla")) {
            stage.preventNpcsForVanilla = section.getBoolean("preventNpcsForVanilla");
        }
        return stage;
    }

    private class KilledMob {
        final Object pluginMob;
        final Entity bukkitEntity;

        KilledMob(Object pluginMob, Entity bukkitEntity) {
            this.pluginMob = pluginMob;
            this.bukkitEntity = bukkitEntity;
        }
    }

    public static class Creator
    extends StageCreation<StageMobs> {
        private List<CountableObject.MutableCountableObject<Mob<?>>> mobs;
        private boolean shoot = false;
        private boolean preventNpcsForVanilla = true;

        public Creator(@NotNull StageCreationContext<StageMobs> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(7, ItemUtils.item(XMaterial.STONE_SWORD, Lang.editMobs.toString(), new String[0]), event -> new MobsListGUI(this.mobs, newMobs -> {
                this.setMobs((List<CountableObject.MutableCountableObject<Mob<?>>>)newMobs);
                event.reopen();
            }).open(event.getPlayer()));
            line.setItem(6, ItemUtils.itemSwitch(Lang.mobsKillType.toString(), this.shoot, new String[0]), event -> this.setShoot(!this.shoot));
        }

        public void setMobs(List<CountableObject.MutableCountableObject<Mob<?>>> mobs) {
            this.mobs = mobs;
            this.getLine().refreshItem(7, item -> ItemUtils.loreOptionValue(item, Lang.AmountMobs.quickFormat("mobs_amount", mobs.size())));
        }

        public void setShoot(boolean shoot) {
            if (this.shoot != shoot) {
                this.shoot = shoot;
                this.getLine().refreshItem(6, item -> ItemUtils.setSwitch(item, shoot));
            }
        }

        @Override
        public void start(Player p) {
            super.start(p);
            new MobsListGUI(Collections.emptyList(), newMobs -> {
                this.setMobs((List<CountableObject.MutableCountableObject<Mob<?>>>)newMobs);
                this.context.reopenGui();
            }).open(p);
        }

        @Override
        public StageMobs finishStage(StageController controller) {
            StageMobs stage = new StageMobs(controller, this.mobs.stream().map(CountableObject.MutableCountableObject::toImmutable).collect(Collectors.toList()));
            stage.setShoot(this.shoot);
            stage.preventNpcsForVanilla = this.preventNpcsForVanilla;
            return stage;
        }

        @Override
        public void edit(StageMobs stage) {
            super.edit(stage);
            this.setMobs(stage.getMutableObjects());
            this.setShoot(stage.shoot);
            this.preventNpcsForVanilla = stage.preventNpcsForVanilla;
        }
    }
}

