/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.QuestsConfigurationImplementation;
import fr.skytasul.quests.api.AbstractHolograms;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.DialogEditor;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.npcs.dialogs.Dialog;
import fr.skytasul.quests.api.npcs.dialogs.DialogRunner;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.stages.types.Dialogable;
import fr.skytasul.quests.api.stages.types.Locatable;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.npcs.BQNPCClickEvent;
import fr.skytasul.quests.utils.QuestUtils;
import fr.skytasul.quests.utils.types.DialogRunnerImplementation;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

@Locatable.LocatableType(types={Locatable.LocatedType.ENTITY})
public class StageNPC
extends AbstractStage
implements Locatable.PreciseLocatable,
Dialogable,
Listener {
    private BqNpc npc;
    private String npcID;
    protected Dialog dialog = null;
    protected DialogRunnerImplementation dialogRunner = null;
    protected boolean hide = false;
    private BukkitTask task;
    private List<Player> cached = new ArrayList<Player>();
    protected AbstractHolograms.BQHologram hologram;

    public StageNPC(StageController controller) {
        super(controller);
    }

    private void launchRefreshTask() {
        if (this.npc == null) {
            return;
        }
        this.task = new BukkitRunnable(){
            List<Player> tmp = new ArrayList<Player>();

            public void run() {
                Entity en = StageNPC.this.npc.getNpc().getEntity();
                if (en == null) {
                    return;
                }
                if (!en.getType().isAlive()) {
                    return;
                }
                Location lc = en.getLocation();
                this.tmp.clear();
                for (Player p : StageNPC.this.cached) {
                    if (p.getWorld() != lc.getWorld() || lc.distance(p.getLocation()) > 50.0) continue;
                    this.tmp.add(p);
                }
                if (QuestsConfigurationImplementation.getConfiguration().getHoloTalkItem() != null && QuestsAPI.getAPI().hasHologramsManager() && QuestsAPI.getAPI().getHologramsManager().supportItems() && QuestsAPI.getAPI().getHologramsManager().supportPerPlayerVisibility()) {
                    if (StageNPC.this.hologram == null) {
                        StageNPC.this.createHoloLaunch();
                    }
                    StageNPC.this.hologram.setPlayersVisible(this.tmp);
                    StageNPC.this.hologram.teleport(QuestUtils.upLocationForEntity((LivingEntity)en, 1.0));
                }
                if (QuestsConfigurationImplementation.getConfiguration().showTalkParticles()) {
                    if (this.tmp.isEmpty()) {
                        return;
                    }
                    QuestsConfigurationImplementation.getConfiguration().getParticleTalk().send(en, this.tmp);
                }
            }
        }.runTaskTimer((Plugin)BeautyQuests.getInstance(), 20L, 6L);
    }

    private void createHoloLaunch() {
        ItemStack item = QuestsConfigurationImplementation.getConfiguration().getHoloTalkItem();
        this.hologram = QuestsAPI.getAPI().getHologramsManager().createHologram(this.npc.getNpc().getLocation(), false);
        if (QuestsConfigurationImplementation.getConfiguration().isCustomHologramNameShown() && item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            this.hologram.appendTextLine(item.getItemMeta().getDisplayName());
        }
        this.hologram.appendItem(item);
    }

    private void removeHoloLaunch() {
        if (this.hologram == null) {
            return;
        }
        this.hologram.delete();
        this.hologram = null;
    }

    @Override
    public BqNpc getNPC() {
        return this.npc;
    }

    public String getNPCID() {
        return this.npcID;
    }

    public void setNPC(String npcID) {
        this.npcID = npcID;
        if (npcID != null) {
            this.npc = QuestsPlugin.getPlugin().getNpcManager().getById(npcID);
        }
        if (this.npc == null) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("The NPC " + npcID + " does not exist for " + this.getController().toString());
        } else {
            this.npcID = this.npc.getId();
            this.initDialogRunner();
        }
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public Dialog getDialog() {
        return this.dialog;
    }

    @Override
    public DialogRunner getDialogRunner() {
        return this.dialogRunner;
    }

    public boolean isHid() {
        return this.hide;
    }

    public void setHid(boolean hide) {
        this.hide = hide;
    }

    @Override
    public boolean isShown(Player player) {
        return !this.hide;
    }

    @Override
    public Locatable.Located getLocated() {
        return this.npc.getNpc().getLocation() == null ? null : this.npc;
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_NPC.toString();
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexed("dialog_npc_name", this::getNpcName);
        placeholders.compose(this.npc);
    }

    protected void initDialogRunner() {
        if (this.dialogRunner != null) {
            throw new IllegalStateException("Dialog runner already initialized");
        }
        this.dialogRunner = new DialogRunnerImplementation(this.dialog, this.npc);
        this.dialogRunner.addTest(x$0 -> super.hasApplicableQuester((Player)x$0));
        this.dialogRunner.addTestCancelling(p -> this.matchesRequirements((Player)p, true));
        this.dialogRunner.addEndAction(p -> this.controller.getApplicableQuesters((Player)p).forEach(x$0 -> this.finishStage((Quester)x$0)));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onClick(BQNPCClickEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getNPC() != this.npc) {
            return;
        }
        if (!QuestsConfiguration.getConfig().getQuestsConfig().getNpcClicks().contains((Object)e.getClick())) {
            return;
        }
        Player p = e.getPlayer();
        e.setCancelled(this.dialogRunner.onClick(p).shouldCancel());
    }

    @Override
    public String getNpcName() {
        if (this.npc == null) {
            return "\u00a7c\u00a7lunknown NPC " + this.npcID;
        }
        if (this.dialog != null && this.dialog.getNpcName() != null) {
            return this.dialog.getNpcName();
        }
        return this.npc.getNpc().getName();
    }

    @Override
    public void joined(Player p, Quester quester) {
        super.joined(p, null);
        this.cachePlayer(p);
    }

    private void cachePlayer(Player p) {
        this.cached.add(p);
        if (this.npc != null) {
            this.npc.hideForPlayer(p, this);
        }
    }

    private void uncachePlayer(Player p) {
        this.cached.remove(p);
        if (this.npc != null) {
            this.npc.removeHiddenForPlayer(p, this);
        }
    }

    private void uncacheAll() {
        if (this.npc != null) {
            this.cached.forEach(p -> this.npc.removeHiddenForPlayer((Player)p, this));
        }
    }

    @Override
    public void left(Player p, Quester quester) {
        super.left(p, null);
        this.uncachePlayer(p);
        if (this.dialogRunner != null) {
            this.dialogRunner.removePlayer(p);
        }
    }

    @Override
    public void started(Quester acc) {
        super.started(acc);
        acc.getOnlinePlayers().forEach(this::cachePlayer);
    }

    @Override
    public void ended(Quester acc) {
        super.ended(acc);
        acc.getOnlinePlayers().forEach(p -> {
            this.uncachePlayer((Player)p);
            if (this.dialogRunner != null) {
                this.dialogRunner.removePlayer((Player)p);
            }
        });
    }

    @Override
    public void unload() {
        super.unload();
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.dialogRunner != null) {
            this.dialogRunner.unload();
        }
        this.removeHoloLaunch();
        this.uncacheAll();
    }

    @Override
    public void load() {
        super.load();
        if ((QuestsConfigurationImplementation.getConfiguration().showTalkParticles() || QuestsConfigurationImplementation.getConfiguration().getHoloTalkItem() != null) && !this.hide) {
            this.launchRefreshTask();
        }
    }

    protected void loadDatas(ConfigurationSection section) {
        if (section.contains("msg")) {
            this.setDialog(Dialog.deserialize(section.getConfigurationSection("msg")));
        }
        if (section.contains("npcID")) {
            this.setNPC(section.getString("npcID"));
        } else {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("No NPC specified for " + this.toString());
        }
        if (section.contains("hid")) {
            this.hide = section.getBoolean("hid");
        }
    }

    @Override
    public void serialize(ConfigurationSection section) {
        section.set("npcID", (Object)this.npcID);
        if (this.dialog != null) {
            this.dialog.serialize(section.createSection("msg"));
        }
        if (this.hide) {
            section.set("hid", (Object)true);
        }
    }

    public static StageNPC deserialize(ConfigurationSection section, StageController controller) {
        StageNPC st = new StageNPC(controller);
        st.loadDatas(section);
        return st;
    }

    public static class Creator
    extends AbstractCreator<StageNPC> {
        public Creator(@NotNull StageCreationContext<StageNPC> context) {
            super(context);
        }

        @Override
        @NotNull
        protected StageNPC createStage(@NotNull StageController controller) {
            return new StageNPC(controller);
        }
    }

    public static abstract class AbstractCreator<T extends StageNPC>
    extends StageCreation<T> {
        private static final int SLOT_HIDE = 6;
        private static final int SLOT_NPC = 7;
        private static final int SLOT_DIALOG = 8;
        private String npcID = null;
        private Dialog dialog = null;
        private boolean hidden = false;

        protected AbstractCreator(@NotNull StageCreationContext<T> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(7, ItemUtils.item(XMaterial.VILLAGER_SPAWN_EGG, Lang.stageNPCSelect.toString(), new String[0]), event -> QuestsPlugin.getPlugin().getGuiManager().getFactory().createNpcSelection(event::reopen, newNPC -> {
                this.setNPCId(newNPC.getId());
                event.reopen();
            }, false).open(event.getPlayer()));
            line.setItem(8, ItemUtils.item(XMaterial.WRITABLE_BOOK, Lang.stageText.toString(), Lang.NotSet.toString()), event -> {
                Lang.NPC_TEXT.send((CommandSender)event.getPlayer());
                new DialogEditor(event.getPlayer(), () -> {
                    this.setDialog(this.dialog);
                    event.reopen();
                }, this.dialog == null ? (this.dialog = new Dialog()) : this.dialog).start();
            });
            line.setItem(6, ItemUtils.itemSwitch(Lang.stageHide.toString(), this.hidden, new String[0]), event -> this.setHidden(!this.hidden));
        }

        public void setNPCId(String npcID) {
            this.npcID = npcID;
            this.getLine().refreshItem(7, item -> ItemUtils.lore(item, QuestOption.formatDescription("ID: \u00a7l" + npcID)));
        }

        public void setDialog(Dialog dialog) {
            this.dialog = dialog;
            this.getLine().refreshItemLore(8, dialog == null ? Lang.NotSet.toString() : QuestOption.formatDescription(Lang.AmountDialogLines.quickFormat("lines_amount", dialog.getMessages().size())));
        }

        public void setHidden(boolean hidden) {
            if (this.hidden != hidden) {
                this.hidden = hidden;
                this.getLine().refreshItem(6, item -> ItemUtils.setSwitch(item, hidden));
            }
        }

        @Override
        public void start(Player p) {
            super.start(p);
            QuestsPlugin.getPlugin().getGuiManager().getFactory().createNpcSelection(this.context::removeAndReopenGui, newNPC -> {
                this.setNPCId(newNPC.getId());
                this.context.reopenGui();
            }, false).open(p);
        }

        @Override
        public void edit(T stage) {
            super.edit(stage);
            this.setNPCId(((StageNPC)stage).getNPCID());
            this.setDialog(((StageNPC)stage).dialog);
            this.setHidden(((StageNPC)stage).hide);
        }

        @Override
        protected final T finishStage(StageController controller) {
            T stage = this.createStage(controller);
            ((StageNPC)stage).setDialog(this.dialog);
            ((StageNPC)stage).setNPC(this.npcID);
            ((StageNPC)stage).setHid(this.hidden);
            return stage;
        }

        protected abstract T createStage(StageController var1);
    }
}

