/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.DurationParser;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.players.PlayerQuester;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.requirements.RequirementList;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import fr.skytasul.quests.api.utils.progress.HasProgress;
import fr.skytasul.quests.api.utils.progress.ProgressPlaceholders;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class StagePlayTime
extends AbstractStage
implements HasProgress {
    private final long playTicks;
    private final TimeMode timeMode;
    private Map<Player, BukkitTask> tasks = new HashMap<Player, BukkitTask>();

    public StagePlayTime(StageController controller, long ticks, TimeMode timeMode) {
        super(controller);
        this.playTicks = ticks;
        this.timeMode = timeMode;
    }

    public long getTicksToPlay() {
        return this.playTicks;
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_PLAY_TIME.toString();
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexedContextual("time_remaining_human", PlaceholdersContext.QuesterPlaceholdersContext.class, context -> Utils.millisToHumanString(this.getRemainingAmount(context.getQuester())));
        ProgressPlaceholders.registerProgress(placeholders, "time", this);
    }

    private long getRemaining(Quester acc) {
        switch (this.timeMode.ordinal()) {
            case 0: {
                long remaining = this.getData(acc, "remainingTime", Long.class);
                long lastJoin = this.getData(acc, "lastJoin", Long.class);
                long playedTicks = (System.currentTimeMillis() - lastJoin) / 50L;
                return remaining - playedTicks;
            }
            case 1: {
                World world = Bukkit.getWorld((UUID)this.getData(acc, "worldUuid", UUID.class));
                if (world == null) {
                    QuestsPlugin.getPlugin().getLoggerExpanded().namedWarning("Cannot get remaining time of {} for {} because the world has changed.", acc.getIdentifier() + this.hashCode() + "time", 15, acc.getFriendlyName(), this.controller);
                    return -1L;
                }
                long startTime = this.getData(acc, "worldStartTime", Long.class);
                long elapsedTicks = world.getGameTime() - startTime;
                return this.playTicks - elapsedTicks;
            }
            case 2: {
                long startTime = this.getData(acc, "startTime", Long.class);
                long elapsedTicks = (System.currentTimeMillis() - startTime) / 50L;
                return this.playTicks - elapsedTicks;
            }
        }
        throw new UnsupportedOperationException();
    }

    private void launchTask(Player p, long remaining) {
        this.tasks.put(p, Bukkit.getScheduler().runTaskLater((Plugin)BeautyQuests.getInstance(), () -> this.controller.getApplicableQuesters(p).forEach(x$0 -> this.finishStage((Quester)x$0)), remaining < 0L ? 0L : remaining));
    }

    @Override
    public long getRemainingAmount(@NotNull Quester quester) {
        return this.getRemaining(quester) * 50L;
    }

    @Override
    public long getTotalAmount() {
        return this.playTicks * 50L;
    }

    @Override
    public void joined(Player p, Quester quester) {
        super.joined(p, null);
        if (this.timeMode == TimeMode.ONLINE) {
            this.updateObjective(quester, "lastJoin", System.currentTimeMillis());
        }
        this.launchTask(p, this.getRemaining(quester));
    }

    @Override
    public void left(Player p, Quester quester) {
        super.left(p, null);
        BukkitTask task = this.tasks.remove(p);
        if (task != null) {
            this.cancelTask(p, task);
        } else {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Unavailable task in \"Play Time\" stage " + this.toString() + " for player " + p.getName());
        }
    }

    private void cancelTask(Player p, BukkitTask task) {
        task.cancel();
        if (this.timeMode == TimeMode.ONLINE) {
            PlayerQuester quester = PlayerManager.getPlayerAccount(p);
            this.updateObjective(quester, "remainingTime", this.getRemaining(quester));
        }
    }

    @Override
    public void started(Quester quester) {
        super.started(quester);
        quester.getOnlinePlayers().forEach(p -> this.launchTask((Player)p, this.playTicks));
    }

    @Override
    public void ended(Quester quester) {
        super.ended(quester);
        quester.getOnlinePlayers().forEach(p -> this.tasks.remove(p).cancel());
    }

    @Override
    public void initPlayerDatas(Quester acc, Map<String, Object> datas) {
        super.initPlayerDatas(acc, datas);
        switch (this.timeMode.ordinal()) {
            case 0: {
                datas.put("remainingTime", this.playTicks);
                datas.put("lastJoin", System.currentTimeMillis());
                break;
            }
            case 1: {
                World world = (World)Bukkit.getWorlds().get(0);
                datas.put("worldStartTime", world.getGameTime());
                datas.put("worldUuid", world.getUID().toString());
                break;
            }
            case 2: {
                datas.put("startTime", System.currentTimeMillis());
            }
        }
    }

    @Override
    public void unload() {
        super.unload();
        this.tasks.forEach(this::cancelTask);
        this.tasks.clear();
    }

    @Override
    public void setValidationRequirements(@NotNull RequirementList validationRequirements) {
        super.setValidationRequirements(validationRequirements);
        if (!validationRequirements.isEmpty()) {
            QuestsPlugin.getPlugin().getLogger().warning(validationRequirements.size() + " requirements are set for a \"play time\" stage, but requirements are unsupported for this stage type.\n" + this.controller.toString());
        }
    }

    @Override
    protected void serialize(ConfigurationSection section) {
        section.set("playTicks", (Object)this.playTicks);
        section.set("timeMode", (Object)this.timeMode.name());
    }

    public static StagePlayTime deserialize(ConfigurationSection section, StageController controller) {
        return new StagePlayTime(controller, section.getLong("playTicks"), TimeMode.valueOf(section.getString("timeMode", "ONLINE").toUpperCase()));
    }

    public static enum TimeMode {
        ONLINE(Lang.stagePlayTimeModeOnline.toString()),
        OFFLINE(Lang.stagePlayTimeModeOffline.toString()),
        REALTIME(Lang.stagePlayTimeModeRealtime.toString());

        private final String description;

        private TimeMode(String description) {
            this.description = description;
        }

        public boolean isActive() {
            return true;
        }
    }

    public static class Creator
    extends StageCreation<StagePlayTime> {
        private long ticks;
        private TimeMode timeMode = TimeMode.ONLINE;
        private int slotTicks;
        private int slotTimeMode;

        public Creator(@NotNull StageCreationContext<StagePlayTime> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.refreshItemName(4, "\u00a7n" + String.valueOf(Lang.validationRequirements) + "\u00a7c " + Lang.Disabled.toString().toUpperCase());
            this.slotTicks = line.setItem(7, ItemUtils.item(XMaterial.CLOCK, Lang.changeTicksRequired.toString(), new String[0]), event -> {
                Lang.GAME_TICKS.send((CommandSender)event.getPlayer());
                new TextEditor<Long>(event.getPlayer(), event::reopen, obj -> {
                    this.setTicks((long)obj);
                    event.reopen();
                }, DurationParser.MinecraftTimeUnit.TICK.getParser()).start();
            });
            this.slotTimeMode = line.setItem(8, ItemUtils.item(XMaterial.COMMAND_BLOCK, Lang.stagePlayTimeChangeTimeMode.toString(), QuestOption.formatNullableValue((Object)this.timeMode.description, this.timeMode == TimeMode.ONLINE)), event -> {
                TimeMode next = this.timeMode;
                while (!(next = TimeMode.values()[(next.ordinal() + 1) % TimeMode.values().length]).isActive()) {
                }
                this.setTimeMode(next);
            });
        }

        public void setTicks(long ticks) {
            this.ticks = ticks;
            this.getLine().refreshItemLoreOptionValue(this.slotTicks, Lang.Ticks.quickFormat("ticks", ticks));
        }

        public void setTimeMode(TimeMode timeMode) {
            if (this.timeMode != timeMode) {
                this.timeMode = timeMode;
                this.getLine().refreshItemLore(this.slotTimeMode, QuestOption.formatNullableValue((Object)timeMode.description, timeMode == TimeMode.ONLINE));
            }
        }

        @Override
        public void start(Player p) {
            super.start(p);
            Lang.GAME_TICKS.send((CommandSender)p);
            new TextEditor<Long>(p, this.context::removeAndReopenGui, obj -> {
                this.setTicks((long)obj);
                this.context.reopenGui();
            }, DurationParser.MinecraftTimeUnit.TICK.getParser()).start();
        }

        @Override
        public void edit(StagePlayTime stage) {
            super.edit(stage);
            this.setTicks(stage.playTicks);
            this.setTimeMode(stage.timeMode);
        }

        @Override
        public StagePlayTime finishStage(StageController controller) {
            return new StagePlayTime(controller, this.ticks, this.timeMode);
        }
    }
}

