/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.stages.options;

import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.options.StageOption;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import fr.skytasul.quests.api.utils.progress.HasProgress;
import fr.skytasul.quests.api.utils.progress.ProgressBarConfig;
import fr.skytasul.quests.api.utils.progress.ProgressPlaceholders;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class StageOptionProgressBar<T extends AbstractStage>
extends StageOption<T> {
    @NotNull
    private final Map<Quester, ProgressBar> bars = new HashMap<Quester, ProgressBar>();

    public StageOptionProgressBar(@NotNull Class<? extends T> stageClass) {
        super(stageClass);
    }

    @Override
    @NotNull
    public StageOption<T> clone() {
        return new StageOptionProgressBar(this.getStageClass());
    }

    @Override
    public void startEdition(@NotNull StageCreation<T> creation) {
    }

    @Override
    public boolean shouldSave() {
        return false;
    }

    @Override
    public void save(@NotNull ConfigurationSection section) {
    }

    @Override
    public void load(@NotNull ConfigurationSection section) {
    }

    @Override
    public void stageStart(Quester quester, StageController stage) {
        if (this.areBarsEnabled()) {
            this.bars.computeIfAbsent(quester, __ -> new ProgressBar(this, quester, stage.getStage()));
        }
    }

    @Override
    public void stageEnd(Quester quester, StageController stage) {
        this.removeBar(quester);
    }

    @Override
    public void stageJoin(Player p, @NotNull Quester quester, StageController stage) {
        if (this.areBarsEnabled()) {
            this.bars.computeIfAbsent(quester, __ -> new ProgressBar(this, quester, stage.getStage())).update();
        }
    }

    @Override
    public void stageLeave(Player p, @NotNull Quester quester, StageController stage) {
        this.removeBar(quester);
    }

    @Override
    public void stageUpdated(@NotNull Quester quester, @NotNull StageController stage) {
        ProgressBar bar = this.bars.get(quester);
        if (bar != null) {
            bar.update();
        }
    }

    @Override
    public void stageUnload(@NotNull StageController stage) {
        this.bars.values().forEach(ProgressBar::remove);
        this.bars.clear();
    }

    public ProgressBarConfig getProgressConfig() {
        return QuestsConfiguration.getConfig().getStageDescriptionConfig();
    }

    public boolean areBarsEnabled() {
        return this.getProgressConfig().areBossBarsEnabled();
    }

    protected void removeBar(@NotNull Quester quester) {
        if (this.bars.containsKey(quester)) {
            this.bars.remove(quester).remove();
        }
    }

    static class ProgressBar {
        private final Quester quester;
        private final T progress;
        private final long totalAmount;
        private final PlaceholderRegistry placeholders;
        private final BossBar bar;
        private BukkitTask timer;
        final /* synthetic */ StageOptionProgressBar this$0;

        public ProgressBar(Quester quester, T progress) {
            this.this$0 = this$0;
            this.quester = quester;
            this.progress = progress;
            this.totalAmount = ((HasProgress)progress).getTotalAmount();
            this.placeholders = PlaceholderRegistry.combine(new HasPlaceholders[]{progress});
            ProgressPlaceholders.registerProgress(this.placeholders, "progress", (HasProgress)progress);
            BossBar.Overlay style = null;
            style = this.totalAmount % 20L == 0L ? BossBar.Overlay.NOTCHED_20 : (this.totalAmount % 10L == 0L ? BossBar.Overlay.NOTCHED_10 : (this.totalAmount % 12L == 0L ? BossBar.Overlay.NOTCHED_12 : (this.totalAmount % 6L == 0L ? BossBar.Overlay.NOTCHED_6 : BossBar.Overlay.PROGRESS)));
            this.bar = BossBar.bossBar((Component)Component.empty(), (float)0.0f, (BossBar.Color)BossBar.Color.YELLOW, (BossBar.Overlay)style);
            this.update();
            quester.showBossBar(this.bar);
        }

        public void remove() {
            this.quester.hideBossBar(this.bar);
            if (this.timer != null) {
                this.timer.cancel();
            }
        }

        public void update() {
            this.timer();
            long playerRemaining = ((HasProgress)this.progress).getRemainingAmount(this.quester);
            if (playerRemaining >= 0L && playerRemaining <= this.totalAmount) {
                float progress = (float)(this.totalAmount - playerRemaining) * 1.0f / (float)this.totalAmount;
                this.bar.progress(progress);
            } else {
                QuestsPlugin.getPlugin().getLoggerExpanded().warning("Amount of objects invalid in {} for player {}: {}/{}", ((AbstractStage)this.progress).getController(), this.quester.getFriendlyName(), playerRemaining, this.totalAmount);
            }
            String formattedName = MessageUtils.format(this.this$0.getProgressConfig().getBossBarFormat(), this.placeholders, PlaceholdersContext.of(this.quester, true, null));
            this.bar.name((Component)LegacyComponentSerializer.legacySection().deserialize(formattedName));
            this.quester.showBossBar(this.bar);
        }

        private void timer() {
            if (this.this$0.getProgressConfig().getBossBarTimeout() <= 0) {
                return;
            }
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = Bukkit.getScheduler().runTaskLater((Plugin)QuestsPlugin.getPlugin(), () -> {
                this.quester.hideBossBar(this.bar);
                this.timer = null;
            }, (long)this.this$0.getProgressConfig().getBossBarTimeout() * 20L);
        }
    }
}

