/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.structure;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.data.DataLoadingException;
import fr.skytasul.quests.api.data.DataSavingException;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.quests.branches.QuestBranch;
import fr.skytasul.quests.api.quests.branches.QuestBranchesManager;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageIndex;
import fr.skytasul.quests.structure.QuestBranchImplementation;
import fr.skytasul.quests.structure.QuestImplementation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class BranchesManagerImplementation
implements QuestBranchesManager {
    @NotNull
    private Map<Integer, QuestBranchImplementation> branches = new TreeMap<Integer, QuestBranchImplementation>(Integer::compare);
    @NotNull
    private final QuestImplementation quest;

    public BranchesManagerImplementation(@NotNull QuestImplementation quest) {
        this.quest = quest;
    }

    @Override
    @NotNull
    public QuestImplementation getQuest() {
        return this.quest;
    }

    public void addBranch(@NotNull QuestBranchImplementation branch) {
        Validate.notNull((Object)branch, (String)"Branch cannot be null !");
        this.branches.put(this.branches.size(), branch);
    }

    @Override
    public int getId(@NotNull QuestBranch branch) {
        for (Map.Entry<Integer, QuestBranchImplementation> en : this.branches.entrySet()) {
            if (en.getValue() != branch) continue;
            return en.getKey();
        }
        QuestsPlugin.getPlugin().getLoggerExpanded().severe("Trying to get the ID of a branch not in manager of quest " + this.quest.getId());
        return -1;
    }

    @Override
    @NotNull
    public @UnmodifiableView @NotNull Collection<@NotNull QuestBranch> getBranches() {
        return this.branches.values();
    }

    @Override
    @Nullable
    public QuestBranchImplementation getBranch(int id) {
        return this.branches.get(id);
    }

    @Override
    @Nullable
    public QuestBranchImplementation getPlayerBranch(@NotNull Quester acc) {
        return acc.getDataHolder().getQuestDataIfPresent(this.quest).map(x -> {
            if (x.getBranch().isPresent()) {
                return this.branches.get(x.getBranch().getAsInt());
            }
            return null;
        }).orElse(null);
    }

    @Override
    public boolean hasBranchStarted(@NotNull Quester acc, @NotNull QuestBranch branch) {
        return acc.getDataHolder().getQuestDataIfPresent(this.quest).filter(x -> x.getBranch().orElse(-1) == branch.getId()).isPresent();
    }

    @Override
    @Nullable
    public StageController getStageFromIndex(@NotNull StageIndex index) throws IllegalArgumentException {
        if (index instanceof StageIndex.RegularStageIndex) {
            StageIndex.RegularStageIndex regularIndex = (StageIndex.RegularStageIndex)index;
            return this.getBranch(regularIndex.branch()).getRegularStage(regularIndex.stageIndex());
        }
        if (index instanceof StageIndex.EndingStageIndex) {
            StageIndex.EndingStageIndex endingIndex = (StageIndex.EndingStageIndex)index;
            return this.getBranch(endingIndex.branch()).getEndingStage(endingIndex.stageId());
        }
        throw new UnsupportedOperationException();
    }

    public final void questUpdated(@NotNull Quester quester) {
        QuestsAPI.getAPI().propagateQuestsHandlers(x -> x.questUpdated(quester, this.quest));
    }

    public void startPlayer(@NotNull Quester acc) {
        QuesterQuestData datas = acc.getDataHolder().getQuestData(this.getQuest());
        datas.resetQuestFlow();
        datas.setStartingTime(OptionalLong.of(System.currentTimeMillis()));
        this.branches.get(0).start(acc);
    }

    public void remove(@NotNull Quester acc) {
        if (!acc.getDataHolder().hasQuestData(this.quest)) {
            return;
        }
        QuestBranchImplementation branch = this.getPlayerBranch(acc);
        if (branch != null) {
            branch.remove(acc, true);
        }
    }

    public void remove() {
        for (QuestBranchImplementation branch : this.branches.values()) {
            branch.remove();
        }
        this.branches.clear();
    }

    public void save(@NotNull ConfigurationSection section) throws DataSavingException {
        ConfigurationSection branchesSection = section.createSection("branches");
        for (Integer id : this.branches.keySet()) {
            QuestBranchImplementation branch = this.branches.get(id);
            try {
                branch.save(branchesSection.createSection(Integer.toString(id)));
            }
            catch (DataSavingException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new DataSavingException("Error when serializing the branch " + id, ex);
            }
        }
    }

    public String toString() {
        return "BranchesManager{branches=" + this.branches.size() + "}";
    }

    @NotNull
    public static BranchesManagerImplementation deserialize(@NotNull ConfigurationSection section, @NotNull QuestImplementation qu) throws DataLoadingException {
        BranchesManagerImplementation bm = new BranchesManagerImplementation(qu);
        ConfigurationSection branchesSection = section.getConfigurationSection("branches");
        HashMap<QuestBranchImplementation, ConfigurationSection> tmpBranches = new HashMap<QuestBranchImplementation, ConfigurationSection>();
        for (String key : branchesSection.getKeys(false)) {
            try {
                int id = Integer.parseInt(key);
                QuestBranchImplementation branch = new QuestBranchImplementation(bm);
                bm.branches.put(id, branch);
                tmpBranches.put(branch, branchesSection.getConfigurationSection(key));
            }
            catch (NumberFormatException ex) {
                throw new DataLoadingException("Cannot parse branch ID %s for quest %d".formatted(key, qu.getId()));
            }
        }
        for (QuestBranchImplementation branch : tmpBranches.keySet()) {
            try {
                branch.load((ConfigurationSection)tmpBranches.get(branch));
            }
            catch (DataLoadingException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new DataLoadingException("Error when deserializing the branch " + branch.getId());
            }
        }
        return bm;
    }
}

