/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.structure;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.QuestsConfigurationImplementation;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.data.DataLoadingException;
import fr.skytasul.quests.api.data.DataSavingException;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.quests.branches.EndingStage;
import fr.skytasul.quests.api.quests.branches.QuestBranch;
import fr.skytasul.quests.api.quests.events.questers.QuesterSetStageEvent;
import fr.skytasul.quests.api.requirements.Actionnable;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageIndex;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.players.AdminMode;
import fr.skytasul.quests.structure.BranchesManagerImplementation;
import fr.skytasul.quests.structure.EndingStageImplementation;
import fr.skytasul.quests.structure.QuestImplementation;
import fr.skytasul.quests.structure.StageControllerImplementation;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class QuestBranchImplementation
implements QuestBranch {
    private final List<EndingStageImplementation> endStages = new ArrayList<EndingStageImplementation>(5);
    private final List<StageControllerImplementation> regularStages = new ArrayList<StageControllerImplementation>(15);
    @NotNull
    private final BranchesManagerImplementation manager;

    public QuestBranchImplementation(@NotNull BranchesManagerImplementation manager) {
        this.manager = manager;
    }

    @Override
    @NotNull
    public QuestImplementation getQuest() {
        return this.manager.getQuest();
    }

    @Override
    @NotNull
    public BranchesManagerImplementation getManager() {
        return this.manager;
    }

    public int getStageSize() {
        return this.regularStages.size();
    }

    @Override
    public int getId() {
        return this.manager.getId(this);
    }

    public void addRegularStage(@NotNull StageControllerImplementation<?> stage) {
        Validate.notNull(stage, (String)"Stage cannot be null !");
        this.regularStages.add(stage);
        stage.load();
    }

    public void addEndStage(@NotNull StageControllerImplementation<?> stage, @NotNull QuestBranchImplementation linked) {
        Validate.notNull(stage, (String)"Stage cannot be null !");
        this.endStages.add(new EndingStageImplementation(stage, linked));
        stage.load();
    }

    @Override
    @NotNull
    public @NotNull @UnmodifiableView List<@NotNull StageController> getRegularStages() {
        return this.regularStages;
    }

    @Override
    @NotNull
    public StageControllerImplementation<?> getRegularStage(int id) {
        return this.regularStages.get(id);
    }

    @Override
    @NotNull
    public @UnmodifiableView List<EndingStage> getEndingStages() {
        return this.endStages;
    }

    @Override
    @NotNull
    public StageController getEndingStage(int id) {
        return this.endStages.get(id).getStage();
    }

    @Nullable
    public QuestBranchImplementation getLinkedBranch(@NotNull StageController endingStage) {
        return this.endStages.stream().filter(end -> end.getStage().equals(endingStage)).findAny().get().getBranch();
    }

    @NotNull
    public StageIndex getStageIndex(@NotNull StageController stage) {
        if (this.regularStages.contains(stage)) {
            return new StageIndex.RegularStageIndex(this.getId(), this.regularStages.indexOf(stage));
        }
        if (this.isEndingStage(stage)) {
            return new StageIndex.EndingStageIndex(this.getId(), this.getEndingStageId(stage));
        }
        throw new IllegalArgumentException("Stage was not a part of the branch");
    }

    public int getRegularStageId(StageController stage) {
        if (!this.regularStages.contains(stage)) {
            throw new IllegalArgumentException("Stage is not a part of the branch");
        }
        return this.regularStages.indexOf(stage);
    }

    public int getEndingStageId(StageController stage) {
        for (int i = 0; i < this.endStages.size(); ++i) {
            EndingStage endingStage = this.endStages.get(i);
            if (!endingStage.getStage().equals(stage)) continue;
            return i;
        }
        throw new IllegalArgumentException("Stage is not a part of the branch");
    }

    public boolean isEndingStage(StageController stage) {
        return this.endStages.stream().anyMatch(end -> end.getStage().equals(stage));
    }

    private boolean isInAsyncReward(@NotNull Quester quester) {
        return this.regularStages.stream().anyMatch(x -> x.getStage().getRewards().isInAsyncReward(quester)) || this.endStages.stream().anyMatch(x -> ((StageControllerImplementation)x.getStage()).getStage().getRewards().isInAsyncReward(quester));
    }

    @Override
    @NotNull
    public String getDescriptionLine(@NotNull Quester quester, @NotNull DescriptionSource source) {
        QuesterQuestData data = quester.getDataHolder().getQuestDataIfPresent(this.getQuest()).filter(x -> x.getBranch().orElse(-1) == this.getId()).orElseThrow(() -> new IllegalArgumentException("Account does not have this branch launched"));
        if (this.isInAsyncReward(quester)) {
            return Lang.SCOREBOARD_ASYNC_END.toString();
        }
        if (this.isInStageEnd(data)) {
            return this.endStages.stream().map(stage -> ((StageControllerImplementation)stage.getStage()).getDescriptionLine(quester, source)).filter(Objects::nonNull).collect(Collectors.joining("{nl}" + String.valueOf(Lang.SCOREBOARD_BETWEEN_BRANCHES) + " {nl}"));
        }
        if (data.getStage().isEmpty()) {
            return "\u00a7cerror: no stage set for branch " + this.getId();
        }
        if (data.getStage().getAsInt() >= this.regularStages.size()) {
            return "\u00a7cerror: datas do not match";
        }
        String descriptionLine = this.regularStages.get(data.getStage().getAsInt()).getDescriptionLine(quester, source);
        return MessageUtils.format(QuestsConfiguration.getConfig().getStageDescriptionConfig().getStageDescriptionFormat(), PlaceholderRegistry.of("stage_index", data.getStage().getAsInt() + 1, "stage_amount", this.regularStages.size(), "stage_description", descriptionLine == null ? "" : descriptionLine));
    }

    @Override
    public boolean hasStageLaunched(@Nullable Quester quester, @NotNull StageController stage) {
        if (quester == null) {
            return false;
        }
        if (this.isInAsyncReward(quester)) {
            return false;
        }
        Optional<QuesterQuestData> dataOpt = quester.getDataHolder().getQuestDataIfPresent(this.getQuest());
        if (dataOpt.isEmpty()) {
            return false;
        }
        QuesterQuestData data = dataOpt.get();
        if (data.getBranch().isEmpty() || data.getBranch().getAsInt() != this.getId()) {
            return false;
        }
        if (this.isEndingStage(stage)) {
            return this.isInStageEnd(data);
        }
        return this.getRegularStageId(stage) == data.getStage().orElse(-1);
    }

    public void remove(@NotNull Quester acc, boolean end) {
        Optional<QuesterQuestData> dataOpt = acc.getDataHolder().getQuestDataIfPresent(this.getQuest());
        if (dataOpt.isEmpty()) {
            return;
        }
        QuesterQuestData data = dataOpt.get();
        if (end) {
            if (data.getState() == QuesterQuestData.State.IN_ENDING_STAGES) {
                this.endStages.forEach(x -> ((StageControllerImplementation)x.getStage()).end(acc));
            } else if (data.getStage().isPresent() && data.getStage().getAsInt() < this.regularStages.size()) {
                ((StageControllerImplementation)this.getRegularStage(data.getStage().getAsInt())).end(acc);
            }
        }
        data.setBranch(OptionalInt.empty());
        data.setStage(OptionalInt.empty());
    }

    public void start(@NotNull Quester acc) {
        acc.getDataHolder().getQuestData(this.getQuest()).setBranch(OptionalInt.of(this.getId()));
        if (!this.regularStages.isEmpty()) {
            this.setPlayerStage(acc, this.regularStages.get(0));
        } else {
            this.setPlayerEndingStages(acc);
        }
    }

    @Override
    public void finishPlayerStage(@NotNull Quester quester, @NotNull StageController stage) {
        QuestsPlugin.getPlugin().getLoggerExpanded().debug("Next stage for {} (coming from {})", quester.getDetailedName(), stage);
        QuesterQuestData datas = quester.getDataHolder().getQuestData(this.getQuest());
        if (datas.getBranch().orElse(-1) != this.getId() || this.isInStageEnd(datas) && !this.isEndingStage(stage) || !this.isInStageEnd(datas) && datas.getStage().orElse(-1) != this.getRegularStageId(stage)) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Trying to finish stage {} for {} but was not in progress.", stage, quester.getDetailedName());
            return;
        }
        AdminMode.broadcast("Quester " + quester.getFriendlyName() + " has finished the stage " + String.valueOf(stage.getIndex()) + " of quest " + this.getQuest().getId());
        datas.addQuestFlow(stage);
        if (this.isEndingStage(stage)) {
            for (EndingStageImplementation end : this.endStages) {
                if (end.getStage() == stage) continue;
                ((StageControllerImplementation)end.getStage()).end(quester);
            }
        }
        datas.setStage(OptionalInt.empty());
        this.endStage(quester, (StageControllerImplementation)stage, () -> {
            if (!this.manager.getQuest().hasStarted(quester)) {
                return;
            }
            if (this.regularStages.contains(stage)) {
                int newId = this.getRegularStageId(stage) + 1;
                if (newId == this.regularStages.size()) {
                    if (this.endStages.isEmpty()) {
                        this.remove(quester, false);
                        this.getQuest().finish(quester);
                        return;
                    }
                    this.setPlayerEndingStages(quester);
                } else {
                    this.setPlayerStage(quester, this.regularStages.get(newId));
                }
            } else {
                this.remove(quester, false);
                QuestBranchImplementation branch = this.getLinkedBranch(stage);
                if (branch == null) {
                    this.getQuest().finish(quester);
                    return;
                }
                branch.start(quester);
            }
            this.manager.questUpdated(quester);
        });
    }

    private void endStage(@NotNull Quester quester, @NotNull StageControllerImplementation<?> stage, @NotNull Runnable runAfter) {
        stage.end(quester);
        stage.getStage().getValidationRequirements().stream().filter(Actionnable.class::isInstance).map(Actionnable.class::cast).forEach(x -> quester.getOnlinePlayers().forEach(x::trigger));
        stage.getStage().getRewards().giveRewards(quester).whenComplete((BiConsumer)BeautyQuests.getInstance().getLoggerExpanded().logError(rewardsResult -> {
            if (rewardsResult.branchInterruption()) {
                QuestsPlugin.getPlugin().getLoggerExpanded().debug("Interrupted branching in async stage end for {}", quester.getDetailedName());
                return;
            }
            if (QuestsConfiguration.getConfig().getQuestsConfig().stageEndRewardsMessage()) {
                rewardsResult.earnings().forEach((player, earnings) -> Lang.FINISHED_OBTAIN.quickSend((CommandSender)player, "rewards", (Object)MessageUtils.itemsToFormattedString(earnings.toArray(new String[0]))));
            }
            runAfter.run();
        }, "failed to give rewards", quester, new Object[0]));
    }

    @Override
    public void setPlayerStage(@NotNull Quester quester, @NotNull StageController stage) {
        QuesterQuestData questDatas = quester.getDataHolder().getQuestData(this.getQuest());
        if (questDatas.getBranch().getAsInt() != this.getId()) {
            throw new IllegalStateException("The player is not in the right branch");
        }
        if (QuestsConfiguration.getConfig().getQuestsConfig().playerQuestUpdateMessage() && questDatas.getStage().isPresent()) {
            Lang.QUEST_UPDATED.send(quester, this.getQuest());
        }
        questDatas.setState(QuesterQuestData.State.IN_REGULAR_STAGE);
        questDatas.setStage(OptionalInt.of(this.getRegularStageId(stage)));
        quester.getOnlinePlayers().forEach(this::playNextStage);
        ((StageControllerImplementation)stage).start(quester);
        Bukkit.getPluginManager().callEvent((Event)new QuesterSetStageEvent(quester, this.getQuest(), stage));
    }

    @Override
    public void setPlayerEndingStages(@NotNull Quester quester) {
        QuesterQuestData datas = quester.getDataHolder().getQuestData(this.getQuest());
        if (datas.getBranch().getAsInt() != this.getId()) {
            throw new IllegalStateException("The player is not in the right branch");
        }
        if (QuestsConfiguration.getConfig().getQuestsConfig().playerQuestUpdateMessage()) {
            Lang.QUEST_UPDATED.send(quester, this.getQuest());
        }
        datas.setState(QuesterQuestData.State.IN_ENDING_STAGES);
        for (EndingStageImplementation endStage : this.endStages) {
            ((StageControllerImplementation)endStage.getStage()).start(quester);
            Bukkit.getPluginManager().callEvent((Event)new QuesterSetStageEvent(quester, this.getQuest(), endStage.getStage()));
        }
        quester.getOnlinePlayers().forEach(this::playNextStage);
    }

    private void playNextStage(@NotNull Player p) {
        QuestUtils.playPluginSound(p.getLocation(), QuestsConfiguration.getConfig().getQuestsConfig().nextStageSound(), 0.5f);
        if (QuestsConfigurationImplementation.getConfiguration().showNextParticles()) {
            QuestsConfigurationImplementation.getConfiguration().getParticleNext().send((Entity)p, Arrays.asList(p));
        }
    }

    private boolean isInStageEnd(@NotNull QuesterQuestData data) {
        return data.getState() == QuesterQuestData.State.IN_ENDING_STAGES;
    }

    public void remove() {
        this.regularStages.forEach(StageControllerImplementation::unload);
        this.regularStages.clear();
        this.endStages.forEach(end -> ((StageControllerImplementation)end.getStage()).unload());
        this.endStages.clear();
    }

    public void save(@NotNull ConfigurationSection section) throws DataSavingException {
        ConfigurationSection stagesSection = section.createSection("stages");
        for (int i = 0; i < this.regularStages.size(); ++i) {
            try {
                this.regularStages.get(i).getStage().save(stagesSection.createSection(Integer.toString(i)));
                continue;
            }
            catch (Exception ex) {
                throw new DataSavingException("Failed to serialize the stage " + i, ex);
            }
        }
        ConfigurationSection endSection = section.createSection("endingStages");
        for (int i = 0; i < this.endStages.size(); ++i) {
            EndingStageImplementation en = this.endStages.get(i);
            try {
                ConfigurationSection stageSection = endSection.createSection(Integer.toString(i));
                ((StageControllerImplementation)en.getStage()).getStage().save(stageSection);
                QuestBranchImplementation branchLinked = en.getBranch();
                if (branchLinked == null) continue;
                stageSection.set("branchLinked", (Object)branchLinked.getId());
                continue;
            }
            catch (Exception ex) {
                throw new DataSavingException("Failed to serialize the ending stage " + i, ex);
            }
        }
    }

    public String toString() {
        return "QuestBranch{regularStages=" + this.regularStages.size() + ",endingStages=" + this.endStages.size() + "}";
    }

    public void load(@NotNull ConfigurationSection section) throws DataLoadingException {
        ConfigurationSection stagesSection = section.getConfigurationSection("stages");
        Iterator iterator = stagesSection.getKeys(false).stream().map(Integer::parseInt).sorted().collect(Collectors.toSet()).iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            try {
                this.addRegularStage(StageControllerImplementation.loadFromConfig(this, stagesSection.getConfigurationSection(Integer.toString(id))));
            }
            catch (Exception ex) {
                throw new DataLoadingException("Error when deserializing the stage " + id, ex);
            }
        }
        ConfigurationSection endingStagesSection = section.getConfigurationSection("endingStages");
        if (endingStagesSection != null) {
            for (String key : endingStagesSection.getKeys(false)) {
                try {
                    ConfigurationSection stage = endingStagesSection.getConfigurationSection(key);
                    QuestBranchImplementation branchLinked = stage.contains("branchLinked") ? this.manager.getBranch(stage.getInt("branchLinked")) : null;
                    this.addEndStage(StageControllerImplementation.loadFromConfig(this, stage), branchLinked);
                }
                catch (Exception ex) {
                    throw new DataLoadingException("Error when deserializing the ending stage " + key, ex);
                }
            }
        }
    }
}

