/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.structure;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.data.DataLoadingException;
import fr.skytasul.quests.api.data.DataSavingException;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.npcs.dialogs.DialogRunner;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.options.QuestOptionCreator;
import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.options.description.QuestDescriptionContext;
import fr.skytasul.quests.api.options.description.QuestDescriptionProvider;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.quests.events.QuestRemoveEvent;
import fr.skytasul.quests.api.quests.events.questers.QuesterQuestFinishEvent;
import fr.skytasul.quests.api.quests.events.questers.QuesterQuestLaunchEvent;
import fr.skytasul.quests.api.quests.events.questers.QuesterQuestPreLaunchEvent;
import fr.skytasul.quests.api.quests.events.questers.QuesterQuestResetEvent;
import fr.skytasul.quests.api.quests.quester.QuestQuesterStrategy;
import fr.skytasul.quests.api.requirements.Actionnable;
import fr.skytasul.quests.api.requirements.RequirementList;
import fr.skytasul.quests.api.rewards.RewardList;
import fr.skytasul.quests.api.utils.PlayerListCategory;
import fr.skytasul.quests.api.utils.QuestVisibilityLocation;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.api.utils.messaging.DefaultErrors;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import fr.skytasul.quests.npcs.BqNpcImplementation;
import fr.skytasul.quests.options.OptionBypassLimit;
import fr.skytasul.quests.options.OptionCancelRewards;
import fr.skytasul.quests.options.OptionCancellable;
import fr.skytasul.quests.options.OptionConfirmMessage;
import fr.skytasul.quests.options.OptionCustomOrder;
import fr.skytasul.quests.options.OptionDescription;
import fr.skytasul.quests.options.OptionEndMessage;
import fr.skytasul.quests.options.OptionEndRewards;
import fr.skytasul.quests.options.OptionEndSound;
import fr.skytasul.quests.options.OptionFirework;
import fr.skytasul.quests.options.OptionHideNoRequirements;
import fr.skytasul.quests.options.OptionName;
import fr.skytasul.quests.options.OptionQuestItem;
import fr.skytasul.quests.options.OptionQuestPool;
import fr.skytasul.quests.options.OptionQuesterStrategy;
import fr.skytasul.quests.options.OptionRepeatable;
import fr.skytasul.quests.options.OptionRequirements;
import fr.skytasul.quests.options.OptionScoreboardEnabled;
import fr.skytasul.quests.options.OptionStartDialog;
import fr.skytasul.quests.options.OptionStartMessage;
import fr.skytasul.quests.options.OptionStartRewards;
import fr.skytasul.quests.options.OptionStarterNPC;
import fr.skytasul.quests.options.OptionTimer;
import fr.skytasul.quests.options.OptionVisibility;
import fr.skytasul.quests.players.AdminMode;
import fr.skytasul.quests.structure.BranchesManagerImplementation;
import fr.skytasul.quests.structure.QuestBranchImplementation;
import fr.skytasul.quests.structure.QuestsManagerImplementation;
import fr.skytasul.quests.structure.pools.QuestPoolImplementation;
import fr.skytasul.quests.utils.QuestUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestImplementation
implements Quest,
QuestDescriptionProvider,
Comparable<Quest> {
    private static final Pattern PERMISSION_PATTERN = Pattern.compile("^beautyquests\\.start\\.(\\d+)$");
    @NotNull
    private final QuestsManagerImplementation questsManager;
    private final int id;
    private final File file;
    private BranchesManagerImplementation manager;
    private List<QuestOption<?>> options = new ArrayList();
    private List<QuestDescriptionProvider> descriptions = new ArrayList<QuestDescriptionProvider>();
    private boolean removed = false;
    private PlaceholderRegistry placeholders;

    public QuestImplementation(@NotNull QuestsManagerImplementation questsManager, int id, @NotNull File file) {
        this.questsManager = questsManager;
        this.id = id;
        this.file = file;
        this.manager = new BranchesManagerImplementation(this);
        this.descriptions.add(this);
    }

    public void load() {
        QuestsAPI.getAPI().propagateQuestsHandlers(handler -> handler.questLoaded(this));
    }

    @Override
    public boolean isValid() {
        return !this.removed;
    }

    @Override
    @NotNull
    public List<QuestDescriptionProvider> getDescriptions() {
        return this.descriptions;
    }

    @Override
    public Iterator<QuestOption> iterator() {
        return this.options.iterator();
    }

    @Override
    @NotNull
    public <T extends QuestOption<?>> T getOption(@NotNull Class<T> clazz) {
        for (QuestOption<?> option : this.options) {
            if (!clazz.isInstance(option)) continue;
            return (T)option;
        }
        throw new NullPointerException("Quest " + this.id + " do not have option " + clazz.getName());
    }

    @Override
    public boolean hasOption(@NotNull Class<? extends QuestOption<?>> clazz) {
        for (QuestOption<?> option : this.options) {
            if (!clazz.isInstance(option)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addOption(@NotNull QuestOption<?> option) {
        if (!option.hasCustomValue()) {
            return;
        }
        this.options.add(option);
        option.attach(this);
        option.setValueUpdaterListener(() -> {
            if (!option.hasCustomValue()) {
                option.detach();
                this.options.remove(option);
            }
        });
    }

    @Override
    public void removeOption(@NotNull Class<? extends QuestOption<?>> clazz) {
        Iterator<QuestOption<?>> iterator = this.options.iterator();
        while (iterator.hasNext()) {
            QuestOption<?> option = iterator.next();
            if (!clazz.isInstance(option)) continue;
            option.detach();
            iterator.remove();
            break;
        }
    }

    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public File getFile() {
        return this.file;
    }

    public String getNameAndId() {
        return this.getName() + " (#" + this.id + ")";
    }

    @Override
    @Nullable
    public String getName() {
        return (String)this.getOptionValueOrDef(OptionName.class);
    }

    @Override
    @Nullable
    public String getDescription() {
        return (String)this.getOptionValueOrDef(OptionDescription.class);
    }

    @Override
    @NotNull
    public ItemStack getQuestItem() {
        return (ItemStack)this.getOptionValueOrDef(OptionQuestItem.class);
    }

    @Override
    public boolean isScoreboardEnabled() {
        return (Boolean)this.getOptionValueOrDef(OptionScoreboardEnabled.class);
    }

    @Override
    public boolean isCancellable() {
        return (Boolean)this.getOptionValueOrDef(OptionCancellable.class);
    }

    @Override
    public boolean isRepeatable() {
        return (Boolean)this.getOptionValueOrDef(OptionRepeatable.class);
    }

    @Override
    public boolean isHidden(QuestVisibilityLocation location) {
        return !((List)this.getOptionValueOrDef(OptionVisibility.class)).contains((Object)location);
    }

    @Override
    public boolean isHiddenWhenRequirementsNotMet() {
        return (Boolean)this.getOptionValueOrDef(OptionHideNoRequirements.class);
    }

    @Override
    public boolean canBypassLimit() {
        return (Boolean)this.getOptionValueOrDef(OptionBypassLimit.class);
    }

    @Override
    @Nullable
    public BqNpc getStarterNpc() {
        return (BqNpc)this.getOptionValueOrDef(OptionStarterNPC.class);
    }

    @Override
    @NotNull
    public BranchesManagerImplementation getBranchesManager() {
        return this.manager;
    }

    @Override
    public int compareTo(Quest o) {
        int order1 = ((OptionalInt)this.getOptionValueOrDef(OptionCustomOrder.class)).orElse(this.id);
        int order2 = ((OptionalInt)o.getOptionValueOrDef(OptionCustomOrder.class)).orElse(o.getId());
        return Integer.compare(order1, order2);
    }

    @Override
    @NotNull
    public QuestQuesterStrategy getQuesterStrategy() {
        return (QuestQuesterStrategy)this.getOptionValueOrDef(OptionQuesterStrategy.class);
    }

    private void ensureApplicableQuester(@NotNull Quester quester) {
        if (!this.getQuesterStrategy().isQuesterApplicable(quester)) {
            throw new IllegalArgumentException("The quester %s is not applicable in quest %d".formatted(quester.getDetailedName(), this.id));
        }
    }

    @NotNull
    public String getTimeLeft(@NotNull Quester quester) {
        if (!quester.getDataHolder().hasQuestData(this)) {
            return "x";
        }
        OptionalLong timer = quester.getDataHolder().getQuestData(this).getTimer();
        if (timer.isEmpty()) {
            return "x";
        }
        return Utils.millisToHumanString(timer.getAsLong() - System.currentTimeMillis());
    }

    @Override
    public boolean hasStarted(@NotNull Quester quester) {
        if (!quester.getDataHolder().hasQuestData(this)) {
            return false;
        }
        if (quester.getDataHolder().getQuestData(this).hasStarted()) {
            return true;
        }
        return ((RewardList)this.getOptionValueOrDef(OptionStartRewards.class)).isInAsyncReward(quester);
    }

    @Override
    public boolean hasFinished(@NotNull Quester quester) {
        return quester.getDataHolder().getQuestDataIfPresent(this).map(x -> x.hasFinishedOnce()).orElse(false);
    }

    @Override
    public boolean cancelQuester(@NotNull Quester quester) {
        Optional<QuesterQuestData> dataOpt = quester.getDataHolder().getQuestDataIfPresent(this);
        if (!dataOpt.map(x -> x.hasStarted()).orElse(false).booleanValue()) {
            return false;
        }
        QuestsPlugin.getPlugin().getLoggerExpanded().debug("Cancelling quest {} for {}", this.id, quester.getDetailedName());
        this.cancelInternal(quester);
        dataOpt.get().setState(QuesterQuestData.State.NOT_STARTED);
        return true;
    }

    private void cancelInternal(@NotNull Quester quester) {
        this.manager.remove(quester);
        QuestsAPI.getAPI().propagateQuestsHandlers(handler -> handler.questReset(quester, this));
        Bukkit.getPluginManager().callEvent((Event)new QuesterQuestResetEvent(quester, this));
        ((RewardList)this.getOptionValueOrDef(OptionCancelRewards.class)).giveRewards(quester).whenComplete(QuestsPlugin.getPlugin().getLoggerExpanded().logError("Failed to execute cancel rewards for quester {} in quest {}", quester.getDetailedName(), this.getId()));
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> resetQuester(@NotNull Quester quester) {
        this.ensureApplicableQuester(quester);
        boolean hadDatas = false;
        CompletableFuture<QuesterQuestData> future = null;
        if (quester.getDataHolder().hasQuestData(this)) {
            hadDatas = true;
            QuestsPlugin.getPlugin().getLoggerExpanded().debug("Resetting quest {} for player {}", this.id, quester.getDetailedName());
            this.cancelInternal(quester);
            future = quester.getDataHolder().removeQuestData(this);
        }
        if (this.hasOption(OptionStartDialog.class)) {
            DialogRunner dialogRunner = this.getOption(OptionStartDialog.class).getDialogRunner();
            for (Player p : quester.getOnlinePlayers()) {
                if (!dialogRunner.removePlayer(p)) continue;
                hadDatas = true;
            }
        }
        return future == null ? CompletableFuture.completedFuture(hadDatas) : future.thenApply(__ -> true);
    }

    @Override
    public boolean canStart(@NotNull Player p, boolean sendMessage) {
        Optional<? extends Quester> questerOpt = this.getQuesterStrategy().getPlayerQuester(p);
        if (questerOpt.isEmpty()) {
            if (sendMessage) {
                MessageUtils.sendMessage((CommandSender)p, "Incompatible quester type", (MessageType)MessageType.DefaultMessageType.PREFIXED);
            }
            return false;
        }
        Quester quester = questerOpt.get();
        if (this.hasStarted(quester)) {
            if (sendMessage) {
                Lang.ALREADY_STARTED.send((CommandSender)p);
            }
            return false;
        }
        if (!((Boolean)this.getOptionValueOrDef(OptionRepeatable.class)).booleanValue() && this.hasFinished(quester)) {
            return false;
        }
        if (!this.testTimer(quester, sendMessage)) {
            return false;
        }
        if (this.getQuesterStrategy().shouldAllPlayersMatchRequirements()) {
            for (Player innerPlayer : quester.getOnlinePlayers()) {
                if (this.testRequirements(innerPlayer, quester, sendMessage)) continue;
                return false;
            }
        } else if (!this.testRequirements(p, quester, sendMessage)) {
            return false;
        }
        return true;
    }

    public boolean testRequirements(@NotNull Player p, @NotNull Quester acc, boolean sendMessage) {
        if (!p.hasPermission("beautyquests.start")) {
            return false;
        }
        if (!this.testQuestLimit(p, acc, sendMessage)) {
            return false;
        }
        sendMessage = sendMessage && (!this.hasOption(OptionStarterNPC.class) || QuestsConfiguration.getConfig().getQuestsConfig().requirementReasonOnMultipleQuests() || ((BqNpc)this.getOption(OptionStarterNPC.class).getValue()).getQuests().size() == 1);
        return ((RequirementList)this.getOptionValueOrDef(OptionRequirements.class)).allMatch(p, sendMessage);
    }

    public boolean testQuestLimit(@NotNull Player p, @NotNull Quester acc, boolean sendMessage) {
        int playerMaxLaunchedQuest;
        if (Boolean.TRUE.equals(this.getOptionValueOrDef(OptionBypassLimit.class))) {
            return true;
        }
        OptionalInt playerMaxLaunchedQuestOpt = p.getEffectivePermissions().stream().filter(permission -> permission.getValue()).map(permission -> PERMISSION_PATTERN.matcher(permission.getPermission())).filter(matcher -> matcher.matches()).mapToInt(matcher -> Integer.parseInt(matcher.group(1))).max();
        if (playerMaxLaunchedQuestOpt.isPresent()) {
            playerMaxLaunchedQuest = playerMaxLaunchedQuestOpt.getAsInt();
        } else {
            if (QuestsConfiguration.getConfig().getQuestsConfig().maxLaunchedQuests() == 0) {
                return true;
            }
            playerMaxLaunchedQuest = QuestsConfiguration.getConfig().getQuestsConfig().maxLaunchedQuests();
        }
        if (this.questsManager.getStartedSize(acc) >= playerMaxLaunchedQuest) {
            if (sendMessage) {
                Lang.QUESTS_MAX_LAUNCHED.quickSend((CommandSender)p, "quests_max_amount", (Object)playerMaxLaunchedQuest);
            }
            return false;
        }
        return true;
    }

    public boolean testTimer(@NotNull Quester acc, boolean sendMessage) {
        if (this.isRepeatable() && acc.getDataHolder().hasQuestData(this)) {
            QuesterQuestData data = acc.getDataHolder().getQuestData(this);
            if (data.getTimer().orElse(0L) > System.currentTimeMillis()) {
                if (sendMessage) {
                    Lang.QUEST_WAIT.quickSend(acc, "time_left", (Object)this.getTimeLeft(acc));
                }
                return false;
            }
            if (data.getTimer().isPresent()) {
                data.setTimer(OptionalLong.empty());
            }
        }
        return true;
    }

    public boolean isInDialog(@NotNull Player p) {
        return this.hasOption(OptionStartDialog.class) && this.getOption(OptionStartDialog.class).getDialogRunner().isPlayerInDialog(p);
    }

    @Override
    public void doNpcClick(@NotNull Player p) {
        if (this.hasOption(OptionStartDialog.class)) {
            this.getOption(OptionStartDialog.class).getDialogRunner().onClick(p);
        } else {
            this.attemptStart(p);
        }
    }

    public void leave(@NotNull Player p) {
        if (this.hasOption(OptionStartDialog.class)) {
            this.getOption(OptionStartDialog.class).getDialogRunner().removePlayer(p);
        }
    }

    @Override
    @NotNull
    public String getDescriptionLine(@NotNull Quester quester, @NotNull DescriptionSource source) {
        if (!quester.getDataHolder().hasQuestData(this)) {
            throw new IllegalArgumentException("Account does not have quest datas for quest " + this.id);
        }
        if (((RewardList)this.getOptionValueOrDef(OptionStartRewards.class)).isInAsyncReward(quester)) {
            return "\u00a77x";
        }
        QuesterQuestData datas = quester.getDataHolder().getQuestData(this);
        if (datas.getState() == QuesterQuestData.State.IN_END) {
            return Lang.SCOREBOARD_ASYNC_END.toString();
        }
        QuestBranchImplementation branch = this.manager.getBranch(datas.getBranch().orElseThrow());
        if (branch == null) {
            throw new IllegalStateException("Account is in branch " + String.valueOf(datas.getBranch()) + " in quest " + this.id + ", which does not actually exist");
        }
        return branch.getDescriptionLine(quester, source);
    }

    @Override
    @NotNull
    public List<String> provideDescription(QuestDescriptionContext context) {
        if (context.getCategory() != PlayerListCategory.IN_PROGRESS) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.getDescriptionLine(context.getQuester(), context.getSource()));
    }

    @Override
    @NotNull
    public String getDescriptionId() {
        return "advancement";
    }

    @Override
    public double getDescriptionPriority() {
        return 15.0;
    }

    @Override
    @NotNull
    public PlaceholderRegistry getPlaceholdersRegistry() {
        if (this.placeholders == null) {
            this.placeholders = new PlaceholderRegistry().registerIndexed("quest", this::getNameAndId).register("quest_name", this::getName).register("quest_id", this.id).register("quest_description", this::getDescription);
        }
        return this.placeholders;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> attemptStart(@NotNull Player p) {
        String confirm;
        if (!this.canStart(p, true)) {
            return CompletableFuture.completedFuture(false);
        }
        Quester quester = this.getQuesterStrategy().getPlayerQuester(p).orElseThrow();
        if (QuestsConfiguration.getConfig().getQuestsConfig().questConfirmGUI() && !"none".equals(confirm = (String)this.getOptionValueOrDef(OptionConfirmMessage.class))) {
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            QuestsPlugin.getPlugin().getGuiManager().getFactory().createConfirmation(() -> {
                this.start(quester, false);
                future.complete(true);
            }, () -> future.complete(false), Lang.INDICATION_START.format((HasPlaceholders)this.getPlaceholdersRegistry()), confirm).open(p);
            return future;
        }
        this.start(quester, false);
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public void start(@NotNull Quester quester, boolean silently) {
        String startMsg;
        this.ensureApplicableQuester(quester);
        if (this.hasStarted(quester)) {
            if (!silently) {
                Lang.ALREADY_STARTED.send(quester);
            }
            return;
        }
        QuesterQuestPreLaunchEvent event = new QuesterQuestPreLaunchEvent(quester, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        AdminMode.broadcast(quester.getFriendlyName() + " started the quest " + this.id);
        quester.getDataHolder().getQuestData(this).setTimer(OptionalLong.empty());
        if (!silently && !"none".equals(startMsg = (String)this.getOptionValueOrDef(OptionStartMessage.class))) {
            MessageUtils.sendRawMessage(quester, startMsg, this.getPlaceholdersRegistry(), PlaceholdersContext.of(quester, true, null));
        }
        ((RewardList)this.getOptionValueOrDef(OptionStartRewards.class)).giveRewards(quester).whenComplete((result, ex) -> {
            if (ex != null) {
                DefaultErrors.sendGeneric(quester, "giving reward");
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while giving quest {} start rewards to {}.", (Throwable)ex, (Object)this.getId(), (Object)quester.getDetailedName());
            }
            if (result.branchInterruption()) {
                QuestsPlugin.getPlugin().getLoggerExpanded().debug("Useless branching interruption in the quest {} ending rewards", this.getId());
            }
            if (!silently) {
                result.earnings().forEach((? super K player, ? super V earnings) -> Lang.FINISHED_OBTAIN.quickSend((CommandSender)player, "rewards", (Object)MessageUtils.itemsToFormattedString((String[])earnings.toArray(String[]::new))));
            }
            ((RequirementList)this.getOptionValueOrDef(OptionRequirements.class)).stream().filter(Actionnable.class::isInstance).map(Actionnable.class::cast).forEach(x -> quester.getOnlinePlayers().forEach(x::trigger));
            QuestUtils.runOrSync(() -> {
                this.manager.startPlayer(quester);
                QuestsAPI.getAPI().propagateQuestsHandlers(handler -> handler.questStart(quester, this));
                Bukkit.getPluginManager().callEvent((Event)new QuesterQuestLaunchEvent(quester, this));
            });
        });
    }

    @Override
    public void finish(@NotNull Quester quester) {
        if (!quester.getDataHolder().hasQuestData(this)) {
            throw new IllegalStateException("Quester did not have data for this quest");
        }
        AdminMode.broadcast(quester.getFriendlyName() + " is completing the quest " + this.id);
        QuesterQuestData questDatas = quester.getDataHolder().getQuestData(this);
        questDatas.setState(QuesterQuestData.State.IN_END);
        ((CompletableFuture)((RewardList)this.getOptionValueOrDef(OptionEndRewards.class)).giveRewards(quester).whenComplete((result, ex) -> {
            if (ex != null) {
                DefaultErrors.sendGeneric(quester, "giving reward");
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while giving quest {} end rewards to {}.", (Throwable)ex, (Object)this.getId(), (Object)quester.getDetailedName());
            }
            if (result.branchInterruption()) {
                QuestsPlugin.getPlugin().getLoggerExpanded().debug("Useless branching interruption in the quest {} ending rewards", this.getId());
            }
            for (Player player : quester.getOnlinePlayers()) {
                MessageType.DefaultMessageType msgType;
                Object endMsg;
                if (this.hasOption(OptionEndMessage.class)) {
                    endMsg = (String)this.getOption(OptionEndMessage.class).getValue();
                    msgType = MessageType.DefaultMessageType.UNPREFIXED;
                } else {
                    endMsg = Lang.FINISHED_BASE.getValue();
                    msgType = MessageType.DefaultMessageType.PREFIXED;
                    if (!result.getPlayerEarnings(player).isEmpty()) {
                        endMsg = (String)endMsg + " " + Lang.FINISHED_OBTAIN.getValue();
                    }
                }
                MessageUtils.sendMessage((CommandSender)player, (String)endMsg, (MessageType)msgType, PlaceholderRegistry.of("rewards", MessageUtils.itemsToFormattedString((String[])result.getPlayerEarnings(player).toArray(String[]::new))).compose(false, this));
            }
            QuestUtils.runOrSync(() -> {
                this.manager.remove(quester);
                questDatas.setState(QuesterQuestData.State.NOT_STARTED);
                questDatas.setBranch(OptionalInt.empty());
                questDatas.incrementFinished();
                questDatas.setStartingTime(OptionalLong.empty());
                if (this.hasOption(OptionQuestPool.class)) {
                    ((QuestPoolImplementation)this.getOptionValueOrDef(OptionQuestPool.class)).questCompleted(quester, this);
                }
                if (this.isRepeatable()) {
                    Calendar cal = Calendar.getInstance();
                    cal.add(12, Math.max(0, (Integer)this.getOptionValueOrDef(OptionTimer.class)));
                    questDatas.setTimer(OptionalLong.of(cal.getTimeInMillis()));
                }
                quester.getOnlinePlayers().forEach(p -> QuestUtils.spawnFirework(p.getLocation(), (FireworkMeta)this.getOptionValueOrDef(OptionFirework.class)));
                QuestUtils.playPluginSound(quester, (String)this.getOptionValueOrDef(OptionEndSound.class), 1.0f);
                QuestsAPI.getAPI().propagateQuestsHandlers(handler -> handler.questFinish(quester, this));
                Bukkit.getPluginManager().callEvent((Event)new QuesterQuestFinishEvent(quester, this));
            });
        })).whenComplete(QuestsPlugin.getPlugin().getLoggerExpanded().logError("An error occured when finishing the quest", quester, new Object[0]));
    }

    @Override
    public void delete(boolean silently, boolean keepDatas) {
        this.questsManager.removeQuest(this);
        this.unload();
        if (this.hasOption(OptionStarterNPC.class)) {
            ((BqNpcImplementation)this.getOptionValueOrDef(OptionStarterNPC.class)).removeQuest(this);
        }
        if (!keepDatas) {
            BeautyQuests.getInstance().getQuesterManager().getDataManager().resetQuestData(this.id).whenComplete(QuestsPlugin.getPlugin().getLoggerExpanded().logError("An error occurred while removing player datas after quest removal", new Object[0]));
            if (this.file.exists()) {
                this.file.delete();
            }
        }
        this.removed = true;
        Bukkit.getPluginManager().callEvent((Event)new QuestRemoveEvent(this));
        if (!keepDatas) {
            QuestsAPI.getAPI().propagateQuestsHandlers(handler -> handler.questRemove(this));
        }
        if (!silently) {
            QuestsPlugin.getPlugin().getLoggerExpanded().info("The quest \"" + this.getName() + "\" has been removed");
        }
    }

    public void unload() {
        QuestsAPI.getAPI().propagateQuestsHandlers(handler -> handler.questUnload(this));
        this.manager.remove();
        this.options.forEach(QuestOption::detach);
    }

    public String toString() {
        return "Quest{id=" + this.id + ", npcID=, branches=" + this.manager.toString() + ", name=" + this.getName() + "}";
    }

    public boolean saveToFile() throws IOException, DataSavingException {
        String oldQuestDatas;
        String questData;
        YamlConfiguration fc = new YamlConfiguration();
        this.save((ConfigurationSection)fc);
        Path path = this.file.toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
        if ((questData = fc.saveToString()).equals(oldQuestDatas = new String(Files.readAllBytes(path), StandardCharsets.UTF_8))) {
            return false;
        }
        Files.write(path, questData.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return true;
    }

    private void save(@NotNull ConfigurationSection section) throws DataSavingException {
        for (QuestOption<?> option : this.options) {
            try {
                if (!option.hasCustomValue()) continue;
                section.set(option.getOptionCreator().id, option.save());
            }
            catch (Exception ex) {
                throw new DataSavingException("Failed to save option " + option.getOptionCreator().id, ex);
            }
        }
        this.manager.save(section.createSection("manager"));
        section.set("id", (Object)this.id);
    }

    @NotNull
    public static QuestImplementation loadFromFile(@NotNull QuestsManagerImplementation questsManager, @NotNull File file) throws DataLoadingException {
        YamlConfiguration map;
        try {
            YamlConfiguration config = new YamlConfiguration();
            config.load(file);
            map = config;
        }
        catch (Exception e) {
            throw new DataLoadingException("Error when loading quest from data file", e);
        }
        if (!map.contains("id")) {
            throw new DataLoadingException("Quest doesn't have an id.");
        }
        QuestImplementation qu = new QuestImplementation(questsManager, map.getInt("id"), file);
        qu.manager = BranchesManagerImplementation.deserialize(map.getConfigurationSection("manager"), qu);
        Set keys = map.getKeys(false);
        keys.remove("id");
        keys.remove("manager");
        Iterator iterator = keys.iterator();
        block4: while (iterator.hasNext()) {
            String key = (String)iterator.next();
            for (QuestOptionCreator<?, ?> creator : QuestsAPI.getAPI().getQuestOptions()) {
                if (!creator.applies(key)) continue;
                try {
                    QuestOption option = (QuestOption)creator.optionSupplier.get();
                    option.load((ConfigurationSection)map, key);
                    qu.addOption(option);
                    iterator.remove();
                }
                catch (Exception ex) {
                    QuestsManagerImplementation.LOGGER.severe("An exception occured when loading the option {} for quest {}", ex, key, qu.id);
                }
                continue block4;
            }
        }
        if (!keys.isEmpty()) {
            QuestsManagerImplementation.LOGGER.severe("Some options have not been loaded for quest {0}: {1}", qu.id, keys);
            questsManager.getPlugin().notifyLoadingFailure();
        }
        return qu;
    }
}

