/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.structure;

import com.google.gson.JsonSyntaxException;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.questers.events.QuesterJoinEvent;
import fr.skytasul.quests.api.questers.events.QuesterLeaveEvent;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.StageHandler;
import fr.skytasul.quests.api.stages.StageIndex;
import fr.skytasul.quests.api.stages.StageType;
import fr.skytasul.quests.api.stages.options.StageOption;
import fr.skytasul.quests.api.stages.options.StageQuesterStrategy;
import fr.skytasul.quests.api.utils.CustomizedObjectTypeAdapter;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.structure.QuestBranchImplementation;
import fr.skytasul.quests.utils.QuestUtils;
import fr.skytasul.quests.utils.compatibility.BQBackwardCompat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StageControllerImplementation<T extends AbstractStage>
implements StageController,
Listener {
    @NotNull
    private final QuestBranchImplementation branch;
    @NotNull
    private final StageType<T> type;
    @Nullable
    private T stage;

    public StageControllerImplementation(@NotNull QuestBranchImplementation branch, @NotNull StageType<T> type) {
        this.branch = Objects.requireNonNull(branch);
        this.type = Objects.requireNonNull(type);
    }

    public void setStage(@NotNull T stage) {
        if (this.stage != null) {
            throw new IllegalStateException("Stage was already set");
        }
        this.type.getStageClass().cast(stage);
        this.stage = (AbstractStage)Objects.requireNonNull(stage);
    }

    @Override
    @NotNull
    public QuestBranchImplementation getBranch() {
        return this.branch;
    }

    @Override
    @NotNull
    public AbstractStage getStage() {
        if (this.stage == null) {
            throw new IllegalStateException("Stage has not been loaded yet");
        }
        return this.stage;
    }

    @NotNull
    public StageType<T> getStageType() {
        if (this.type == null) {
            throw new IllegalStateException("Stage has not been loaded yet");
        }
        return this.type;
    }

    @Override
    public void finishStage(@NotNull Quester quester) {
        QuestUtils.runSync(() -> this.branch.finishPlayerStage(quester, this));
    }

    @Override
    public boolean hasStarted(@NotNull Quester acc) {
        return this.branch.hasStageLaunched(acc, this);
    }

    @Override
    @NotNull
    public Collection<Quester> getApplicableQuesters(@NotNull Player player) {
        Optional<? extends Quester> optQuester = this.branch.getQuest().getQuesterStrategy().getPlayerQuester(player);
        if (optQuester.isEmpty() || !this.hasStarted(optQuester.get())) {
            return List.of();
        }
        HashSet<Quester> questers = new HashSet<Quester>();
        questers.add(optQuester.get());
        for (StageOption option : ((AbstractStage)this.stage).getOptions()) {
            if (!(option instanceof StageQuesterStrategy)) continue;
            StageQuesterStrategy strategy = (StageQuesterStrategy)((Object)option);
            for (Quester quester : strategy.getAdditionalQuesters(player)) {
                if (!this.hasStarted(quester)) continue;
                questers.add(quester);
            }
        }
        return questers;
    }

    @Override
    public boolean hasApplicableQuester(@NotNull Player player) {
        Optional<? extends Quester> optQuester = this.branch.getQuest().getQuesterStrategy().getPlayerQuester(player);
        return optQuester.isPresent() && this.hasStarted(optQuester.get());
    }

    @Override
    public void updateObjective(@NotNull Quester quester, @NotNull String dataKey, @Nullable Object dataValue) {
        QuesterQuestData questData = quester.getDataHolder().getQuestData(this.branch.getQuest());
        Map<String, Object> datas = questData.getStageData(this.getStorageId());
        if (datas == null) {
            QuestsPlugin.getPlugin().getLoggerExpanded().severe("Quester {} did not have data for {}. Creating some.", quester.getDetailedName(), this.toString());
            datas = new HashMap<String, Object>();
            ((AbstractStage)this.stage).initPlayerDatas(quester, datas);
        }
        datas.put(dataKey, dataValue);
        questData.setStageData(this.getStorageId(), datas);
        this.propagateStageHandlers(handler -> handler.stageUpdated(quester, this));
        this.branch.getManager().questUpdated(quester);
    }

    @Nullable
    public <D> D getData(@NotNull Quester acc, @NotNull String dataKey, @Nullable Class<D> dataType) {
        QuesterQuestData playerDatas = acc.getDataHolder().getQuestData(this.branch.getQuest());
        Map<String, Object> datas = playerDatas.getStageData(this.getStorageId());
        if (datas == null) {
            if (!this.hasStarted(acc)) {
                throw new IllegalStateException("Trying to fetch data of not launched stage");
            }
            QuestsPlugin.getPlugin().getLoggerExpanded().severe("Quester {} did not have data for {}. Creating some.", acc.getDetailedName(), this);
            datas = new HashMap<String, Object>();
            ((AbstractStage)this.stage).initPlayerDatas(acc, datas);
            acc.getDataHolder().getQuestData(this.branch.getQuest()).setStageData(this.getStorageId(), datas);
        }
        Object data = datas.get(dataKey);
        if (dataType == null) {
            return (D)data;
        }
        if (dataType.isInstance(data)) {
            return dataType.cast(data);
        }
        String serialized = CustomizedObjectTypeAdapter.serializeNullable(data);
        try {
            return CustomizedObjectTypeAdapter.deserializeNullable(serialized, dataType);
        }
        catch (JsonSyntaxException ex) {
            QuestsPlugin.getPlugin().getLoggerExpanded().severe("Cannot convert data " + dataKey + " to " + dataType.toString() + ". Serialized form: " + serialized);
            throw ex;
        }
    }

    @Override
    @Nullable
    public String getDescriptionLine(@NotNull Quester acc, @NotNull DescriptionSource source) {
        try {
            Object description = ((AbstractStage)this.stage).getCustomText();
            if (description != null) {
                if (((String)description).equals("none")) {
                    return null;
                }
                description = "\u00a7e" + (String)description;
            }
            StageDescriptionPlaceholdersContext context = StageDescriptionPlaceholdersContext.of(true, acc, source, null);
            if (description == null) {
                description = ((AbstractStage)this.stage).getDefaultDescription(context);
            }
            return MessageUtils.finalFormat((String)description, ((AbstractStage)this.stage).getPlaceholdersRegistry(), context);
        }
        catch (Exception ex) {
            QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while getting the description line for {} in {}", ex, acc.getDetailedName(), this);
            return "\u00a7a" + this.type.getName();
        }
    }

    private void propagateStageHandlers(@NotNull @NotNull Consumer<@NotNull StageHandler> consumer) {
        Consumer<StageHandler> newConsumer = handler -> {
            try {
                consumer.accept((StageHandler)handler);
            }
            catch (Exception ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while updating stage handler.", ex);
            }
        };
        QuestsAPI.getAPI().getQuestsHandlers().forEach(newConsumer);
        ((AbstractStage)this.stage).getOptions().forEach(newConsumer);
    }

    public void start(@NotNull Quester acc) {
        MessageUtils.sendMessage(acc, ((AbstractStage)this.stage).getStartMessage(), (MessageType)MessageType.DefaultMessageType.OFF);
        HashMap<String, Object> datas = new HashMap<String, Object>();
        ((AbstractStage)this.stage).initPlayerDatas(acc, datas);
        acc.getDataHolder().getQuestData(this.branch.getQuest()).setStageData(this.getStorageId(), datas);
        this.propagateStageHandlers(handler -> handler.stageStart(acc, this));
        ((AbstractStage)this.stage).started(acc);
    }

    public void end(@NotNull Quester acc) {
        acc.getDataHolder().getQuestData(this.branch.getQuest()).setStageData(this.getStorageId(), null);
        this.propagateStageHandlers(handler -> handler.stageEnd(acc, this));
        ((AbstractStage)this.stage).ended(acc);
    }

    public void load() {
        QuestUtils.autoRegister(this.stage);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BeautyQuests.getInstance());
        this.propagateStageHandlers(handler -> handler.stageLoad(this));
        ((AbstractStage)this.stage).load();
    }

    public void unload() {
        QuestUtils.autoUnregister(this.stage);
        HandlerList.unregisterAll((Listener)this);
        this.propagateStageHandlers(handler -> handler.stageUnload(this));
        ((AbstractStage)this.stage).unload();
    }

    @EventHandler
    public void onJoin(QuesterJoinEvent e) {
        if (e.isFirstJoin()) {
            return;
        }
        if (this.hasStarted(e.getQuester())) {
            this.propagateStageHandlers(handler -> handler.stageJoin(e.getPlayer(), e.getQuester(), this));
            ((AbstractStage)this.stage).joined(e.getPlayer(), e.getQuester());
        }
    }

    @EventHandler
    public void onLeave(QuesterLeaveEvent e) {
        if (this.hasStarted(e.getQuester())) {
            this.propagateStageHandlers(handler -> handler.stageLeave(e.getPlayer(), e.getQuester(), this));
            ((AbstractStage)this.stage).left(e.getPlayer(), e.getQuester());
        }
    }

    @Override
    @NotNull
    public StageIndex getIndex() {
        return this.branch.getStageIndex(this);
    }

    private int getStorageId() {
        return this.branch.isEndingStage(this) ? this.branch.getEndingStageId(this) : this.branch.getRegularStageId(this);
    }

    public String toString() {
        String flowId;
        try {
            flowId = this.getIndex().toString();
        }
        catch (Exception ex) {
            flowId = "unknown";
        }
        return "stage " + flowId + " (" + this.type.getID() + ") of quest " + this.branch.getQuest().getId() + ", branch " + this.branch.getId();
    }

    @NotNull
    public static StageControllerImplementation<?> loadFromConfig(@NotNull QuestBranchImplementation branch, @NotNull ConfigurationSection section) {
        String typeID = section.getString("stageType");
        Optional<StageType<?>> stageType = QuestsAPI.getAPI().getStages().getType(typeID);
        if (!stageType.isPresent()) {
            stageType = BQBackwardCompat.loadStageFromConfig(typeID, section);
        }
        return StageControllerImplementation.loadFromConfig(branch, section, stageType.orElseThrow(() -> new IllegalArgumentException("Unknown stage type " + typeID)));
    }

    @NotNull
    private static <T extends AbstractStage> StageControllerImplementation<T> loadFromConfig(@NotNull QuestBranchImplementation branch, @NotNull ConfigurationSection section, StageType<T> type) {
        StageControllerImplementation<T> controller = new StageControllerImplementation<T>(branch, type);
        T stage = type.getLoader().supply(section, controller);
        controller.setStage(stage);
        ((AbstractStage)stage).load(section);
        return controller;
    }
}

