/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.structure.pools;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.players.PlayerQuester;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.data.QuesterPoolData;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.requirements.RequirementList;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.npcs.BqNpcImplementation;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestPoolImplementation
implements Comparable<QuestPoolImplementation>,
QuestPool {
    private final int id;
    private String npcId;
    private final String hologram;
    private final int maxQuests;
    private final int questsPerLaunch;
    private final boolean redoAllowed;
    private final long timeDiff;
    private final boolean avoidDuplicates;
    private final RequirementList requirements;
    BqNpcImplementation npc;
    List<Quest> quests = new ArrayList<Quest>();
    @Nullable
    private PlaceholderRegistry placeholders;

    QuestPoolImplementation(int id, String npcID, String hologram, int maxQuests, int questsPerLaunch, boolean redoAllowed, long timeDiff, boolean avoidDuplicates, RequirementList requirements) {
        this.id = id;
        this.npcId = npcID;
        this.hologram = hologram;
        this.maxQuests = maxQuests;
        this.questsPerLaunch = questsPerLaunch;
        this.redoAllowed = redoAllowed;
        this.timeDiff = timeDiff;
        this.avoidDuplicates = avoidDuplicates;
        this.requirements = requirements;
        if (npcID != null) {
            this.npc = BeautyQuests.getInstance().getNpcManager().getById(npcID);
            if (this.npc != null) {
                this.npcId = this.npc.getId();
                this.npc.addPool(this);
                return;
            }
        }
        QuestsPlugin.getPlugin().getLoggerExpanded().warning("Unknown NPC " + npcID + " for quest pool #" + id);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getNpcId() {
        return this.npcId;
    }

    @Override
    public String getHologram() {
        return this.hologram;
    }

    @Override
    public int getMaxQuests() {
        return this.maxQuests;
    }

    @Override
    public int getQuestsPerLaunch() {
        return this.questsPerLaunch;
    }

    @Override
    public boolean isRedoAllowed() {
        return this.redoAllowed;
    }

    @Override
    public long getTimeDiff() {
        return this.timeDiff;
    }

    @Override
    public boolean doAvoidDuplicates() {
        return this.avoidDuplicates;
    }

    @Override
    public RequirementList getRequirements() {
        return this.requirements;
    }

    @Override
    public List<Quest> getQuests() {
        return this.quests;
    }

    @Override
    public void addQuest(Quest quest) {
        this.quests.add(quest);
    }

    @Override
    public void removeQuest(Quest quest) {
        this.quests.remove(quest);
    }

    @Override
    public int compareTo(QuestPoolImplementation o) {
        return Integer.compare(this.id, o.id);
    }

    @Override
    @NotNull
    public PlaceholderRegistry getPlaceholdersRegistry() {
        if (this.placeholders == null) {
            this.placeholders = new PlaceholderRegistry().registerIndexed("pool", "#" + this.id).register("pool_id", this.id).register("pool_npc", () -> this.npcId + " (" + (this.npc == null ? "unknown" : this.npc.getNpc().getName()) + ")").register("pool_max_quests", this.maxQuests).register("pool_quests_per_launch", this.questsPerLaunch).register("pool_redo", MessageUtils.getYesNo(this.redoAllowed)).register("pool_duplicates", MessageUtils.getYesNo(this.avoidDuplicates)).register("pool_time", Utils.millisToHumanString(this.timeDiff)).register("pool_hologram", QuestOption.formatNullableValue((Object)this.hologram, Lang.PoolHologramText)).register("pool_quests", () -> this.quests.stream().map(x -> "#" + x.getId()).collect(Collectors.joining(", "))).register("pool_quests_amount", () -> Integer.toString(this.quests.size()));
        }
        return this.placeholders;
    }

    @Override
    public ItemStack getItemStack(String action) {
        return ItemUtils.item(XMaterial.CHEST, Lang.poolItemName.format((HasPlaceholders)this), Lang.poolItemNPC.format((HasPlaceholders)this), Lang.poolItemMaxQuests.format((HasPlaceholders)this), Lang.poolItemQuestsPerLaunch.format((HasPlaceholders)this), Lang.poolItemRedo.format((HasPlaceholders)this), Lang.poolItemTime.format((HasPlaceholders)this), Lang.poolItemHologram.format((HasPlaceholders)this), Lang.poolItemAvoidDuplicates.format((HasPlaceholders)this), "\u00a77" + this.requirements.getSizeString(), Lang.poolItemQuestsList.format((HasPlaceholders)this), "", action);
    }

    @Override
    public CompletableFuture<Boolean> resetPlayer(Quester acc) {
        return acc.getDataHolder().removePoolData(this).thenApply(__ -> true);
    }

    @Override
    public void resetPlayerTimer(Quester acc) {
        acc.getDataHolder().getPoolDataIfPresent(this).ifPresent(data -> data.setLastGive(0L));
    }

    public void questCompleted(Quester acc, Quest quest) {
        if (!this.avoidDuplicates) {
            return;
        }
        QuesterPoolData poolDatas = acc.getDataHolder().getPoolData(this);
        Set<Integer> completedQuests = poolDatas.getCompletedQuests();
        completedQuests.add(quest.getId());
        poolDatas.setCompletedQuests(completedQuests);
    }

    @Override
    @NotNull
    public QuestPool.CanGiveResult canGive(Player p) {
        List<Quest> notDoneQuests;
        long time;
        PlayerQuester quester = PlayerManager.getPlayerAccount(p);
        Optional<QuesterPoolData> data = quester.getDataHolder().getPoolDataIfPresent(this);
        if (data.isPresent() && (time = data.get().getLastGive() + this.timeDiff - System.currentTimeMillis()) > 0L) {
            return new QuestPool.CanGiveResult(false, Lang.POOL_NO_TIME.quickFormat("time_left", Utils.millisToHumanString(time)));
        }
        RequirementList.MatchResult requirementsMatch = this.requirements.allMatch(p);
        if (!requirementsMatch.result()) {
            return new QuestPool.CanGiveResult(false, requirementsMatch.reason());
        }
        List<Quest> list = notDoneQuests = this.avoidDuplicates && data.isPresent() ? this.quests.stream().filter(quest -> !((QuesterPoolData)data.get()).getCompletedQuests().contains(quest.getId())).collect(Collectors.toList()) : this.quests;
        if (notDoneQuests.isEmpty()) {
            if (!this.redoAllowed || this.quests.stream().noneMatch(quest -> quest.isRepeatable() && quest.canStart(p, false))) {
                return new QuestPool.CanGiveResult(false, Lang.POOL_ALL_COMPLETED.toString());
            }
        } else if (quester.getDataHolder().getAllQuestsData().stream().filter(quest -> quest.hasStarted() && this.quests.contains(quest.getQuest())).count() >= (long)this.maxQuests) {
            return new QuestPool.CanGiveResult(false, Lang.POOL_MAX_QUESTS.format((HasPlaceholders)this));
        }
        if (notDoneQuests.stream().noneMatch(quest -> quest.canStart(p, false))) {
            return new QuestPool.CanGiveResult(false, Lang.POOL_NO_AVAILABLE.toString());
        }
        return new QuestPool.CanGiveResult(true, null);
    }

    @Override
    public CompletableFuture<String> give(Player p) {
        PlayerQuester quester = PlayerManager.getPlayerAccount(p);
        QuesterPoolData data = quester.getDataHolder().getPoolData(this);
        long time = data.getLastGive() + this.timeDiff - System.currentTimeMillis();
        if (time > 0L) {
            return CompletableFuture.completedFuture(Lang.POOL_NO_TIME.quickFormat("time_left", Utils.millisToHumanString(time)));
        }
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Quest> started = new ArrayList<Quest>(this.questsPerLaunch);
            try {
                for (int i = 0; i < this.questsPerLaunch; ++i) {
                    PoolGiveResult result = this.giveOne(p, quester, data, !started.isEmpty()).get();
                    if (result.quest != null) {
                        started.add(result.quest);
                        data.setLastGive(System.currentTimeMillis());
                        continue;
                    }
                    if (result.forceContinue) continue;
                    if (started.isEmpty()) {
                        return result.reason;
                    }
                    break;
                }
            }
            catch (InterruptedException ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("Interrupted!", ex);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                throw new CompletionException(ex);
            }
            return "started quest(s) " + started.stream().map(x -> "#" + x.getId()).collect(Collectors.joining(", "));
        });
    }

    private CompletableFuture<PoolGiveResult> giveOne(Player p, Quester acc, QuesterPoolData datas, boolean hadOne) {
        List available;
        List<Object> notStarted;
        List<Quest> notCompleted;
        if (!this.requirements.allMatch(p, !hadOne)) {
            return CompletableFuture.completedFuture(new PoolGiveResult(""));
        }
        List<Quest> list = notCompleted = this.avoidDuplicates ? this.quests.stream().filter(quest -> !datas.getCompletedQuests().contains(quest.getId())).collect(Collectors.toList()) : this.quests;
        if (notCompleted.isEmpty()) {
            notCompleted = this.replenishQuests(acc, datas);
            if (notCompleted.isEmpty()) {
                return CompletableFuture.completedFuture(new PoolGiveResult(Lang.POOL_ALL_COMPLETED.toString()));
            }
        } else if (acc.getDataHolder().getAllQuestsData().stream().filter(quest -> quest.hasStarted() && this.quests.contains(quest.getQuest())).count() >= (long)this.maxQuests) {
            return CompletableFuture.completedFuture(new PoolGiveResult(Lang.POOL_MAX_QUESTS.format((HasPlaceholders)this)));
        }
        if ((notStarted = notCompleted.stream().filter(quest -> !quest.hasStarted(acc)).collect(Collectors.toList())).isEmpty()) {
            notStarted = this.replenishQuests(acc, datas);
        }
        if ((available = notStarted.stream().filter(quest -> quest.canStart(p, false)).collect(Collectors.toList())).isEmpty()) {
            return CompletableFuture.completedFuture(new PoolGiveResult(Lang.POOL_NO_AVAILABLE.toString()));
        }
        CompletableFuture<PoolGiveResult> future = new CompletableFuture<PoolGiveResult>();
        QuestUtils.runOrSync(() -> {
            Quest quest = (Quest)available.get(ThreadLocalRandom.current().nextInt(available.size()));
            quest.attemptStart(p).whenComplete((result, exception) -> {
                if (exception != null) {
                    future.completeExceptionally((Throwable)exception);
                } else {
                    future.complete(result != false ? new PoolGiveResult(quest) : new PoolGiveResult("").forceContinue());
                }
            });
        });
        return future;
    }

    private List<Quest> replenishQuests(@NotNull Quester quester, @NotNull QuesterPoolData datas) {
        if (!this.redoAllowed) {
            return Collections.emptyList();
        }
        List<Quest> notDoneQuests = this.quests.stream().filter(Quest::isRepeatable).filter(quest -> !quest.hasStarted(quester)).collect(Collectors.toList());
        if (!notDoneQuests.isEmpty()) {
            datas.setCompletedQuests(this.quests.stream().filter(quest -> !notDoneQuests.contains(quest)).map(Quest::getId).collect(Collectors.toSet()));
        }
        QuestsPlugin.getPlugin().getLoggerExpanded().debug("Replenished available quests of {} for pool {}", quester.getDetailedName(), this.id);
        return notDoneQuests;
    }

    void unload() {
        if (this.npc != null) {
            this.npc.removePool(this);
        }
    }

    public void unloadStarter() {
        this.npc = null;
    }

    public void save(ConfigurationSection config) {
        config.set("hologram", (Object)this.hologram);
        config.set("maxQuests", (Object)this.maxQuests);
        if (this.questsPerLaunch != 1) {
            config.set("questsPerLaunch", (Object)this.questsPerLaunch);
        }
        config.set("redoAllowed", (Object)this.redoAllowed);
        config.set("timeDiff", (Object)this.timeDiff);
        config.set("npcID", (Object)this.npcId);
        config.set("avoidDuplicates", (Object)this.avoidDuplicates);
        if (!this.requirements.isEmpty()) {
            config.set("requirements", this.requirements.serialize());
        }
    }

    public static QuestPoolImplementation deserialize(int id, ConfigurationSection config) {
        return new QuestPoolImplementation(id, config.getString("npcID"), config.getString("hologram"), config.getInt("maxQuests"), config.getInt("questsPerLaunch", 1), config.getBoolean("redoAllowed"), config.getLong("timeDiff"), config.getBoolean("avoidDuplicates", true), RequirementList.deserialize(config.getMapList("requirements")));
    }

    private static class PoolGiveResult {
        private final Quest quest;
        private final String reason;
        private boolean forceContinue = false;

        public PoolGiveResult(Quest quest) {
            this.quest = quest;
            this.reason = null;
        }

        public PoolGiveResult(String reason) {
            this.quest = null;
            this.reason = reason;
        }

        public PoolGiveResult forceContinue() {
            this.forceContinue = true;
            return this;
        }
    }
}

