/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.structure.pools;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.pools.QuestPoolsManager;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.requirements.RequirementList;
import fr.skytasul.quests.options.OptionQuestPool;
import fr.skytasul.quests.structure.pools.QuestPoolImplementation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class QuestPoolsManagerImplementation
implements QuestPoolsManager {
    @NotNull
    private final BeautyQuests plugin;
    @NotNull
    private final File file;
    @NotNull
    private final YamlConfiguration config;
    private Map<Integer, QuestPoolImplementation> pools = new HashMap<Integer, QuestPoolImplementation>();

    public QuestPoolsManagerImplementation(@NotNull BeautyQuests plugin, @NotNull File file) throws IOException {
        this.plugin = plugin;
        this.file = file;
        if (!file.exists()) {
            this.config = new YamlConfiguration();
            this.config.options().copyHeader(true);
            this.config.options().header("This file describes configuration of the different quest pools. See \"/quests pool\".");
            this.config.save(file);
        } else {
            this.config = YamlConfiguration.loadConfiguration((File)file);
            for (String key : this.config.getKeys(false)) {
                try {
                    int id = Integer.parseInt(key);
                    QuestPoolImplementation pool = QuestPoolImplementation.deserialize(id, this.config.getConfigurationSection(key));
                    this.pools.put(id, pool);
                }
                catch (Exception ex) {
                    plugin.getLoggerExpanded().severe("An exception ocurred while loading quest pool {0}", ex, key);
                }
            }
            plugin.getLoggerExpanded().debug("Loaded {0} pools.", this.pools.size());
        }
    }

    public void save(@NotNull QuestPoolImplementation pool) {
        ConfigurationSection section = this.config.createSection(Integer.toString(pool.getId()));
        pool.save(section);
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateAll() throws IOException {
        for (QuestPoolImplementation pool : this.pools.values()) {
            pool.save(this.config.createSection(Integer.toString(pool.getId())));
        }
        this.config.save(this.file);
    }

    @Override
    @NotNull
    public QuestPoolImplementation createPool(@Nullable QuestPool editing, @Nullable String npcID, @Nullable String hologram, int maxQuests, int questsPerLaunch, boolean redoAllowed, long timeDiff, boolean avoidDuplicates, @NotNull RequirementList requirements) {
        if (editing != null) {
            ((QuestPoolImplementation)editing).unload();
        }
        QuestPoolImplementation pool = new QuestPoolImplementation(editing == null ? this.pools.keySet().stream().mapToInt(Integer::intValue).max().orElse(-1) + 1 : editing.getId(), npcID, hologram, maxQuests, questsPerLaunch, redoAllowed, timeDiff, avoidDuplicates, requirements);
        this.save(pool);
        this.pools.put(pool.getId(), pool);
        if (editing != null) {
            pool.quests = editing.getQuests();
            pool.quests.forEach(quest -> quest.getOption(OptionQuestPool.class).setValue(pool));
        }
        return pool;
    }

    @Override
    public void removePool(int id) {
        QuestPoolImplementation pool = this.pools.remove(id);
        if (pool == null) {
            return;
        }
        pool.unload();
        new ArrayList<Quest>(pool.quests).forEach(quest -> quest.removeOption(OptionQuestPool.class));
        this.config.set(Integer.toString(id), null);
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public QuestPoolImplementation getPool(int id) {
        return this.pools.get(id);
    }

    @Override
    @NotNull
    public @UnmodifiableView Collection<QuestPool> getPools() {
        return this.pools.values();
    }
}

