/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.utils;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;

public class Database
implements Closeable {
    private static final LoggerExpanded LOGGER = LoggerExpanded.get("BeautyQuests.Database");
    @NotNull
    private final QuestsConfiguration.Database config;
    private final DbType type;
    private final DataSource source;

    public Database(@NotNull QuestsConfiguration.Database config) throws IOException {
        Matcher matcher;
        this.config = config;
        Properties properties = new Properties();
        properties.load(this.getClass().getResourceAsStream("/hikari.properties"));
        HikariConfig hikariConfig = new HikariConfig(properties);
        Object connectionString = config.connectionString();
        if (connectionString == null || ((String)connectionString).isEmpty()) {
            connectionString = "jdbc:mysql://" + config.host() + ":" + config.port() + "/" + config.databaseName();
        }
        if ((matcher = Pattern.compile("^jdbc:(\\w+):\\/\\/").matcher((CharSequence)connectionString)).find()) {
            switch (matcher.group(1).toLowerCase()) {
                case "mysql": {
                    this.type = DbType.MySQL;
                    break;
                }
                case "postgresql": {
                    this.type = DbType.PostgreSQL;
                    break;
                }
                default: {
                    LOGGER.warning("Unsupported database provider: " + matcher.group(1));
                    this.type = DbType.MySQL;
                    break;
                }
            }
        } else {
            LOGGER.warning("Malformed database connection string!");
            this.type = DbType.MySQL;
        }
        hikariConfig.setJdbcUrl((String)connectionString);
        hikariConfig.setUsername(config.username());
        hikariConfig.setPassword(config.password());
        hikariConfig.setPoolName("BeautyQuests-SQL-pool");
        hikariConfig.setConnectionTimeout(20000L);
        boolean ssl = config.sslEnabled();
        hikariConfig.addDataSourceProperty("verifyServerCertificate", (Object)ssl);
        hikariConfig.addDataSourceProperty("useSSL", (Object)ssl);
        this.source = new HikariDataSource(hikariConfig);
        LOGGER.debug("Initialized database source. Type: " + this.type.name());
    }

    public void testConnection() throws SQLException {
        try (Connection connection = this.source.getConnection();){
            if (!connection.isValid(0)) {
                throw new SQLException("Could not establish database connection.");
            }
        }
    }

    @NotNull
    public QuestsConfiguration.Database getConfig() {
        return this.config;
    }

    public DbType getType() {
        return this.type;
    }

    @Override
    public void close() {
        LOGGER.info("Closing database pool...");
        try {
            ((Closeable)((Object)this.source)).close();
        }
        catch (IOException ex) {
            LOGGER.severe("An error occurred while closing database pool.", ex);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.source.getConnection();
    }

    public static enum DbType {
        MySQL("INT NOT NULL AUTO_INCREMENT", "TINYINT", "LONGTEXT"),
        PostgreSQL("SERIAL", "BOOLEAN", "TEXT");

        private final String serialType;
        private final String booleanType;
        private final String longTextType;

        private DbType(String serialType, String booleanType, String longTextType) {
            this.serialType = serialType;
            this.booleanType = booleanType;
            this.longTextType = longTextType;
        }

        public String getSerialType() {
            return this.serialType;
        }

        public String getBooleanType() {
            return this.booleanType;
        }

        public String getLongTextType() {
            return this.longTextType;
        }
    }
}

