/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.utils;

import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleEffect {
    private static Random random = new Random();
    @NotNull
    private final ParticleType type;
    @NotNull
    private final ParticleShape shape;
    @Nullable
    private final Color color;
    private final double[] colors;
    private final Object dustColor;

    public ParticleEffect(@NotNull Particle bukkitType, @NotNull ParticleShape shape, @Nullable Color color) {
        Validate.notNull((Object)bukkitType);
        this.type = new ParticleType(bukkitType);
        this.shape = shape;
        this.color = color;
        if (this.type.dustColored) {
            this.dustColor = new Particle.DustOptions(color, 1.0f);
            this.colors = null;
        } else if (this.type.colored && bukkitType != Particle.NOTE) {
            this.dustColor = null;
            this.colors = new double[3];
            this.colors[0] = color.getRed() == 0 ? 1.1754943508222875E-38 : (double)color.getRed() / 255.0;
            this.colors[1] = (double)color.getGreen() / 255.0;
            this.colors[2] = (double)color.getBlue() / 255.0;
        } else {
            this.dustColor = null;
            this.colors = null;
            color = null;
        }
    }

    @NotNull
    public Particle getParticle() {
        return this.type.particle;
    }

    @NotNull
    public ParticleShape getShape() {
        return this.shape;
    }

    @Nullable
    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return this.type.particle.name() + (String)(this.shape == null ? "" : " in shape " + this.shape.name()) + (String)(this.type.colored ? " with color " + (String)(this.type.particle != Particle.NOTE ? "R" + this.color.getRed() + " G" + this.color.getGreen() + " B" + this.color.getBlue() : "random") : "");
    }

    public void send(Entity entity, List<Player> players) {
        this.send(entity.getLocation(), entity.getHeight(), players);
    }

    public void send(Location bottom, double height, List<Player> players) {
        if (players.isEmpty()) {
            return;
        }
        switch (this.shape.ordinal()) {
            case 0: {
                this.sendParticle(bottom.add(0.0, height + 0.7, 0.0), players, 0.01, 0.01, 0.01, 2);
                break;
            }
            case 1: {
                this.sendParticle(bottom.add(0.0, height / 2.0, 0.0), players, 0.45, height / 2.0 + 0.1, 0.45, 1);
                break;
            }
            case 2: {
                this.sendParticle(bottom.add(0.0, height + 0.7, 0.0), players, 0.01, 0.15, 0.01, 3);
                break;
            }
            case 3: {
                this.sendParticle(bottom.add(0.0, height + 0.7, 0.0), players, 0.0, 0.0, 0.0, 1);
                this.sendParticle(bottom.add(0.0, 0.65, 0.0), players, 0.0, 0.2, 0.0, 5);
                break;
            }
            case 4: {
                this.sendParticle(bottom.add(0.0, height, 0.0), players, 0.2, 0.4, 0.2, 15);
            }
        }
    }

    public void sendParticle(Location lc, List<Player> players, double offX, double offY, double offZ, int amount) {
        double extra = 0.001;
        Object data = null;
        if (this.type.particle == Particle.NOTE) {
            offX = (double)random.nextInt(24) / 24.0;
            offY = 0.0;
            offZ = 0.0;
            amount = 0;
            extra = 1.0;
        } else if (this.dustColor != null) {
            data = this.dustColor;
        } else if (this.colors != null) {
            offX = this.colors[0];
            offY = this.colors[1];
            offZ = this.colors[2];
            amount = 0;
            extra = 1.0;
        }
        for (Player p : players) {
            if (p.getWorld() != lc.getWorld()) continue;
            p.spawnParticle(this.type.particle, lc, amount, offX, offY, offZ, extra, data);
        }
    }

    public void serialize(ConfigurationSection section) {
        section.set("particleEffect", (Object)this.type.particle.name());
        section.set("particleShape", (Object)this.shape.name());
        if (this.color != null) {
            section.set("particleColor", (Object)this.color.serialize());
        }
    }

    public static ParticleEffect deserialize(ConfigurationSection data) {
        return new ParticleEffect(Particle.valueOf((String)data.getString("particleEffect").toUpperCase()), ParticleShape.valueOf(data.getString("particleShape").toUpperCase()), data.contains("particleColor") ? Color.deserialize((Map)data.getConfigurationSection("particleColor").getValues(false)) : null);
    }

    public static boolean canHaveColor(Particle particle) {
        return particle.getDataType() == Particle.DustOptions.class;
    }

    private static class ParticleType {
        private final Particle particle;
        private final boolean colored;
        private final boolean dustColored;

        private ParticleType(Particle particle) {
            this.particle = particle;
            if (particle == Particle.NOTE) {
                this.colored = true;
                this.dustColored = false;
            } else if (particle.getDataType() == Particle.DustOptions.class) {
                this.colored = true;
                this.dustColored = true;
            } else {
                this.colored = false;
                this.dustColored = false;
            }
            if (particle.getDataType() != Void.class && !this.dustColored) {
                throw new IllegalArgumentException("Particle type " + particle.name() + " must have a " + particle.getDataType().getName() + " data");
            }
        }
    }

    public static enum ParticleShape {
        POINT,
        NEAR,
        BAR,
        EXCLAMATION,
        SPOT;

    }
}

