/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.utils;

import com.cryptomorin.xseries.XSound;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.QuestsConfigurationImplementation;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.utils.AutoRegistered;
import fr.skytasul.quests.api.utils.MinecraftVersion;
import fr.skytasul.quests.utils.nms.NMS;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.jetbrains.annotations.NotNull;

public final class QuestUtils {
    private static boolean cachedScoreboardPresent = false;
    private static long cachedScoreboardPresenceExp = 0L;

    private QuestUtils() {
    }

    public static Location upLocationForEntity(LivingEntity en, double value) {
        double height = value;
        height += QuestsConfigurationImplementation.getConfiguration().getHologramsHeight();
        height += en.getHeight();
        if (en instanceof Player) {
            if (cachedScoreboardPresenceExp < System.currentTimeMillis()) {
                cachedScoreboardPresenceExp = System.currentTimeMillis() + 60000L;
                boolean bl = cachedScoreboardPresent = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(DisplaySlot.BELOW_NAME) != null;
            }
            if (cachedScoreboardPresent) {
                height += 0.24;
            }
        }
        return en.getLocation().add(0.0, height, 0.0);
    }

    public static boolean isSimilar(ItemStack item1, ItemStack item2) {
        if (item2.getType() == item1.getType() && item2.getDurability() == item1.getDurability()) {
            try {
                return NMS.getNMS().equalsWithoutNBT(item1.getItemMeta(), item2.getItemMeta());
            }
            catch (ReflectiveOperationException ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while attempting to compare items using NMS", ex);
            }
        }
        return false;
    }

    public static void runOrSync(Runnable run) {
        if (Bukkit.isPrimaryThread()) {
            run.run();
        } else {
            Bukkit.getScheduler().runTask((Plugin)BeautyQuests.getInstance(), run);
        }
    }

    public static <T> BiConsumer<T, Throwable> runSyncConsumer(Runnable run) {
        return (__, ___) -> QuestUtils.runSync(run);
    }

    public static void runSync(Runnable run) {
        Bukkit.getScheduler().runTask((Plugin)BeautyQuests.getInstance(), run);
    }

    public static void runAsync(Runnable run) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BeautyQuests.getInstance(), run);
    }

    public static void tunnelEventCancelling(@NotNull Cancellable eventFrom, @NotNull Event eventTo) {
        Cancellable eventToCancellable = (Cancellable)eventTo;
        CompletableFuture cancelled = new CompletableFuture();
        QuestUtils.runOrSync(() -> {
            try {
                Bukkit.getPluginManager().callEvent(eventTo);
                cancelled.complete(eventToCancellable.isCancelled());
            }
            catch (Exception ex) {
                cancelled.completeExceptionally(ex);
            }
        });
        try {
            eventFrom.setCancelled(((Boolean)cancelled.get()).booleanValue());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
    }

    private static XSound.Record getSoundRecord(String sound) {
        Optional xsoundOpt = XSound.of((String)sound);
        if (xsoundOpt.isPresent()) {
            return ((XSound)xsoundOpt.get()).record();
        }
        QuestsPlugin.getPlugin().getLoggerExpanded().warning("Cannot find sound {0}", sound);
        return new XSound.Record().withSound(sound);
    }

    public static void playPluginSound(Audience audience, String sound, float volume) {
        QuestUtils.playPluginSound(audience, sound, volume, 1.0f);
    }

    public static void playPluginSound(Audience audience, String sound, float volume, float pitch) {
        if (!QuestsConfigurationImplementation.getConfiguration().getQuestsConfig().sounds()) {
            return;
        }
        if ("none".equals(sound)) {
            return;
        }
        ArrayList players = new ArrayList();
        audience.forEachAudience(aud -> aud.get(Identity.UUID).map(Bukkit::getPlayer).ifPresent(players::add));
        XSound.Record soundRecord = QuestUtils.getSoundRecord(sound).withPitch(pitch).withVolume(volume);
        for (Player p : players) {
            soundRecord.soundPlayer().forPlayers(new Player[]{p}).play();
        }
    }

    public static void playPluginSound(Location lc, String sound, float volume) {
        if (!QuestsConfigurationImplementation.getConfiguration().getQuestsConfig().sounds()) {
            return;
        }
        if ("none".equals(sound)) {
            return;
        }
        XSound.Record soundRecord = QuestUtils.getSoundRecord(sound).withVolume(volume);
        soundRecord.soundPlayer().atLocation(lc).play();
    }

    public static void spawnFirework(Location lc, FireworkMeta meta) {
        if (!QuestsConfiguration.getConfig().getQuestsConfig().fireworks() || meta == null) {
            return;
        }
        QuestUtils.runOrSync(() -> {
            Consumer<Firework> fwConsumer = fw -> {
                fw.setMetadata("questFinish", (MetadataValue)new FixedMetadataValue((Plugin)BeautyQuests.getInstance(), (Object)true));
                fw.setFireworkMeta(meta);
            };
            if (MinecraftVersion.isHigherThan(20, 6)) {
                lc.getWorld().spawn(lc, Firework.class, fw -> fwConsumer.accept((Firework)fw));
            } else {
                fwConsumer.accept((Firework)lc.getWorld().spawn(lc, Firework.class));
            }
        });
    }

    public static boolean hasAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        if (clazz.isAnnotationPresent(annotation)) {
            return true;
        }
        if (!annotation.isAnnotationPresent(Inherited.class)) {
            return false;
        }
        for (Class<?> interf : clazz.getInterfaces()) {
            if (!QuestUtils.hasAnnotation(interf, annotation)) continue;
            return true;
        }
        return false;
    }

    public static void autoRegister(Object object) {
        if (!QuestUtils.hasAnnotation(object.getClass(), AutoRegistered.class)) {
            throw new IllegalArgumentException("The class " + object.getClass().getName() + " does not have the @AutoRegistered annotation and thus cannot be automatically registered as an events listener.");
        }
        if (object instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)object, (Plugin)BeautyQuests.getInstance());
        }
    }

    public static void autoUnregister(Object object) {
        if (!QuestUtils.hasAnnotation(object.getClass(), AutoRegistered.class)) {
            throw new IllegalArgumentException("The class " + object.getClass().getName() + " does not have the @AutoRegistered annotation and thus cannot be automatically registered as an events listener.");
        }
        if (object instanceof Listener) {
            HandlerList.unregisterAll((Listener)((Listener)object));
        }
    }
}

