/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectUtils {
    private String pack;

    private ReflectUtils(String pack) {
        this.pack = pack;
    }

    public Class<?> fromName(String className) {
        try {
            return Class.forName(this.pack + className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Class<?> fromNameDotName(String before, String after) throws ClassNotFoundException {
        return ReflectUtils.getClassDotClass(this.fromName(before), after);
    }

    public static ReflectUtils fromPackage(String pack) {
        return new ReflectUtils(pack + ".");
    }

    public static Class<?> getClassDotClass(Class<?> clazz, String after) throws ClassNotFoundException {
        for (Class<?> c : clazz.getClasses()) {
            if (!c.getSimpleName().equals(after)) continue;
            return c;
        }
        throw new ClassNotFoundException(clazz.getName() + "." + after);
    }

    public Object fromEnum(String name, int ordinal) {
        try {
            return ReflectUtils.fromEnum(Class.forName(this.pack + name), ordinal);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object fromEnum(Class<?> clazz, int ordinal) {
        return clazz.getEnumConstants()[ordinal];
    }

    public static Object getFieldValue(Field field, Object instance) throws ReflectiveOperationException {
        field.setAccessible(true);
        return field.get(instance);
    }

    public static void setFieldValue(Field field, Object instance, Object object) throws ReflectiveOperationException {
        field.setAccessible(true);
        field.set(instance, object);
    }

    public static String listConstructors(Class<?> clazz) {
        String s = "s" + clazz.getDeclaredConstructors().length + " ";
        for (Constructor<?> c : clazz.getDeclaredConstructors()) {
            s = s + String.valueOf(c.getParameterTypes()) + "; ";
        }
        return s;
    }

    public static void invoke(Object obj, Method method, Object ... params) throws ReflectiveOperationException {
        method.setAccessible(true);
        method.invoke(obj, params);
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... params) throws ReflectiveOperationException {
        constructor.setAccessible(true);
        return constructor.newInstance(params);
    }
}

