/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.utils.logger;

import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BqLoggerHandler
extends FileHandler {
    public BqLoggerHandler(Plugin plugin) throws IOException {
        super(plugin.getDataFolder().toPath().resolve("latest.log").toString(), 0, 2);
        super.setFormatter(new BqLoggerFormatter());
        super.setLevel(LoggerExpanded.DEBUG_LEVEL);
        Files.deleteIfExists(plugin.getDataFolder().toPath().resolve("latest.log_old"));
        Files.deleteIfExists(plugin.getDataFolder().toPath().resolve("latest.log"));
    }

    private class BqLoggerFormatter
    extends Formatter {
        private static final Pattern NOT_INDEXED_PARAM_PATTERN = Pattern.compile("\\{\\}");
        private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("[HH:mm:ss]");
        private final Date launchDate = new Date();
        private final List<String> seenErrors = new ArrayList<String>();

        private BqLoggerFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringBuilder stb = new StringBuilder();
            stb.append(DATE_FORMAT.format(Date.from(logRecord.getInstant())));
            if (logRecord.getLoggerName() != null) {
                stb.append(" [").append(logRecord.getLoggerName().replace("BeautyQuests.", "")).append(']');
            }
            stb.append(" [").append(logRecord.getLevel().getName()).append("] ");
            if (logRecord.getParameters() != null && logRecord.getMessage().contains("{}")) {
                logRecord.setMessage(this.fillNotIndexedParameters(logRecord.getMessage()));
            }
            stb.append(super.formatMessage(logRecord));
            if (logRecord.getThrown() != null) {
                String throwableStr;
                int throwableIndex;
                stb.append('\n');
                if (this.seenErrors.size() == 1000) {
                    this.seenErrors.clear();
                    stb.append("Too much errors have been memorized. Cleaned up.\n");
                }
                if ((throwableIndex = this.seenErrors.indexOf(throwableStr = this.throwableToString(logRecord.getThrown()))) == -1) {
                    throwableIndex = this.seenErrors.size();
                    this.seenErrors.add(throwableStr);
                    stb.append("ERROR #");
                    stb.append(throwableIndex);
                    stb.append(":\n");
                    stb.append(throwableStr);
                } else {
                    stb.append("ERROR #");
                    stb.append(throwableIndex);
                }
            }
            stb.append('\n');
            return stb.toString();
        }

        private String fillNotIndexedParameters(String message) {
            Matcher matcher = NOT_INDEXED_PARAM_PATTERN.matcher(message);
            StringBuilder stb = new StringBuilder();
            int i = 0;
            while (matcher.find()) {
                matcher.appendReplacement(stb, "{%d}".formatted(i));
                ++i;
            }
            matcher.appendTail(stb);
            return stb.toString();
        }

        @NotNull
        private String throwableToString(@NotNull Throwable ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.close();
            return sw.toString();
        }

        @Override
        public String getHead(Handler h) {
            return "---- BEAUTYQUESTS LOGGER - OPENED " + this.launchDate.toString() + " ----\n";
        }

        @Override
        public String getTail(Handler h) {
            Date endDate = new Date();
            return "Logger was open during %s.\n---- BEAUTYQUESTS LOGGER - CLOSED %s ----\n".formatted(Utils.millisToHumanString(endDate.getTime() - this.launchDate.getTime()), endDate);
        }
    }
}

